package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use.
 * <p>
 * We have both symbolic and concrete enums for every type.
 * <p>
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance sourceInstance;
 * DatabaseInstanceFromSnapshot.Builder.create(this, "Instance")
 *         .snapshotIdentifier("my-snapshot")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * DatabaseInstanceReadReplica.Builder.create(this, "ReadReplica")
 *         .sourceDatabaseInstance(sourceInstance)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-08T19:43:51.943Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD3,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD4,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD_NVME_DRIVE,
    /**
     * Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_PERFORMANCE,
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_COMPUTE,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY3,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY4,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5,
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD,
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD_NVME_DRIVE,
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_6TB_1,
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_9TB_1,
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_12TB_1,
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_18TB_1,
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_24TB_1,
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_EBS_OPTIMIZED,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON2_NVME_DRIVE,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE3,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE4,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5,
    /**
     * Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_INTEL,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_NVME_DRIVE,
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD,
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_HIGH_PERFORMANCE,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE2,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3_ENHANCED_NETWORK,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE_COMPUTE_1,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3_DENSE_NVME_DRIVE,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_OPTIMIZED,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE2,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3_AMD,
    /**
     * Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE4_GRAVITON,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA1,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_AMD_NVME_DRIVE,
    /**
     * Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5,
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5_GRAVITON2,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL2,
    /**
     * Parallel-processing optimized instances, 3nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3,
    /**
     * Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL4,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM1,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON,
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL,
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_AMD,
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON2_NVME_DRIVE,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_COMPUTE_MEMORY1,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE1,
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH1_INTEL,
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIDEO_TRANSCODING1,
    /**
     * High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING6_AMD,
}
