package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:23:13.964Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet extends software.amazon.awscdk.core.CfnResource {

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnEC2Fleet.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnEC2Fleet(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnEC2FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLaunchTemplateConfigs() {
        return this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateConfigs(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplateConfigs(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTargetCapacitySpecification() {
        return this.jsiiGet("targetCapacitySpecification", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTargetCapacitySpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTargetCapacitySpecification(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty value) {
        this.jsiiSet("targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getExcessCapacityTerminationPolicy() {
        return this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setExcessCapacityTerminationPolicy(final java.lang.String value) {
        this.jsiiSet("excessCapacityTerminationPolicy", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOnDemandOptions() {
        return this.jsiiGet("onDemandOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnDemandOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("onDemandOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOnDemandOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty value) {
        this.jsiiSet("onDemandOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getReplaceUnhealthyInstances() {
        return this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReplaceUnhealthyInstances(final java.lang.Boolean value) {
        this.jsiiSet("replaceUnhealthyInstances", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setReplaceUnhealthyInstances(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("replaceUnhealthyInstances", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSpotOptions() {
        return this.jsiiGet("spotOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSpotOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("spotOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSpotOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty value) {
        this.jsiiSet("spotOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTerminateInstancesWithExpiration() {
        return this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTerminateInstancesWithExpiration(final java.lang.Boolean value) {
        this.jsiiSet("terminateInstancesWithExpiration", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTerminateInstancesWithExpiration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("terminateInstancesWithExpiration", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setType(final java.lang.String value) {
        this.jsiiSet("type", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getValidFrom() {
        return this.jsiiGet("validFrom", java.lang.String.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setValidFrom(final java.lang.String value) {
        this.jsiiSet("validFrom", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getValidUntil() {
        return this.jsiiGet("validUntil", java.lang.String.class);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setValidUntil(final java.lang.String value) {
        this.jsiiSet("validUntil", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FleetLaunchTemplateConfigRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLaunchTemplateSpecification();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getOverrides();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object launchTemplateSpecification;
            private java.lang.Object overrides;

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param launchTemplateSpecification `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateSpecification(software.amazon.awscdk.core.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param launchTemplateSpecification `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of Overrides
             * @param overrides `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of Overrides
             * @param overrides `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder overrides(java.util.List<java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateConfigRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii$Proxy(launchTemplateSpecification, overrides);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateConfigRequestProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.launchTemplateSpecification = this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
                this.overrides = this.jsiiGet("overrides", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object launchTemplateSpecification, java.lang.Object overrides) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = launchTemplateSpecification;
                this.overrides = overrides;
            }

            @Override
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getLaunchTemplateSpecification() != null) {
                    obj.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    obj.set("overrides", om.valueToTree(this.getOverrides()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FleetLaunchTemplateOverridesRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAvailabilityZone();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceType();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMaxPrice();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getPriority();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSubnetId();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String availabilityZone;
            private java.lang.String instanceType;
            private java.lang.String maxPrice;
            private java.lang.Number priority;
            private java.lang.String subnetId;
            private java.lang.Number weightedCapacity;

            /**
             * Sets the value of AvailabilityZone
             * @param availabilityZone `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of InstanceType
             * @param instanceType `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of MaxPrice
             * @param maxPrice `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of Priority
             * @param priority `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of SubnetId
             * @param subnetId `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of WeightedCapacity
             * @param weightedCapacity `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateOverridesRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii$Proxy(availabilityZone, instanceType, maxPrice, priority, subnetId, weightedCapacity);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateOverridesRequestProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String instanceType;
            private final java.lang.String maxPrice;
            private final java.lang.Number priority;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.maxPrice = this.jsiiGet("maxPrice", java.lang.String.class);
                this.priority = this.jsiiGet("priority", java.lang.Number.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
                this.weightedCapacity = this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String availabilityZone, java.lang.String instanceType, java.lang.String maxPrice, java.lang.Number priority, java.lang.String subnetId, java.lang.Number weightedCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = availabilityZone;
                this.instanceType = instanceType;
                this.maxPrice = maxPrice;
                this.priority = priority;
                this.subnetId = subnetId;
                this.weightedCapacity = weightedCapacity;
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAvailabilityZone() != null) {
                    obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceType() != null) {
                    obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMaxPrice() != null) {
                    obj.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getPriority() != null) {
                    obj.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSubnetId() != null) {
                    obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FleetLaunchTemplateSpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLaunchTemplateId();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLaunchTemplateName();

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String launchTemplateId;
            private java.lang.String launchTemplateName;
            private java.lang.String version;

            /**
             * Sets the value of LaunchTemplateId
             * @param launchTemplateId `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of LaunchTemplateName
             * @param launchTemplateName `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii$Proxy(launchTemplateId, launchTemplateName, version);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationRequestProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.launchTemplateId = this.jsiiGet("launchTemplateId", java.lang.String.class);
                this.launchTemplateName = this.jsiiGet("launchTemplateName", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String launchTemplateId, java.lang.String launchTemplateName, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = launchTemplateId;
                this.launchTemplateName = launchTemplateName;
                this.version = version;
            }

            @Override
            public java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getLaunchTemplateId() != null) {
                    obj.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    obj.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getVersion() != null) {
                    obj.set("version", om.valueToTree(this.getVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OnDemandOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAllocationStrategy();

        /**
         * @return a {@link Builder} of {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String allocationStrategy;

            /**
             * Sets the value of AllocationStrategy
             * @param allocationStrategy `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OnDemandOptionsRequestProperty build() {
                return new Jsii$Proxy(allocationStrategy);
            }
        }

        /**
         * An implementation for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandOptionsRequestProperty {
            private final java.lang.String allocationStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.allocationStrategy = this.jsiiGet("allocationStrategy", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String allocationStrategy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = allocationStrategy;
            }

            @Override
            public java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAllocationStrategy() != null) {
                    obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandOptionsRequestProperty.Jsii$Proxy that = (OnDemandOptionsRequestProperty.Jsii$Proxy) o;

                return this.allocationStrategy != null ? this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy == null;
            }

            @Override
            public int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SpotOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAllocationStrategy();

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstanceInterruptionBehavior();

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getInstancePoolsToUseCount();

        /**
         * @return a {@link Builder} of {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String allocationStrategy;
            private java.lang.String instanceInterruptionBehavior;
            private java.lang.Number instancePoolsToUseCount;

            /**
             * Sets the value of AllocationStrategy
             * @param allocationStrategy `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param instanceInterruptionBehavior `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of InstancePoolsToUseCount
             * @param instancePoolsToUseCount `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instancePoolsToUseCount(java.lang.Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SpotOptionsRequestProperty build() {
                return new Jsii$Proxy(allocationStrategy, instanceInterruptionBehavior, instancePoolsToUseCount);
            }
        }

        /**
         * An implementation for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Number instancePoolsToUseCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.allocationStrategy = this.jsiiGet("allocationStrategy", java.lang.String.class);
                this.instanceInterruptionBehavior = this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
                this.instancePoolsToUseCount = this.jsiiGet("instancePoolsToUseCount", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String allocationStrategy, java.lang.String instanceInterruptionBehavior, java.lang.Number instancePoolsToUseCount) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = allocationStrategy;
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                this.instancePoolsToUseCount = instancePoolsToUseCount;
            }

            @Override
            public java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public java.lang.Number getInstancePoolsToUseCount() {
                return this.instancePoolsToUseCount;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getAllocationStrategy() != null) {
                    obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getInstancePoolsToUseCount() != null) {
                    obj.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsRequestProperty.Jsii$Proxy that = (SpotOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                return this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.equals(that.instancePoolsToUseCount) : that.instancePoolsToUseCount == null;
            }

            @Override
            public int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TagRequestProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnEC2Fleet.TagRequestProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnEC2Fleet.TagRequestProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnEC2Fleet.TagRequestProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagRequestProperty build() {
                return new Jsii$Proxy(key, value);
            }
        }

        /**
         * An implementation for {@link TagRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagRequestProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = key;
                this.value = value;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getKey() != null) {
                    obj.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagRequestProperty.Jsii$Proxy that = (TagRequestProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceType();

        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> tags;

            /**
             * Sets the value of ResourceType
             * @param resourceType `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of Tags
             * @param tags `CfnEC2Fleet.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tags(java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
                this.tags = this.jsiiGet("tags", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceType, java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = resourceType;
                this.tags = tags;
            }

            @Override
            public java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty> getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getResourceType() != null) {
                    obj.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    obj.set("tags", om.valueToTree(this.getTags()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TargetCapacitySpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTotalTargetCapacity();

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDefaultTargetCapacityType();

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getOnDemandTargetCapacity();

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSpotTargetCapacity();

        /**
         * @return a {@link Builder} of {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number totalTargetCapacity;
            private java.lang.String defaultTargetCapacityType;
            private java.lang.Number onDemandTargetCapacity;
            private java.lang.Number spotTargetCapacity;

            /**
             * Sets the value of TotalTargetCapacity
             * @param totalTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            /**
             * Sets the value of DefaultTargetCapacityType
             * @param defaultTargetCapacityType `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder defaultTargetCapacityType(java.lang.String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            /**
             * Sets the value of OnDemandTargetCapacity
             * @param onDemandTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder onDemandTargetCapacity(java.lang.Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            /**
             * Sets the value of SpotTargetCapacity
             * @param spotTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder spotTargetCapacity(java.lang.Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetCapacitySpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii$Proxy(totalTargetCapacity, defaultTargetCapacityType, onDemandTargetCapacity, spotTargetCapacity);
            }
        }

        /**
         * An implementation for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetCapacitySpecificationRequestProperty {
            private final java.lang.Number totalTargetCapacity;
            private final java.lang.String defaultTargetCapacityType;
            private final java.lang.Number onDemandTargetCapacity;
            private final java.lang.Number spotTargetCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.totalTargetCapacity = this.jsiiGet("totalTargetCapacity", java.lang.Number.class);
                this.defaultTargetCapacityType = this.jsiiGet("defaultTargetCapacityType", java.lang.String.class);
                this.onDemandTargetCapacity = this.jsiiGet("onDemandTargetCapacity", java.lang.Number.class);
                this.spotTargetCapacity = this.jsiiGet("spotTargetCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number totalTargetCapacity, java.lang.String defaultTargetCapacityType, java.lang.Number onDemandTargetCapacity, java.lang.Number spotTargetCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.totalTargetCapacity = java.util.Objects.requireNonNull(totalTargetCapacity, "totalTargetCapacity is required");
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                this.spotTargetCapacity = spotTargetCapacity;
            }

            @Override
            public java.lang.Number getTotalTargetCapacity() {
                return this.totalTargetCapacity;
            }

            @Override
            public java.lang.String getDefaultTargetCapacityType() {
                return this.defaultTargetCapacityType;
            }

            @Override
            public java.lang.Number getOnDemandTargetCapacity() {
                return this.onDemandTargetCapacity;
            }

            @Override
            public java.lang.Number getSpotTargetCapacity() {
                return this.spotTargetCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
                if (this.getDefaultTargetCapacityType() != null) {
                    obj.set("defaultTargetCapacityType", om.valueToTree(this.getDefaultTargetCapacityType()));
                }
                if (this.getOnDemandTargetCapacity() != null) {
                    obj.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                }
                if (this.getSpotTargetCapacity() != null) {
                    obj.set("spotTargetCapacity", om.valueToTree(this.getSpotTargetCapacity()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetCapacitySpecificationRequestProperty.Jsii$Proxy that = (TargetCapacitySpecificationRequestProperty.Jsii$Proxy) o;

                if (!totalTargetCapacity.equals(that.totalTargetCapacity)) return false;
                if (this.defaultTargetCapacityType != null ? !this.defaultTargetCapacityType.equals(that.defaultTargetCapacityType) : that.defaultTargetCapacityType != null) return false;
                if (this.onDemandTargetCapacity != null ? !this.onDemandTargetCapacity.equals(that.onDemandTargetCapacity) : that.onDemandTargetCapacity != null) return false;
                return this.spotTargetCapacity != null ? this.spotTargetCapacity.equals(that.spotTargetCapacity) : that.spotTargetCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.totalTargetCapacity.hashCode();
                result = 31 * result + (this.defaultTargetCapacityType != null ? this.defaultTargetCapacityType.hashCode() : 0);
                result = 31 * result + (this.onDemandTargetCapacity != null ? this.onDemandTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.spotTargetCapacity != null ? this.spotTargetCapacity.hashCode() : 0);
                return result;
            }
        }
    }
}
