package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkInterfacePermission`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:23:14.002Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnNetworkInterfacePermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAwsAccountId();

    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPermission();

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String awsAccountId;
        private java.lang.String networkInterfaceId;
        private java.lang.String permission;

        /**
         * Sets the value of AwsAccountId
         * @param awsAccountId `AWS::EC2::NetworkInterfacePermission.AwsAccountId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaceId
         * @param networkInterfaceId `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of Permission
         * @param permission `AWS::EC2::NetworkInterfacePermission.Permission`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder permission(java.lang.String permission) {
            this.permission = permission;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfacePermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnNetworkInterfacePermissionProps build() {
            return new Jsii$Proxy(awsAccountId, networkInterfaceId, permission);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInterfacePermissionProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String permission;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.awsAccountId = this.jsiiGet("awsAccountId", java.lang.String.class);
            this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
            this.permission = this.jsiiGet("permission", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String awsAccountId, java.lang.String networkInterfaceId, java.lang.String permission) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(awsAccountId, "awsAccountId is required");
            this.networkInterfaceId = java.util.Objects.requireNonNull(networkInterfaceId, "networkInterfaceId is required");
            this.permission = java.util.Objects.requireNonNull(permission, "permission is required");
        }

        @Override
        public java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public java.lang.String getPermission() {
            return this.permission;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            obj.set("permission", om.valueToTree(this.getPermission()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInterfacePermissionProps.Jsii$Proxy that = (CfnNetworkInterfacePermissionProps.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            return this.permission.equals(that.permission);
        }

        @Override
        public int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.permission.hashCode());
            return result;
        }
    }
}
