package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::TransitGateway`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:23:14.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnTransitGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getAmazonSideAsn();

    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAutoAcceptSharedAttachments();

    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDefaultRouteTableAssociation();

    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDefaultRouteTablePropagation();

    /**
     * `AWS::EC2::TransitGateway.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::EC2::TransitGateway.DnsSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDnsSupport();

    /**
     * `AWS::EC2::TransitGateway.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpnEcmpSupport();

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Number amazonSideAsn;
        private java.lang.String autoAcceptSharedAttachments;
        private java.lang.String defaultRouteTableAssociation;
        private java.lang.String defaultRouteTablePropagation;
        private java.lang.String description;
        private java.lang.String dnsSupport;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.String vpnEcmpSupport;

        /**
         * Sets the value of AmazonSideAsn
         * @param amazonSideAsn `AWS::EC2::TransitGateway.AmazonSideAsn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder amazonSideAsn(java.lang.Number amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        /**
         * Sets the value of AutoAcceptSharedAttachments
         * @param autoAcceptSharedAttachments `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder autoAcceptSharedAttachments(java.lang.String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        /**
         * Sets the value of DefaultRouteTableAssociation
         * @param defaultRouteTableAssociation `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder defaultRouteTableAssociation(java.lang.String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        /**
         * Sets the value of DefaultRouteTablePropagation
         * @param defaultRouteTablePropagation `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder defaultRouteTablePropagation(java.lang.String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::EC2::TransitGateway.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DnsSupport
         * @param dnsSupport `AWS::EC2::TransitGateway.DnsSupport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder dnsSupport(java.lang.String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::TransitGateway.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of VpnEcmpSupport
         * @param vpnEcmpSupport `AWS::EC2::TransitGateway.VpnEcmpSupport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpnEcmpSupport(java.lang.String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnTransitGatewayProps build() {
            return new Jsii$Proxy(amazonSideAsn, autoAcceptSharedAttachments, defaultRouteTableAssociation, defaultRouteTablePropagation, description, dnsSupport, tags, vpnEcmpSupport);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayProps {
        private final java.lang.Number amazonSideAsn;
        private final java.lang.String autoAcceptSharedAttachments;
        private final java.lang.String defaultRouteTableAssociation;
        private final java.lang.String defaultRouteTablePropagation;
        private final java.lang.String description;
        private final java.lang.String dnsSupport;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String vpnEcmpSupport;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.amazonSideAsn = this.jsiiGet("amazonSideAsn", java.lang.Number.class);
            this.autoAcceptSharedAttachments = this.jsiiGet("autoAcceptSharedAttachments", java.lang.String.class);
            this.defaultRouteTableAssociation = this.jsiiGet("defaultRouteTableAssociation", java.lang.String.class);
            this.defaultRouteTablePropagation = this.jsiiGet("defaultRouteTablePropagation", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.dnsSupport = this.jsiiGet("dnsSupport", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.vpnEcmpSupport = this.jsiiGet("vpnEcmpSupport", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number amazonSideAsn, java.lang.String autoAcceptSharedAttachments, java.lang.String defaultRouteTableAssociation, java.lang.String defaultRouteTablePropagation, java.lang.String description, java.lang.String dnsSupport, java.util.List<software.amazon.awscdk.core.CfnTag> tags, java.lang.String vpnEcmpSupport) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amazonSideAsn = amazonSideAsn;
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            this.description = description;
            this.dnsSupport = dnsSupport;
            this.tags = tags;
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public java.lang.Number getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public java.lang.String getAutoAcceptSharedAttachments() {
            return this.autoAcceptSharedAttachments;
        }

        @Override
        public java.lang.String getDefaultRouteTableAssociation() {
            return this.defaultRouteTableAssociation;
        }

        @Override
        public java.lang.String getDefaultRouteTablePropagation() {
            return this.defaultRouteTablePropagation;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getDnsSupport() {
            return this.dnsSupport;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getVpnEcmpSupport() {
            return this.vpnEcmpSupport;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getAmazonSideAsn() != null) {
                obj.set("amazonSideAsn", om.valueToTree(this.getAmazonSideAsn()));
            }
            if (this.getAutoAcceptSharedAttachments() != null) {
                obj.set("autoAcceptSharedAttachments", om.valueToTree(this.getAutoAcceptSharedAttachments()));
            }
            if (this.getDefaultRouteTableAssociation() != null) {
                obj.set("defaultRouteTableAssociation", om.valueToTree(this.getDefaultRouteTableAssociation()));
            }
            if (this.getDefaultRouteTablePropagation() != null) {
                obj.set("defaultRouteTablePropagation", om.valueToTree(this.getDefaultRouteTablePropagation()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsSupport() != null) {
                obj.set("dnsSupport", om.valueToTree(this.getDnsSupport()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpnEcmpSupport() != null) {
                obj.set("vpnEcmpSupport", om.valueToTree(this.getVpnEcmpSupport()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayProps.Jsii$Proxy that = (CfnTransitGatewayProps.Jsii$Proxy) o;

            if (this.amazonSideAsn != null ? !this.amazonSideAsn.equals(that.amazonSideAsn) : that.amazonSideAsn != null) return false;
            if (this.autoAcceptSharedAttachments != null ? !this.autoAcceptSharedAttachments.equals(that.autoAcceptSharedAttachments) : that.autoAcceptSharedAttachments != null) return false;
            if (this.defaultRouteTableAssociation != null ? !this.defaultRouteTableAssociation.equals(that.defaultRouteTableAssociation) : that.defaultRouteTableAssociation != null) return false;
            if (this.defaultRouteTablePropagation != null ? !this.defaultRouteTablePropagation.equals(that.defaultRouteTablePropagation) : that.defaultRouteTablePropagation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsSupport != null ? !this.dnsSupport.equals(that.dnsSupport) : that.dnsSupport != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpnEcmpSupport != null ? this.vpnEcmpSupport.equals(that.vpnEcmpSupport) : that.vpnEcmpSupport == null;
        }

        @Override
        public int hashCode() {
            int result = this.amazonSideAsn != null ? this.amazonSideAsn.hashCode() : 0;
            result = 31 * result + (this.autoAcceptSharedAttachments != null ? this.autoAcceptSharedAttachments.hashCode() : 0);
            result = 31 * result + (this.defaultRouteTableAssociation != null ? this.defaultRouteTableAssociation.hashCode() : 0);
            result = 31 * result + (this.defaultRouteTablePropagation != null ? this.defaultRouteTablePropagation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsSupport != null ? this.dnsSupport.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpnEcmpSupport != null ? this.vpnEcmpSupport.hashCode() : 0);
            return result;
        }
    }
}
