/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Arrays;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnInstance;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.InstanceProps;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.Instance")
public class Instance
extends Resource
implements IInstance {
    protected Instance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Instance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Instance(Construct scope, String id, InstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    public void addSecurityGroup(ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", Void.class, new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    public void addToRolePolicy(PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", Void.class, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addUserData(String ... commands) {
        this.jsiiCall("addUserData", Void.class, Arrays.stream(commands).toArray(Object[]::new));
    }

    @Override
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    public CfnInstance getInstance() {
        return (CfnInstance)((Object)this.jsiiGet("instance", CfnInstance.class));
    }

    @Override
    public String getInstanceAvailabilityZone() {
        return (String)this.jsiiGet("instanceAvailabilityZone", String.class);
    }

    @Override
    public String getInstanceId() {
        return (String)this.jsiiGet("instanceId", String.class);
    }

    @Override
    public String getInstancePrivateDnsName() {
        return (String)this.jsiiGet("instancePrivateDnsName", String.class);
    }

    @Override
    public String getInstancePrivateIp() {
        return (String)this.jsiiGet("instancePrivateIp", String.class);
    }

    @Override
    public String getInstancePublicDnsName() {
        return (String)this.jsiiGet("instancePublicDnsName", String.class);
    }

    @Override
    public String getInstancePublicIp() {
        return (String)this.jsiiGet("instancePublicIp", String.class);
    }

    public OperatingSystemType getOsType() {
        return (OperatingSystemType)((Object)this.jsiiGet("osType", OperatingSystemType.class));
    }

    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    public UserData getUserData() {
        return (UserData)((Object)this.jsiiGet("userData", UserData.class));
    }
}

