/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IConstruct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpoint;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.SelectedSubnets;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.VpcAttributes;
import software.amazon.awscdk.services.ec2.VpcLookupOptions;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.ec2.VpnConnection;
import software.amazon.awscdk.services.ec2.VpnConnectionOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.Vpc")
public class Vpc
extends Resource
implements IVpc {
    public static final String DEFAULT_CIDR_RANGE = (String)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_CIDR_RANGE", String.class);
    public static final List<SubnetConfiguration> DEFAULT_SUBNETS = (List)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_SUBNETS", List.class);

    protected Vpc(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Vpc(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Vpc(Construct scope, String id, VpcProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props}));
    }

    public Vpc(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")}));
    }

    public static IVpc fromLookup(Construct scope, String id, VpcLookupOptions options) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromLookup", IVpc.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public static IVpc fromVpcAttributes(Construct scope, String id, VpcAttributes attrs) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromVpcAttributes", IVpc.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Deprecated
    public GatewayVpcEndpoint addDynamoDbEndpoint(String id, List<SubnetSelection> subnets) {
        return (GatewayVpcEndpoint)this.jsiiCall("addDynamoDbEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), subnets});
    }

    @Deprecated
    public GatewayVpcEndpoint addDynamoDbEndpoint(String id) {
        return (GatewayVpcEndpoint)this.jsiiCall("addDynamoDbEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public GatewayVpcEndpoint addGatewayEndpoint(String id, GatewayVpcEndpointOptions options) {
        return (GatewayVpcEndpoint)this.jsiiCall("addGatewayEndpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public InterfaceVpcEndpoint addInterfaceEndpoint(String id, InterfaceVpcEndpointOptions options) {
        return (InterfaceVpcEndpoint)this.jsiiCall("addInterfaceEndpoint", InterfaceVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Deprecated
    public GatewayVpcEndpoint addS3Endpoint(String id, List<SubnetSelection> subnets) {
        return (GatewayVpcEndpoint)this.jsiiCall("addS3Endpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required"), subnets});
    }

    @Deprecated
    public GatewayVpcEndpoint addS3Endpoint(String id) {
        return (GatewayVpcEndpoint)this.jsiiCall("addS3Endpoint", GatewayVpcEndpoint.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public VpnConnection addVpnConnection(String id, VpnConnectionOptions options) {
        return (VpnConnection)this.jsiiCall("addVpnConnection", VpnConnection.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    protected List<ISubnet> selectSubnetObjects(SubnetSelection selection) {
        return Collections.unmodifiableList((List)this.jsiiCall("selectSubnetObjects", List.class, new Object[]{selection}));
    }

    protected List<ISubnet> selectSubnetObjects() {
        return Collections.unmodifiableList((List)this.jsiiCall("selectSubnetObjects", List.class, new Object[0]));
    }

    @Override
    public SelectedSubnets selectSubnets(SubnetSelection selection) {
        return (SelectedSubnets)this.jsiiCall("selectSubnets", SelectedSubnets.class, new Object[]{selection});
    }

    @Override
    public SelectedSubnets selectSubnets() {
        return (SelectedSubnets)this.jsiiCall("selectSubnets", SelectedSubnets.class, new Object[0]);
    }

    @Override
    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)this.jsiiGet("availabilityZones", List.class));
    }

    @Override
    public IDependable getInternetConnectivityEstablished() {
        return (IDependable)this.jsiiGet("internetConnectivityEstablished", IDependable.class);
    }

    @Override
    public List<ISubnet> getIsolatedSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("isolatedSubnets", List.class));
    }

    protected List<IConstruct> getNatDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("natDependencies", List.class));
    }

    @Override
    public List<ISubnet> getPrivateSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("privateSubnets", List.class));
    }

    @Override
    public List<ISubnet> getPublicSubnets() {
        return Collections.unmodifiableList((List)this.jsiiGet("publicSubnets", List.class));
    }

    public String getVpcCidrBlock() {
        return (String)this.jsiiGet("vpcCidrBlock", String.class);
    }

    public List<String> getVpcCidrBlockAssociations() {
        return Collections.unmodifiableList((List)this.jsiiGet("vpcCidrBlockAssociations", List.class));
    }

    public String getVpcDefaultNetworkAcl() {
        return (String)this.jsiiGet("vpcDefaultNetworkAcl", String.class);
    }

    public String getVpcDefaultSecurityGroup() {
        return (String)this.jsiiGet("vpcDefaultSecurityGroup", String.class);
    }

    @Override
    public String getVpcId() {
        return (String)this.jsiiGet("vpcId", String.class);
    }

    public List<String> getVpcIpv6CidrBlocks() {
        return Collections.unmodifiableList((List)this.jsiiGet("vpcIpv6CidrBlocks", List.class));
    }

    @Override
    public String getVpnGatewayId() {
        return (String)this.jsiiGet("vpnGatewayId", String.class);
    }

    protected Boolean getIncompleteSubnetDefinition() {
        return (Boolean)this.jsiiGet("incompleteSubnetDefinition", Boolean.class);
    }

    protected void setIncompleteSubnetDefinition(Boolean value) {
        this.jsiiSet("incompleteSubnetDefinition", Objects.requireNonNull(value, "incompleteSubnetDefinition is required"));
    }
}

