package software.amazon.awscdk.services.ec2;

/**
 * A client VPN authorization rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * ClientVpnEndpoint clientVpnEndpoint;
 * ClientVpnAuthorizationRule clientVpnAuthorizationRule = ClientVpnAuthorizationRule.Builder.create(this, "MyClientVpnAuthorizationRule")
 *         .cidr("cidr")
 *         // the properties below are optional
 *         .clientVpnEndoint(clientVpnEndpoint)
 *         .clientVpnEndpoint(clientVpnEndpoint)
 *         .description("description")
 *         .groupId("groupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-26T16:25:26.363Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnAuthorizationRule")
public class ClientVpnAuthorizationRule extends software.amazon.awscdk.core.Resource {

    protected ClientVpnAuthorizationRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClientVpnAuthorizationRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClientVpnAuthorizationRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleProps.Builder();
        }

        /**
         * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
         * <p>
         * @return {@code this}
         * @param cidr The IPv4 address range, in CIDR notation, of the network for which access is being authorized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(final java.lang.String cidr) {
            this.props.cidr(cidr);
            return this;
        }

        /**
         * A brief description of the authorization rule.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A brief description of the authorization rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
         * <p>
         * Default: - authorize all groups
         * <p>
         * @return {@code this}
         * @param groupId The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(final java.lang.String groupId) {
            this.props.groupId(groupId);
            return this;
        }

        /**
         * (deprecated) The client VPN endpoint to which to add the rule.
         * <p>
         * Default: clientVpnEndpoint is required
         * <p>
         * @return {@code this}
         * @deprecated Use `clientVpnEndpoint` instead
         * @param clientVpnEndoint The client VPN endpoint to which to add the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder clientVpnEndoint(final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint) {
            this.props.clientVpnEndoint(clientVpnEndoint);
            return this;
        }

        /**
         * The client VPN endpoint to which to add the rule.
         * <p>
         * Default: clientVpnEndpoint is required
         * <p>
         * @return {@code this}
         * @param clientVpnEndpoint The client VPN endpoint to which to add the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndpoint(final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndpoint) {
            this.props.clientVpnEndpoint(clientVpnEndpoint);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule build() {
            return new software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
