package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 * <p>
 * Specifies a Spot Fleet request. A Spot Fleet request contains the configuration information to launch a fleet, or group, of instances.
 * <p>
 * The Spot Fleet request specifies the total target capacity and the On-Demand target capacity for the fleet. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity.
 * <p>
 * The Spot Fleet request can include multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.
 * <p>
 * By default, the Spot Fleet requests Spot Instances in the Spot pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload.
 * <p>
 * Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet.
 * <p>
 * You can specify tags for the Spot Instances. You cannot tag other resource types in a Spot Fleet request because only the <code>instance</code> resource type is supported.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet Requests</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSpotFleet cfnSpotFleet = CfnSpotFleet.Builder.create(this, "MyCfnSpotFleet")
 *         .spotFleetRequestConfigData(SpotFleetRequestConfigDataProperty.builder()
 *                 .iamFleetRole("iamFleetRole")
 *                 .targetCapacity(123)
 *                 // the properties below are optional
 *                 .allocationStrategy("allocationStrategy")
 *                 .context("context")
 *                 .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .launchSpecifications(List.of(SpotFleetLaunchSpecificationProperty.builder()
 *                         .imageId("imageId")
 *                         // the properties below are optional
 *                         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                                 .deviceName("deviceName")
 *                                 // the properties below are optional
 *                                 .ebs(EbsBlockDeviceProperty.builder()
 *                                         .deleteOnTermination(false)
 *                                         .encrypted(false)
 *                                         .iops(123)
 *                                         .snapshotId("snapshotId")
 *                                         .volumeSize(123)
 *                                         .volumeType("volumeType")
 *                                         .build())
 *                                 .noDevice("noDevice")
 *                                 .virtualName("virtualName")
 *                                 .build()))
 *                         .ebsOptimized(false)
 *                         .iamInstanceProfile(IamInstanceProfileSpecificationProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .kernelId("kernelId")
 *                         .keyName("keyName")
 *                         .monitoring(SpotFleetMonitoringProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .networkInterfaces(List.of(InstanceNetworkInterfaceSpecificationProperty.builder()
 *                                 .associatePublicIpAddress(false)
 *                                 .deleteOnTermination(false)
 *                                 .description("description")
 *                                 .deviceIndex(123)
 *                                 .groups(List.of("groups"))
 *                                 .ipv6AddressCount(123)
 *                                 .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                                         .ipv6Address("ipv6Address")
 *                                         .build()))
 *                                 .networkInterfaceId("networkInterfaceId")
 *                                 .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
 *                                         .privateIpAddress("privateIpAddress")
 *                                         // the properties below are optional
 *                                         .primary(false)
 *                                         .build()))
 *                                 .secondaryPrivateIpAddressCount(123)
 *                                 .subnetId("subnetId")
 *                                 .build()))
 *                         .placement(SpotPlacementProperty.builder()
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .ramdiskId("ramdiskId")
 *                         .securityGroups(List.of(GroupIdentifierProperty.builder()
 *                                 .groupId("groupId")
 *                                 .build()))
 *                         .spotPrice("spotPrice")
 *                         .subnetId("subnetId")
 *                         .tagSpecifications(List.of(SpotFleetTagSpecificationProperty.builder()
 *                                 .resourceType("resourceType")
 *                                 .tags(List.of(CfnTag.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build()))
 *                         .userData("userData")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .launchTemplateConfigs(List.of(LaunchTemplateConfigProperty.builder()
 *                         .launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty.builder()
 *                                 .version("version")
 *                                 // the properties below are optional
 *                                 .launchTemplateId("launchTemplateId")
 *                                 .launchTemplateName("launchTemplateName")
 *                                 .build())
 *                         .overrides(List.of(LaunchTemplateOverridesProperty.builder()
 *                                 .availabilityZone("availabilityZone")
 *                                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                         .acceleratorNames(List.of("acceleratorNames"))
 *                                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorTypes(List.of("acceleratorTypes"))
 *                                         .bareMetal("bareMetal")
 *                                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .burstablePerformance("burstablePerformance")
 *                                         .cpuManufacturers(List.of("cpuManufacturers"))
 *                                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                         .instanceGenerations(List.of("instanceGenerations"))
 *                                         .localStorage("localStorage")
 *                                         .localStorageTypes(List.of("localStorageTypes"))
 *                                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                         .requireHibernateSupport(false)
 *                                         .spotMaxPricePercentageOverLowestPrice(123)
 *                                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .build())
 *                                 .instanceType("instanceType")
 *                                 .priority(123)
 *                                 .spotPrice("spotPrice")
 *                                 .subnetId("subnetId")
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .build()))
 *                 .loadBalancersConfig(LoadBalancersConfigProperty.builder()
 *                         .classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty.builder()
 *                                 .classicLoadBalancers(List.of(ClassicLoadBalancerProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .targetGroupsConfig(TargetGroupsConfigProperty.builder()
 *                                 .targetGroups(List.of(TargetGroupProperty.builder()
 *                                         .arn("arn")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .onDemandAllocationStrategy("onDemandAllocationStrategy")
 *                 .onDemandMaxTotalPrice("onDemandMaxTotalPrice")
 *                 .onDemandTargetCapacity(123)
 *                 .replaceUnhealthyInstances(false)
 *                 .spotMaintenanceStrategies(SpotMaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(SpotCapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .spotMaxTotalPrice("spotMaxTotalPrice")
 *                 .spotPrice("spotPrice")
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .terminateInstancesWithExpiration(false)
 *                 .type("type")
 *                 .validFrom("validFrom")
 *                 .validUntil("validUntil")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-01T01:54:44.412Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSpotFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpotFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSpotFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::SpotFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSpotFleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSpotFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the Spot Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Describes the configuration of a Spot Fleet request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpotFleetRequestConfigData() {
        return software.amazon.jsii.Kernel.get(this, "spotFleetRequestConfigData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of a Spot Fleet request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    /**
     * Describes the configuration of a Spot Fleet request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty value) {
        software.amazon.jsii.Kernel.set(this, "spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
     * <p>
     * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorCountRequestProperty acceleratorCountRequestProperty = AcceleratorCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of accelerators.
         * <p>
         * To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of accelerators.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMax}
             * @param max The maximum number of accelerators.
             *            To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMin}
             * @param min The minimum number of accelerators.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.AcceleratorCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRequestProperty.Jsii$Proxy that = (AcceleratorCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total accelerator memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiBRequestProperty = AcceleratorTotalMemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of accelerator memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of accelerator memory, in MiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of accelerator memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of accelerator memory, in MiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbpsRequestProperty = BaselineEbsBandwidthMbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum baseline bandwidth, in Mbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum baseline bandwidth, in Mbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMax}
             * @param max The maximum baseline bandwidth, in Mbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMin}
             * @param min The minimum baseline bandwidth, in Mbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a block device mapping.
     * <p>
     * You can specify <code>Ebs</code> or <code>VirtualName</code> , but not both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BlockDeviceMappingProperty blockDeviceMappingProperty = BlockDeviceMappingProperty.builder()
     *         .deviceName("deviceName")
     *         // the properties below are optional
     *         .ebs(EbsBlockDeviceProperty.builder()
     *                 .deleteOnTermination(false)
     *                 .encrypted(false)
     *                 .iops(123)
     *                 .snapshotId("snapshotId")
     *                 .volumeSize(123)
     *                 .volumeType("volumeType")
     *                 .build())
     *         .noDevice("noDevice")
     *         .virtualName("virtualName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The device name (for example, `/dev/sdh` or `xvdh` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

        /**
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * To omit the device from the block device mapping, specify an empty string.
         * <p>
         * When this property is specified, the device is removed from the block device mapping regardless of the assigned value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoDevice() {
            return null;
        }

        /**
         * The virtual device name ( `ephemeral` N).
         * <p>
         * Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code> . The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
         * <p>
         * NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.
         * <p>
         * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            java.lang.String deviceName;
            java.lang.Object ebs;
            java.lang.String noDevice;
            java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName The device name (for example, `/dev/sdh` or `xvdh` ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs Parameters used to automatically set up EBS volumes when the instance is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice To omit the device from the block device mapping, specify an empty string.
             *                 When this property is specified, the device is removed from the block device mapping regardless of the assigned value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName The virtual device name ( `ephemeral` N).
             *                    Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code> . The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.
             *                    <p>
             *                    NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.
             *                    <p>
             *                    Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.String noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noDevice = software.amazon.jsii.Kernel.get(this, "noDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.virtualName = software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = java.util.Objects.requireNonNull(builder.deviceName, "deviceName is required");
                this.ebs = builder.ebs;
                this.noDevice = builder.noDevice;
                this.virtualName = builder.virtualName;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public final java.lang.String getNoDevice() {
                return this.noDevice;
            }

            @Override
            public final java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceName", om.valueToTree(this.getDeviceName()));
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (!deviceName.equals(that.deviceName)) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName.hashCode();
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a Classic Load Balancer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ClassicLoadBalancerProperty classicLoadBalancerProperty = ClassicLoadBalancerProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty")
    @software.amazon.jsii.Jsii.Proxy(ClassicLoadBalancerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the load balancer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClassicLoadBalancerProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link ClassicLoadBalancerProperty#getName}
             * @param name The name of the load balancer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClassicLoadBalancerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClassicLoadBalancerProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClassicLoadBalancerProperty.Jsii$Proxy that = (ClassicLoadBalancerProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the Classic Load Balancers to attach to a Spot Fleet.
     * <p>
     * Spot Fleet registers the running Spot Instances with these Classic Load Balancers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ClassicLoadBalancersConfigProperty classicLoadBalancersConfigProperty = ClassicLoadBalancersConfigProperty.builder()
     *         .classicLoadBalancers(List.of(ClassicLoadBalancerProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClassicLoadBalancersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more Classic Load Balancers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClassicLoadBalancers();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClassicLoadBalancersConfigProperty> {
            java.lang.Object classicLoadBalancers;

            /**
             * Sets the value of {@link ClassicLoadBalancersConfigProperty#getClassicLoadBalancers}
             * @param classicLoadBalancers One or more Classic Load Balancers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancers(software.amazon.awscdk.core.IResolvable classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            /**
             * Sets the value of {@link ClassicLoadBalancersConfigProperty#getClassicLoadBalancers}
             * @param classicLoadBalancers One or more Classic Load Balancers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancers(java.util.List<? extends java.lang.Object> classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClassicLoadBalancersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClassicLoadBalancersConfigProperty {
            private final java.lang.Object classicLoadBalancers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classicLoadBalancers = software.amazon.jsii.Kernel.get(this, "classicLoadBalancers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classicLoadBalancers = java.util.Objects.requireNonNull(builder.classicLoadBalancers, "classicLoadBalancers is required");
            }

            @Override
            public final java.lang.Object getClassicLoadBalancers() {
                return this.classicLoadBalancers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("classicLoadBalancers", om.valueToTree(this.getClassicLoadBalancers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClassicLoadBalancersConfigProperty.Jsii$Proxy that = (ClassicLoadBalancersConfigProperty.Jsii$Proxy) o;

                return this.classicLoadBalancers.equals(that.classicLoadBalancers);
            }

            @Override
            public final int hashCode() {
                int result = this.classicLoadBalancers.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a block device for an EBS volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EbsBlockDeviceProperty ebsBlockDeviceProperty = EbsBlockDeviceProperty.builder()
     *         .deleteOnTermination(false)
     *         .encrypted(false)
     *         .iops(123)
     *         .snapshotId("snapshotId")
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot.
         * <p>
         * The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS Encryption</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * In no case can you remove encryption from an encrypted volume.
         * <p>
         * Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported Instance Types</a> .
         * <p>
         * This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS).
         * <p>
         * For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         * <p>
         * The following are the supported values for each volume type:
         * <p>
         * <ul>
         * <li><code>gp3</code> : 3,000-16,000 IOPS</li>
         * <li><code>io1</code> : 100-64,000 IOPS</li>
         * <li><code>io2</code> : 100-64,000 IOPS</li>
         * </ul>
         * <p>
         * For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
         * <p>
         * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The ID of the snapshot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * The size of the volume, in GiBs.
         * <p>
         * You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
         * <p>
         * The following are the supported volumes sizes for each volume type:
         * <p>
         * <ul>
         * <li><code>gp2</code> and <code>gp3</code> :1-16,384</li>
         * <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
         * <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
         * <li><code>standard</code> : 1-1,024</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * The volume type.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> . If the volume type is <code>io1</code> or <code>io2</code> , you must specify the IOPS that the volume supports.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceProperty> {
            java.lang.Object deleteOnTermination;
            java.lang.Object encrypted;
            java.lang.Number iops;
            java.lang.String snapshotId;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the EBS volume is deleted on instance termination.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getEncrypted}
             * @param encrypted Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot.
             *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS Encryption</a> in the <em>Amazon EC2 User Guide</em> .
             *                  <p>
             *                  In no case can you remove encryption from an encrypted volume.
             *                  <p>
             *                  Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported Instance Types</a> .
             *                  <p>
             *                  This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getEncrypted}
             * @param encrypted Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot.
             *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS Encryption</a> in the <em>Amazon EC2 User Guide</em> .
             *                  <p>
             *                  In no case can you remove encryption from an encrypted volume.
             *                  <p>
             *                  Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported Instance Types</a> .
             *                  <p>
             *                  This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS).
             *             For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
             *             <p>
             *             The following are the supported values for each volume type:
             *             <p>
             *             <ul>
             *             <li><code>gp3</code> : 3,000-16,000 IOPS</li>
             *             <li><code>io1</code> : 100-64,000 IOPS</li>
             *             <li><code>io2</code> : 100-64,000 IOPS</li>
             *             </ul>
             *             <p>
             *             For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> . Other instance families guarantee performance up to 32,000 IOPS.
             *             <p>
             *             This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code> , <code>st1</code> , <code>sc1</code> , or <code>standard</code> volumes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getSnapshotId}
             * @param snapshotId The ID of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getVolumeSize}
             * @param volumeSize The size of the volume, in GiBs.
             *                   You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
             *                   <p>
             *                   The following are the supported volumes sizes for each volume type:
             *                   <p>
             *                   <ul>
             *                   <li><code>gp2</code> and <code>gp3</code> :1-16,384</li>
             *                   <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
             *                   <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
             *                   <li><code>standard</code> : 1-1,024</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceProperty#getVolumeType}
             * @param volumeType The volume type.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> . If the volume type is <code>io1</code> or <code>io2</code> , you must specify the IOPS that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsBlockDeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = builder.deleteOnTermination;
                this.encrypted = builder.encrypted;
                this.iops = builder.iops;
                this.snapshotId = builder.snapshotId;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceProperty.Jsii$Proxy that = (EbsBlockDeviceProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the Amazon EC2 launch template and the launch template version that can be used by a Spot Fleet request to configure Amazon EC2 instances.
     * <p>
     * For information about launch templates, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateSpecificationProperty fleetLaunchTemplateSpecificationProperty = FleetLaunchTemplateSpecificationProperty.builder()
     *         .version("version")
     *         // the properties below are optional
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version number of the launch template. You must specify a version number.
         * <p>
         * Minimum length of 1. Maximum length of 255. Versions must fit the following pattern: <code>[\ u0020-\ uD7FF\ uE000-\ uFFFD\ uD800\ uDC00-\ uDBFF\ uDFFF\r\n\t]*</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * The ID of the launch template.
         * <p>
         * If you specify the template ID, you can't specify the template name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template. You must specify either a template name or a template ID.
         * <p>
         * Minimum length of 3. Maximum length of 128. Names must match the following pattern: <code>[a-zA-Z0-9\(\)\.-/_]+</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationProperty> {
            java.lang.String version;
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getVersion}
             * @param version The version number of the launch template. You must specify a version number. This parameter is required.
             *                Minimum length of 1. Maximum length of 255. Versions must fit the following pattern: <code>[\ u0020-\ uD7FF\ uE000-\ uFFFD\ uD800\ uDC00-\ uDBFF\ uDFFF\r\n\t]*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template.
             *                         If you specify the template ID, you can't specify the template name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template. You must specify either a template name or a template ID.
             *                           Minimum length of 3. Maximum length of 128. Names must match the following pattern: <code>[a-zA-Z0-9\(\)\.-/_]+</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationProperty {
            private final java.lang.String version;
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (!version.equals(that.version)) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.launchTemplateName != null ? this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version.hashCode();
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a security group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * GroupIdentifierProperty groupIdentifierProperty = GroupIdentifierProperty.builder()
     *         .groupId("groupId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the security group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupId();

        /**
         * @return a {@link Builder} of {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupIdentifierProperty> {
            java.lang.String groupId;

            /**
             * Sets the value of {@link GroupIdentifierProperty#getGroupId}
             * @param groupId The ID of the security group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupIdentifierProperty {
            private final java.lang.String groupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupId = java.util.Objects.requireNonNull(builder.groupId, "groupId is required");
            }

            @Override
            public final java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupId", om.valueToTree(this.getGroupId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupIdentifierProperty.Jsii$Proxy that = (GroupIdentifierProperty.Jsii$Proxy) o;

                return this.groupId.equals(that.groupId);
            }

            @Override
            public final int hashCode() {
                int result = this.groupId.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes an IAM instance profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IamInstanceProfileSpecificationProperty iamInstanceProfileSpecificationProperty = IamInstanceProfileSpecificationProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(IamInstanceProfileSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the instance profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamInstanceProfileSpecificationProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link IamInstanceProfileSpecificationProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamInstanceProfileSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamInstanceProfileSpecificationProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamInstanceProfileSpecificationProperty.Jsii$Proxy that = (IamInstanceProfileSpecificationProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes an IPv6 address.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceIpv6AddressProperty instanceIpv6AddressProperty = InstanceIpv6AddressProperty.builder()
     *         .ipv6Address("ipv6Address")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceIpv6AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceIpv6AddressProperty> {
            java.lang.String ipv6Address;

            /**
             * Sets the value of {@link InstanceIpv6AddressProperty#getIpv6Address}
             * @param ipv6Address The IPv6 address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceIpv6AddressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceIpv6AddressProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = software.amazon.jsii.Kernel.get(this, "ipv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = java.util.Objects.requireNonNull(builder.ipv6Address, "ipv6Address is required");
            }

            @Override
            public final java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceIpv6AddressProperty.Jsii$Proxy that = (InstanceIpv6AddressProperty.Jsii$Proxy) o;

                return this.ipv6Address.equals(that.ipv6Address);
            }

            @Override
            public final int hashCode() {
                int result = this.ipv6Address.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a network interface.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceNetworkInterfaceSpecificationProperty instanceNetworkInterfaceSpecificationProperty = InstanceNetworkInterfaceSpecificationProperty.builder()
     *         .associatePublicIpAddress(false)
     *         .deleteOnTermination(false)
     *         .description("description")
     *         .deviceIndex(123)
     *         .groups(List.of("groups"))
     *         .ipv6AddressCount(123)
     *         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
     *                 .ipv6Address("ipv6Address")
     *                 .build()))
     *         .networkInterfaceId("networkInterfaceId")
     *         .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
     *                 .privateIpAddress("privateIpAddress")
     *                 // the properties below are optional
     *                 .primary(false)
     *                 .build()))
     *         .secondaryPrivateIpAddressCount(123)
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC.
         * <p>
         * The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * The description of the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The position of the network interface in the attachment order.
         * <p>
         * A primary network interface has a device index of 0.
         * <p>
         * If you specify a network interface when launching an instance, you must specify the device index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDeviceIndex() {
            return null;
        }

        /**
         * The IDs of the security groups for the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * A number of IPv6 addresses to assign to the network interface.
         * <p>
         * Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * One or more IPv6 addresses to assign to the network interface.
         * <p>
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * The ID of the network interface.
         * <p>
         * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * One or more private IPv4 addresses to assign to the network interface.
         * <p>
         * Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * The number of secondary private IPv4 addresses.
         * <p>
         * You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * The ID of the subnet associated with the network interface.
         * <p>
         * Applies only if creating a network interface when launching an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceNetworkInterfaceSpecificationProperty> {
            java.lang.Object associatePublicIpAddress;
            java.lang.Object deleteOnTermination;
            java.lang.String description;
            java.lang.Number deviceIndex;
            java.util.List<java.lang.String> groups;
            java.lang.Number ipv6AddressCount;
            java.lang.Object ipv6Addresses;
            java.lang.String networkInterfaceId;
            java.lang.Object privateIpAddresses;
            java.lang.Number secondaryPrivateIpAddressCount;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Indicates whether to assign a public IPv4 address to an instance you launch in a VPC.
             *                                 The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getAssociatePublicIpAddress}
             * @param associatePublicIpAddress Indicates whether to assign a public IPv4 address to an instance you launch in a VPC.
             *                                 The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeleteOnTermination}
             * @param deleteOnTermination Indicates whether the network interface is deleted when the instance is terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDescription}
             * @param description The description of the network interface.
             *                    Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getDeviceIndex}
             * @param deviceIndex The position of the network interface in the attachment order.
             *                    A primary network interface has a device index of 0.
             *                    <p>
             *                    If you specify a network interface when launching an instance, you must specify the device index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceIndex(java.lang.Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getGroups}
             * @param groups The IDs of the security groups for the network interface.
             *               Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6AddressCount}
             * @param ipv6AddressCount A number of IPv6 addresses to assign to the network interface.
             *                         Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more IPv6 addresses to assign to the network interface.
             *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getIpv6Addresses}
             * @param ipv6Addresses One or more IPv6 addresses to assign to the network interface.
             *                      You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getNetworkInterfaceId}
             * @param networkInterfaceId The ID of the network interface.
             *                           If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses to assign to the network interface.
             *                           Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getPrivateIpAddresses}
             * @param privateIpAddresses One or more private IPv4 addresses to assign to the network interface.
             *                           Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getSecondaryPrivateIpAddressCount}
             * @param secondaryPrivateIpAddressCount The number of secondary private IPv4 addresses.
             *                                       You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceNetworkInterfaceSpecificationProperty#getSubnetId}
             * @param subnetId The ID of the subnet associated with the network interface.
             *                 Applies only if creating a network interface when launching an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceNetworkInterfaceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceNetworkInterfaceSpecificationProperty {
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.lang.Number deviceIndex;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.String networkInterfaceId;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceIndex = software.amazon.jsii.Kernel.get(this, "deviceIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddresses = software.amazon.jsii.Kernel.get(this, "privateIpAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associatePublicIpAddress = builder.associatePublicIpAddress;
                this.deleteOnTermination = builder.deleteOnTermination;
                this.description = builder.description;
                this.deviceIndex = builder.deviceIndex;
                this.groups = builder.groups;
                this.ipv6AddressCount = builder.ipv6AddressCount;
                this.ipv6Addresses = builder.ipv6Addresses;
                this.networkInterfaceId = builder.networkInterfaceId;
                this.privateIpAddresses = builder.privateIpAddresses;
                this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public final java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public final java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public final java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public final java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDeviceIndex() != null) {
                    data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy that = (InstanceNetworkInterfaceSpecificationProperty.Jsii$Proxy) o;

                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.deviceIndex != null ? !this.deviceIndex.equals(that.deviceIndex) : that.deviceIndex != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0;
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.deviceIndex != null ? this.deviceIndex.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The attributes for the instance types.
     * <p>
     * When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     * <p>
     * When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values.
     * <p>
     * <blockquote>
     * <p>
     * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code> . All other parameters are optional. Any unspecified optional parameter is set to its default.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a> , <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a> , and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceRequirementsRequestProperty instanceRequirementsRequestProperty = InstanceRequirementsRequestProperty.builder()
     *         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
         * <p>
         * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
         * <li>For instance types with AMD devices, specify <code>amd</code> .</li>
         * <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
         * <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
         * </ul>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * The accelerators that must be on the instance type.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
         * <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
         * <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
         * <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
         * <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
         * <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
         * <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types that must be on the instance type.
         * <p>
         * <ul>
         * <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
         * <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
         * <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * Indicates whether bare metal instance types must be included, excluded, or required.
         * <p>
         * <ul>
         * <li>To include bare metal instance types, specify <code>included</code> .</li>
         * <li>To require only bare metal instance types, specify <code>required</code> .</li>
         * <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * Indicates whether burstable performance T instance types are included, excluded, or required.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
         * <p>
         * <ul>
         * <li>To include burstable performance instance types, specify <code>included</code> .</li>
         * <li>To require only burstable performance instance types, specify <code>required</code> .</li>
         * <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * The CPU manufacturers to include.
         * <p>
         * <ul>
         * <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
         * <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
         * <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
         * <p>
         * </blockquote>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * The instance types to exclude.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
         * <p>
         * Default: No excluded instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether current or previous generation instance types are included.
         * <p>
         * The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * For current generation instance types, specify <code>current</code> .
         * <p>
         * For previous generation instance types, specify <code>previous</code> .
         * <p>
         * Default: Current and previous generation instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required.
         * <p>
         * For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * <ul>
         * <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
         * <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
         * <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>included</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * The type of local storage that is required.
         * <p>
         * <ul>
         * <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
         * <li>For instance types with solid state drive (SDD) storage, specify <code>sdd</code> .</li>
         * </ul>
         * <p>
         * Default: <code>hdd</code> and <code>sdd</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory, in MiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryMiB() {
            return null;
        }

        /**
         * The minimum and maximum number of network interfaces.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * The price protection threshold for On-Demand Instances.
         * <p>
         * This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>20</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * The price protection threshold for Spot Instance.
         * <p>
         * This is the maximum you’ll pay for an Spot Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>100</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of total local storage, in GB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * The minimum and maximum number of vCPUs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVCpuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object memoryMiB;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;
            java.lang.Object vCpuCount;

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.core.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ec2.CfnSpotFleet.AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers Indicates whether instance types must have accelerators by specific manufacturers.
             *                                 <ul>
             *                                 <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
             *                                 <li>For instance types with AMD devices, specify <code>amd</code> .</li>
             *                                 <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
             *                                 <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
             *                                 </ul>
             *                                 <p>
             *                                 Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorNames}
             * @param acceleratorNames The accelerators that must be on the instance type.
             *                         <ul>
             *                         <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
             *                         <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
             *                         <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
             *                         <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
             *                         <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
             *                         <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
             *                         <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.core.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ec2.CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types that must be on the instance type.
             *                         <ul>
             *                         <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
             *                         <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
             *                         <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator type
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBareMetal}
             * @param bareMetal Indicates whether bare metal instance types must be included, excluded, or required.
             *                  <ul>
             *                  <li>To include bare metal instance types, specify <code>included</code> .</li>
             *                  <li>To require only bare metal instance types, specify <code>required</code> .</li>
             *                  <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
             *                  </ul>
             *                  <p>
             *                  Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.core.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ec2.CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBurstablePerformance}
             * @param burstablePerformance Indicates whether burstable performance T instance types are included, excluded, or required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
             *                             <p>
             *                             <ul>
             *                             <li>To include burstable performance instance types, specify <code>included</code> .</li>
             *                             <li>To require only burstable performance instance types, specify <code>required</code> .</li>
             *                             <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
             *                             </ul>
             *                             <p>
             *                             Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getCpuManufacturers}
             * @param cpuManufacturers The CPU manufacturers to include.
             *                         <ul>
             *                         <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
             *                         <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
             *                         <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
             *                         </ul>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude.
             *                              You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                              <p>
             *                              For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
             *                              <p>
             *                              Default: No excluded instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getInstanceGenerations}
             * @param instanceGenerations Indicates whether current or previous generation instance types are included.
             *                            The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
             *                            <p>
             *                            For current generation instance types, specify <code>current</code> .
             *                            <p>
             *                            For previous generation instance types, specify <code>previous</code> .
             *                            <p>
             *                            Default: Current and previous generation instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorage}
             * @param localStorage Indicates whether instance types with instance store volumes are included, excluded, or required.
             *                     For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
             *                     <p>
             *                     <ul>
             *                     <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
             *                     <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
             *                     <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Default: <code>included</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorageTypes}
             * @param localStorageTypes The type of local storage that is required.
             *                          <ul>
             *                          <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
             *                          <li>For instance types with solid state drive (SDD) storage, specify <code>sdd</code> .</li>
             *                          </ul>
             *                          <p>
             *                          Default: <code>hdd</code> and <code>sdd</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.core.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ec2.CfnSpotFleet.MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.core.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ec2.CfnSpotFleet.MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.core.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ec2.CfnSpotFleet.NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances.
             *                                                  This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                                  <p>
             *                                                  The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                                  <p>
             *                                                  To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                                  <p>
             *                                                  This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                                  <p>
             *                                                  <blockquote>
             *                                                  <p>
             *                                                  If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                                  <p>
             *                                                  </blockquote>
             *                                                  <p>
             *                                                  Default: <code>20</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.core.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instance.
             *                                              This is the maximum you’ll pay for an Spot Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                              <p>
             *                                              The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                              <p>
             *                                              To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                              <p>
             *                                              This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                              <p>
             *                                              <blockquote>
             *                                              <p>
             *                                              If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                              <p>
             *                                              </blockquote>
             *                                              <p>
             *                                              Default: <code>100</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.core.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ec2.CfnSpotFleet.TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.core.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ec2.CfnSpotFleet.VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsRequestProperty {
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object memoryMiB;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;
            private final java.lang.Object vCpuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.memoryMiB = builder.memoryMiB;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
                this.vCpuCount = builder.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getMemoryMiB() != null) {
                    data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }
                if (this.getVCpuCount() != null) {
                    data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.InstanceRequirementsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsRequestProperty.Jsii$Proxy that = (InstanceRequirementsRequestProperty.Jsii$Proxy) o;

                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                if (this.totalLocalStorageGb != null ? !this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb != null) return false;
                return this.vCpuCount != null ? this.vCpuCount.equals(that.vCpuCount) : that.vCpuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0;
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                result = 31 * result + (this.vCpuCount != null ? this.vCpuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a launch template and overrides.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateConfigProperty launchTemplateConfigProperty = LaunchTemplateConfigProperty.builder()
     *         .launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty.builder()
     *                 .version("version")
     *                 // the properties below are optional
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .build())
     *         .overrides(List.of(LaunchTemplateOverridesProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .priority(123)
     *                 .spotPrice("spotPrice")
     *                 .subnetId("subnetId")
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateSpecification() {
            return null;
        }

        /**
         * Any parameters that you specify override the same parameters in the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateConfigProperty> {
            java.lang.Object launchTemplateSpecification;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.core.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateConfigProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateConfigProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateSpecification = software.amazon.jsii.Kernel.get(this, "launchTemplateSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = builder.launchTemplateSpecification;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateSpecification() != null) {
                    data.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateConfigProperty.Jsii$Proxy that = (LaunchTemplateConfigProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies overrides for a launch template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LaunchTemplateOverridesProperty launchTemplateOverridesProperty = LaunchTemplateOverridesProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .priority(123)
     *         .spotPrice("spotPrice")
     *         .subnetId("subnetId")
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateOverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateOverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone in which to launch the instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The instance requirements.
         * <p>
         * When you specify instance requirements, Amazon EC2 will identify instance types with the provided requirements, and then use your On-Demand and Spot allocation strategies to launch instances from these instance types, in the same way as when you specify a list of instance types.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * The instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The priority for the launch template override. The highest priority is launched first.
         * <p>
         * If <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code> , Spot Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
         * <p>
         * If the Spot <code>AllocationStrategy</code> is set to <code>capacityOptimizedPrioritized</code> , Spot Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
         * <p>
         * Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * The ID of the subnet in which to launch the instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * The number of units provided by the specified instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateOverridesProperty> {
            java.lang.String availabilityZone;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.Number priority;
            java.lang.String spotPrice;
            java.lang.String subnetId;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone in which to launch the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getInstanceRequirements}
             * @param instanceRequirements The instance requirements.
             *                             When you specify instance requirements, Amazon EC2 will identify instance types with the provided requirements, and then use your On-Demand and Spot allocation strategies to launch instances from these instance types, in the same way as when you specify a list of instance types.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.core.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getInstanceRequirements}
             * @param instanceRequirements The instance requirements.
             *                             When you specify instance requirements, Amazon EC2 will identify instance types with the provided requirements, and then use your On-Demand and Spot allocation strategies to launch instances from these instance types, in the same way as when you specify a list of instance types.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getInstanceType}
             * @param instanceType The instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getPriority}
             * @param priority The priority for the launch template override. The highest priority is launched first.
             *                 If <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code> , Spot Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
             *                 <p>
             *                 If the Spot <code>AllocationStrategy</code> is set to <code>capacityOptimizedPrioritized</code> , Spot Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
             *                 <p>
             *                 Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getSpotPrice}
             * @param spotPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getSubnetId}
             * @param subnetId The ID of the subnet in which to launch the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link LaunchTemplateOverridesProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units provided by the specified instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchTemplateOverridesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateOverridesProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.Number priority;
            private final java.lang.String spotPrice;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.priority = builder.priority;
                this.spotPrice = builder.spotPrice;
                this.subnetId = builder.subnetId;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateOverridesProperty.Jsii$Proxy that = (LaunchTemplateOverridesProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Classic Load Balancers and target groups to attach to a Spot Fleet request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * LoadBalancersConfigProperty loadBalancersConfigProperty = LoadBalancersConfigProperty.builder()
     *         .classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty.builder()
     *                 .classicLoadBalancers(List.of(ClassicLoadBalancerProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .targetGroupsConfig(TargetGroupsConfigProperty.builder()
     *                 .targetGroups(List.of(TargetGroupProperty.builder()
     *                         .arn("arn")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Classic Load Balancers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClassicLoadBalancersConfig() {
            return null;
        }

        /**
         * The target groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupsConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancersConfigProperty> {
            java.lang.Object classicLoadBalancersConfig;
            java.lang.Object targetGroupsConfig;

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getClassicLoadBalancersConfig}
             * @param classicLoadBalancersConfig The Classic Load Balancers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancersConfig(software.amazon.awscdk.core.IResolvable classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getClassicLoadBalancersConfig}
             * @param classicLoadBalancersConfig The Classic Load Balancers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classicLoadBalancersConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getTargetGroupsConfig}
             * @param targetGroupsConfig The target groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupsConfig(software.amazon.awscdk.core.IResolvable targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancersConfigProperty#getTargetGroupsConfig}
             * @param targetGroupsConfig The target groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupsConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancersConfigProperty {
            private final java.lang.Object classicLoadBalancersConfig;
            private final java.lang.Object targetGroupsConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classicLoadBalancersConfig = software.amazon.jsii.Kernel.get(this, "classicLoadBalancersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupsConfig = software.amazon.jsii.Kernel.get(this, "targetGroupsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classicLoadBalancersConfig = builder.classicLoadBalancersConfig;
                this.targetGroupsConfig = builder.targetGroupsConfig;
            }

            @Override
            public final java.lang.Object getClassicLoadBalancersConfig() {
                return this.classicLoadBalancersConfig;
            }

            @Override
            public final java.lang.Object getTargetGroupsConfig() {
                return this.targetGroupsConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassicLoadBalancersConfig() != null) {
                    data.set("classicLoadBalancersConfig", om.valueToTree(this.getClassicLoadBalancersConfig()));
                }
                if (this.getTargetGroupsConfig() != null) {
                    data.set("targetGroupsConfig", om.valueToTree(this.getTargetGroupsConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancersConfigProperty.Jsii$Proxy that = (LoadBalancersConfigProperty.Jsii$Proxy) o;

                if (this.classicLoadBalancersConfig != null ? !this.classicLoadBalancersConfig.equals(that.classicLoadBalancersConfig) : that.classicLoadBalancersConfig != null) return false;
                return this.targetGroupsConfig != null ? this.targetGroupsConfig.equals(that.targetGroupsConfig) : that.targetGroupsConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classicLoadBalancersConfig != null ? this.classicLoadBalancersConfig.hashCode() : 0;
                result = 31 * result + (this.targetGroupsConfig != null ? this.targetGroupsConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory per vCPU, in GiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpuRequestProperty = MemoryGiBPerVCpuRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMax}
             * @param max The maximum amount of memory per vCPU, in GiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMin}
             * @param min The minimum amount of memory per vCPU, in GiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.MemoryGiBPerVCpuRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuRequestProperty.Jsii$Proxy that = (MemoryGiBPerVCpuRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryMiBRequestProperty memoryMiBRequestProperty = MemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory, in MiB.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of memory, in MiB.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.MemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRequestProperty.Jsii$Proxy that = (MemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceCountRequestProperty networkInterfaceCountRequestProperty = NetworkInterfaceCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of network interfaces.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of network interfaces.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMax}
             * @param max The maximum number of network interfaces.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMin}
             * @param min The minimum number of network interfaces.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.NetworkInterfaceCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountRequestProperty.Jsii$Proxy that = (NetworkInterfaceCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a secondary private IPv4 address for a network interface.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PrivateIpAddressSpecificationProperty privateIpAddressSpecificationProperty = PrivateIpAddressSpecificationProperty.builder()
     *         .privateIpAddress("privateIpAddress")
     *         // the properties below are optional
     *         .primary(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddressSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The private IPv4 addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateIpAddress();

        /**
         * Indicates whether the private IPv4 address is the primary private IPv4 address.
         * <p>
         * Only one IPv4 address can be designated as primary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimary() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrivateIpAddressSpecificationProperty> {
            java.lang.String privateIpAddress;
            java.lang.Object primary;

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrivateIpAddress}
             * @param privateIpAddress The private IPv4 addresses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of {@link PrivateIpAddressSpecificationProperty#getPrimary}
             * @param primary Indicates whether the private IPv4 address is the primary private IPv4 address.
             *                Only one IPv4 address can be designated as primary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddressSpecificationProperty {
            private final java.lang.String privateIpAddress;
            private final java.lang.Object primary;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primary = software.amazon.jsii.Kernel.get(this, "primary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.privateIpAddress = java.util.Objects.requireNonNull(builder.privateIpAddress, "privateIpAddress is required");
                this.primary = builder.primary;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public final java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                if (this.getPrimary() != null) {
                    data.set("primary", om.valueToTree(this.getPrimary()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddressSpecificationProperty.Jsii$Proxy that = (PrivateIpAddressSpecificationProperty.Jsii$Proxy) o;

                if (!privateIpAddress.equals(that.privateIpAddress)) return false;
                return this.primary != null ? this.primary.equals(that.primary) : that.primary == null;
            }

            @Override
            public final int hashCode() {
                int result = this.privateIpAddress.hashCode();
                result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotCapacityRebalanceProperty spotCapacityRebalanceProperty = SpotCapacityRebalanceProperty.builder()
     *         .replacementStrategy("replacementStrategy")
     *         .terminationDelay(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotCapacityRebalanceProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotCapacityRebalanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotCapacityRebalanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The replacement strategy to use. Only available for fleets of type `maintain` .
         * <p>
         * <code>launch</code> - Spot Fleet launches a new replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. Spot Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
         * <p>
         * <code>launch-before-terminate</code> - Spot Fleet launches a new replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplacementStrategy() {
            return null;
        }

        /**
         * The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
         * <p>
         * Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
         * <p>
         * Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
         * <p>
         * Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationDelay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotCapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotCapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotCapacityRebalanceProperty> {
            java.lang.String replacementStrategy;
            java.lang.Number terminationDelay;

            /**
             * Sets the value of {@link SpotCapacityRebalanceProperty#getReplacementStrategy}
             * @param replacementStrategy The replacement strategy to use. Only available for fleets of type `maintain` .
             *                            <code>launch</code> - Spot Fleet launches a new replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. Spot Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
             *                            <p>
             *                            <code>launch-before-terminate</code> - Spot Fleet launches a new replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacementStrategy(java.lang.String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotCapacityRebalanceProperty#getTerminationDelay}
             * @param terminationDelay The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
             *                         Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
             *                         <p>
             *                         Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
             *                         <p>
             *                         Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationDelay(java.lang.Number terminationDelay) {
                this.terminationDelay = terminationDelay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotCapacityRebalanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotCapacityRebalanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotCapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotCapacityRebalanceProperty {
            private final java.lang.String replacementStrategy;
            private final java.lang.Number terminationDelay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replacementStrategy = software.amazon.jsii.Kernel.get(this, "replacementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationDelay = software.amazon.jsii.Kernel.get(this, "terminationDelay", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replacementStrategy = builder.replacementStrategy;
                this.terminationDelay = builder.terminationDelay;
            }

            @Override
            public final java.lang.String getReplacementStrategy() {
                return this.replacementStrategy;
            }

            @Override
            public final java.lang.Number getTerminationDelay() {
                return this.terminationDelay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplacementStrategy() != null) {
                    data.set("replacementStrategy", om.valueToTree(this.getReplacementStrategy()));
                }
                if (this.getTerminationDelay() != null) {
                    data.set("terminationDelay", om.valueToTree(this.getTerminationDelay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotCapacityRebalanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotCapacityRebalanceProperty.Jsii$Proxy that = (SpotCapacityRebalanceProperty.Jsii$Proxy) o;

                if (this.replacementStrategy != null ? !this.replacementStrategy.equals(that.replacementStrategy) : that.replacementStrategy != null) return false;
                return this.terminationDelay != null ? this.terminationDelay.equals(that.terminationDelay) : that.terminationDelay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replacementStrategy != null ? this.replacementStrategy.hashCode() : 0;
                result = 31 * result + (this.terminationDelay != null ? this.terminationDelay.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the launch specification for one or more Spot Instances.
     * <p>
     * If you include On-Demand capacity in your fleet request, you can't use <code>SpotFleetLaunchSpecification</code> ; you must use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html">LaunchTemplateConfig</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotFleetLaunchSpecificationProperty spotFleetLaunchSpecificationProperty = SpotFleetLaunchSpecificationProperty.builder()
     *         .imageId("imageId")
     *         // the properties below are optional
     *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
     *                 .deviceName("deviceName")
     *                 // the properties below are optional
     *                 .ebs(EbsBlockDeviceProperty.builder()
     *                         .deleteOnTermination(false)
     *                         .encrypted(false)
     *                         .iops(123)
     *                         .snapshotId("snapshotId")
     *                         .volumeSize(123)
     *                         .volumeType("volumeType")
     *                         .build())
     *                 .noDevice("noDevice")
     *                 .virtualName("virtualName")
     *                 .build()))
     *         .ebsOptimized(false)
     *         .iamInstanceProfile(IamInstanceProfileSpecificationProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .kernelId("kernelId")
     *         .keyName("keyName")
     *         .monitoring(SpotFleetMonitoringProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .networkInterfaces(List.of(InstanceNetworkInterfaceSpecificationProperty.builder()
     *                 .associatePublicIpAddress(false)
     *                 .deleteOnTermination(false)
     *                 .description("description")
     *                 .deviceIndex(123)
     *                 .groups(List.of("groups"))
     *                 .ipv6AddressCount(123)
     *                 .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
     *                         .ipv6Address("ipv6Address")
     *                         .build()))
     *                 .networkInterfaceId("networkInterfaceId")
     *                 .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
     *                         .privateIpAddress("privateIpAddress")
     *                         // the properties below are optional
     *                         .primary(false)
     *                         .build()))
     *                 .secondaryPrivateIpAddressCount(123)
     *                 .subnetId("subnetId")
     *                 .build()))
     *         .placement(SpotPlacementProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .groupName("groupName")
     *                 .tenancy("tenancy")
     *                 .build())
     *         .ramdiskId("ramdiskId")
     *         .securityGroups(List.of(GroupIdentifierProperty.builder()
     *                 .groupId("groupId")
     *                 .build()))
     *         .spotPrice("spotPrice")
     *         .subnetId("subnetId")
     *         .tagSpecifications(List.of(SpotFleetTagSpecificationProperty.builder()
     *                 .resourceType("resourceType")
     *                 .tags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .userData("userData")
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetLaunchSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the AMI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageId();

        /**
         * One or more block devices that are mapped to the Spot Instances.
         * <p>
         * You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
            return null;
        }

        /**
         * Indicates whether the instances are optimized for EBS I/O.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * The IAM instance profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamInstanceProfile() {
            return null;
        }

        /**
         * The attributes for the instance types.
         * <p>
         * When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * The instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The ID of the kernel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
            return null;
        }

        /**
         * The name of the key pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
            return null;
        }

        /**
         * Enable or disable monitoring for the instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoring() {
            return null;
        }

        /**
         * One or more network interfaces.
         * <p>
         * If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.
         * <p>
         * <blockquote>
         * <p>
         * <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
            return null;
        }

        /**
         * The placement information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * The ID of the RAM disk.
         * <p>
         * Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, refer to the AWS Resource Center and search for the kernel ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRamdiskId() {
            return null;
        }

        /**
         * One or more security groups.
         * <p>
         * When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroups() {
            return null;
        }

        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * <p>
         * If this value is not specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit hour, divide the Spot price by the value of <code>WeightedCapacity</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * The IDs of the subnets in which to launch the instances.
         * <p>
         * To specify multiple subnets, separate them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * The tags to apply during creation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
            return null;
        }

        /**
         * The Base64-encoded user data that instances use when starting up.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
            return null;
        }

        /**
         * The number of units provided by the specified instance type.
         * <p>
         * These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         * <p>
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetLaunchSpecificationProperty> {
            java.lang.String imageId;
            java.lang.Object blockDeviceMappings;
            java.lang.Object ebsOptimized;
            java.lang.Object iamInstanceProfile;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.String kernelId;
            java.lang.String keyName;
            java.lang.Object monitoring;
            java.lang.Object networkInterfaces;
            java.lang.Object placement;
            java.lang.String ramdiskId;
            java.lang.Object securityGroups;
            java.lang.String spotPrice;
            java.lang.String subnetId;
            java.lang.Object tagSpecifications;
            java.lang.String userData;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getImageId}
             * @param imageId The ID of the AMI. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings One or more block devices that are mapped to the Spot Instances.
             *                            You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getBlockDeviceMappings}
             * @param blockDeviceMappings One or more block devices that are mapped to the Spot Instances.
             *                            You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the instances are optimized for EBS I/O.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
             *                     <p>
             *                     Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether the instances are optimized for EBS I/O.
             *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
             *                     <p>
             *                     Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getIamInstanceProfile}
             * @param iamInstanceProfile The IAM instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.core.IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getIamInstanceProfile}
             * @param iamInstanceProfile The IAM instance profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamInstanceProfile(software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.core.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getInstanceType}
             * @param instanceType The instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getKernelId}
             * @param kernelId The ID of the kernel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelId(java.lang.String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getKeyName}
             * @param keyName The name of the key pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyName(java.lang.String keyName) {
                this.keyName = keyName;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getMonitoring}
             * @param monitoring Enable or disable monitoring for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.core.IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getMonitoring}
             * @param monitoring Enable or disable monitoring for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces.
             *                          If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a> .
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(software.amazon.awscdk.core.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces.
             *                          If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a> .
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getPlacement}
             * @param placement The placement information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getPlacement}
             * @param placement The placement information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getRamdiskId}
             * @param ramdiskId The ID of the RAM disk.
             *                  Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, refer to the AWS Resource Center and search for the kernel ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ramdiskId(java.lang.String ramdiskId) {
                this.ramdiskId = ramdiskId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSecurityGroups}
             * @param securityGroups One or more security groups.
             *                       When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(software.amazon.awscdk.core.IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSecurityGroups}
             * @param securityGroups One or more security groups.
             *                       When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<? extends java.lang.Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSpotPrice}
             * @param spotPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
             *                  If this value is not specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit hour, divide the Spot price by the value of <code>WeightedCapacity</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getSubnetId}
             * @param subnetId The IDs of the subnets in which to launch the instances.
             *                 To specify multiple subnets, separate them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply during creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply during creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getUserData}
             * @param userData The Base64-encoded user data that instances use when starting up.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userData(java.lang.String userData) {
                this.userData = userData;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetLaunchSpecificationProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units provided by the specified instance type.
             *                         These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
             *                         <p>
             *                         If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetLaunchSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetLaunchSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetLaunchSpecificationProperty {
            private final java.lang.String imageId;
            private final java.lang.Object blockDeviceMappings;
            private final java.lang.Object ebsOptimized;
            private final java.lang.Object iamInstanceProfile;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.String kernelId;
            private final java.lang.String keyName;
            private final java.lang.Object monitoring;
            private final java.lang.Object networkInterfaces;
            private final java.lang.Object placement;
            private final java.lang.String ramdiskId;
            private final java.lang.Object securityGroups;
            private final java.lang.String spotPrice;
            private final java.lang.String subnetId;
            private final java.lang.Object tagSpecifications;
            private final java.lang.String userData;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamInstanceProfile = software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kernelId = software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ramdiskId = software.amazon.jsii.Kernel.get(this, "ramdiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageId = java.util.Objects.requireNonNull(builder.imageId, "imageId is required");
                this.blockDeviceMappings = builder.blockDeviceMappings;
                this.ebsOptimized = builder.ebsOptimized;
                this.iamInstanceProfile = builder.iamInstanceProfile;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.kernelId = builder.kernelId;
                this.keyName = builder.keyName;
                this.monitoring = builder.monitoring;
                this.networkInterfaces = builder.networkInterfaces;
                this.placement = builder.placement;
                this.ramdiskId = builder.ramdiskId;
                this.securityGroups = builder.securityGroups;
                this.spotPrice = builder.spotPrice;
                this.subnetId = builder.subnetId;
                this.tagSpecifications = builder.tagSpecifications;
                this.userData = builder.userData;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public final java.lang.Object getBlockDeviceMappings() {
                return this.blockDeviceMappings;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public final java.lang.Object getIamInstanceProfile() {
                return this.iamInstanceProfile;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getKernelId() {
                return this.kernelId;
            }

            @Override
            public final java.lang.String getKeyName() {
                return this.keyName;
            }

            @Override
            public final java.lang.Object getMonitoring() {
                return this.monitoring;
            }

            @Override
            public final java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.String getRamdiskId() {
                return this.ramdiskId;
            }

            @Override
            public final java.lang.Object getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public final java.lang.String getUserData() {
                return this.userData;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageId", om.valueToTree(this.getImageId()));
                if (this.getBlockDeviceMappings() != null) {
                    data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getIamInstanceProfile() != null) {
                    data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getKernelId() != null) {
                    data.set("kernelId", om.valueToTree(this.getKernelId()));
                }
                if (this.getKeyName() != null) {
                    data.set("keyName", om.valueToTree(this.getKeyName()));
                }
                if (this.getMonitoring() != null) {
                    data.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getNetworkInterfaces() != null) {
                    data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getRamdiskId() != null) {
                    data.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getTagSpecifications() != null) {
                    data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getUserData() != null) {
                    data.set("userData", om.valueToTree(this.getUserData()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetLaunchSpecificationProperty.Jsii$Proxy that = (SpotFleetLaunchSpecificationProperty.Jsii$Proxy) o;

                if (!imageId.equals(that.imageId)) return false;
                if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
                if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.ramdiskId != null ? !this.ramdiskId.equals(that.ramdiskId) : that.ramdiskId != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageId.hashCode();
                result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
                result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.ramdiskId != null ? this.ramdiskId.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes whether monitoring is enabled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotFleetMonitoringProperty spotFleetMonitoringProperty = SpotFleetMonitoringProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetMonitoringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables monitoring for the instance.
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetMonitoringProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link SpotFleetMonitoringProperty#getEnabled}
             * @param enabled Enables monitoring for the instance.
             *                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetMonitoringProperty#getEnabled}
             * @param enabled Enables monitoring for the instance.
             *                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetMonitoringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetMonitoringProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetMonitoringProperty.Jsii$Proxy that = (SpotFleetMonitoringProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a Spot Fleet request.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet.html">How Spot Fleet Works</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
     * <p>
     * You must specify either <code>LaunchSpecifications</code> or <code>LaunchTemplateConfigs</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotFleetRequestConfigDataProperty spotFleetRequestConfigDataProperty = SpotFleetRequestConfigDataProperty.builder()
     *         .iamFleetRole("iamFleetRole")
     *         .targetCapacity(123)
     *         // the properties below are optional
     *         .allocationStrategy("allocationStrategy")
     *         .context("context")
     *         .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
     *         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *         .instancePoolsToUseCount(123)
     *         .launchSpecifications(List.of(SpotFleetLaunchSpecificationProperty.builder()
     *                 .imageId("imageId")
     *                 // the properties below are optional
     *                 .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
     *                         .deviceName("deviceName")
     *                         // the properties below are optional
     *                         .ebs(EbsBlockDeviceProperty.builder()
     *                                 .deleteOnTermination(false)
     *                                 .encrypted(false)
     *                                 .iops(123)
     *                                 .snapshotId("snapshotId")
     *                                 .volumeSize(123)
     *                                 .volumeType("volumeType")
     *                                 .build())
     *                         .noDevice("noDevice")
     *                         .virtualName("virtualName")
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .iamInstanceProfile(IamInstanceProfileSpecificationProperty.builder()
     *                         .arn("arn")
     *                         .build())
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .kernelId("kernelId")
     *                 .keyName("keyName")
     *                 .monitoring(SpotFleetMonitoringProperty.builder()
     *                         .enabled(false)
     *                         .build())
     *                 .networkInterfaces(List.of(InstanceNetworkInterfaceSpecificationProperty.builder()
     *                         .associatePublicIpAddress(false)
     *                         .deleteOnTermination(false)
     *                         .description("description")
     *                         .deviceIndex(123)
     *                         .groups(List.of("groups"))
     *                         .ipv6AddressCount(123)
     *                         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
     *                                 .ipv6Address("ipv6Address")
     *                                 .build()))
     *                         .networkInterfaceId("networkInterfaceId")
     *                         .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
     *                                 .privateIpAddress("privateIpAddress")
     *                                 // the properties below are optional
     *                                 .primary(false)
     *                                 .build()))
     *                         .secondaryPrivateIpAddressCount(123)
     *                         .subnetId("subnetId")
     *                         .build()))
     *                 .placement(SpotPlacementProperty.builder()
     *                         .availabilityZone("availabilityZone")
     *                         .groupName("groupName")
     *                         .tenancy("tenancy")
     *                         .build())
     *                 .ramdiskId("ramdiskId")
     *                 .securityGroups(List.of(GroupIdentifierProperty.builder()
     *                         .groupId("groupId")
     *                         .build()))
     *                 .spotPrice("spotPrice")
     *                 .subnetId("subnetId")
     *                 .tagSpecifications(List.of(SpotFleetTagSpecificationProperty.builder()
     *                         .resourceType("resourceType")
     *                         .tags(List.of(CfnTag.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build()))
     *                 .userData("userData")
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .launchTemplateConfigs(List.of(LaunchTemplateConfigProperty.builder()
     *                 .launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty.builder()
     *                         .version("version")
     *                         // the properties below are optional
     *                         .launchTemplateId("launchTemplateId")
     *                         .launchTemplateName("launchTemplateName")
     *                         .build())
     *                 .overrides(List.of(LaunchTemplateOverridesProperty.builder()
     *                         .availabilityZone("availabilityZone")
     *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                                 .acceleratorNames(List.of("acceleratorNames"))
     *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                                 .bareMetal("bareMetal")
     *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .burstablePerformance("burstablePerformance")
     *                                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                                 .instanceGenerations(List.of("instanceGenerations"))
     *                                 .localStorage("localStorage")
     *                                 .localStorageTypes(List.of("localStorageTypes"))
     *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                                 .requireHibernateSupport(false)
     *                                 .spotMaxPricePercentageOverLowestPrice(123)
     *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                         .max(123)
     *                                         .min(123)
     *                                         .build())
     *                                 .build())
     *                         .instanceType("instanceType")
     *                         .priority(123)
     *                         .spotPrice("spotPrice")
     *                         .subnetId("subnetId")
     *                         .weightedCapacity(123)
     *                         .build()))
     *                 .build()))
     *         .loadBalancersConfig(LoadBalancersConfigProperty.builder()
     *                 .classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty.builder()
     *                         .classicLoadBalancers(List.of(ClassicLoadBalancerProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .targetGroupsConfig(TargetGroupsConfigProperty.builder()
     *                         .targetGroups(List.of(TargetGroupProperty.builder()
     *                                 .arn("arn")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .onDemandAllocationStrategy("onDemandAllocationStrategy")
     *         .onDemandMaxTotalPrice("onDemandMaxTotalPrice")
     *         .onDemandTargetCapacity(123)
     *         .replaceUnhealthyInstances(false)
     *         .spotMaintenanceStrategies(SpotMaintenanceStrategiesProperty.builder()
     *                 .capacityRebalance(SpotCapacityRebalanceProperty.builder()
     *                         .replacementStrategy("replacementStrategy")
     *                         .terminationDelay(123)
     *                         .build())
     *                 .build())
     *         .spotMaxTotalPrice("spotMaxTotalPrice")
     *         .spotPrice("spotPrice")
     *         .targetCapacityUnitType("targetCapacityUnitType")
     *         .terminateInstancesWithExpiration(false)
     *         .type("type")
     *         .validFrom("validFrom")
     *         .validUntil("validUntil")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetRequestConfigDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that grants the Spot Fleet the permission to request, launch, terminate, and tag instances on your behalf.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot Fleet Prerequisites</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> . Spot Fleet can terminate Spot Instances on your behalf when you cancel its Spot Fleet request or when the Spot Fleet request expires, if you set <code>TerminateInstancesWithExpiration</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamFleetRole();

        /**
         * The number of units to request for the Spot Fleet.
         * <p>
         * You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of 0 and add capacity later.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetCapacity();

        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the Spot Fleet request.
         * <p>
         * If the allocation strategy is <code>lowestPrice</code> , Spot Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * <p>
         * If the allocation strategy is <code>diversified</code> , Spot Fleet launches instances from all the Spot Instance pools that you specify.
         * <p>
         * If the allocation strategy is <code>capacityOptimized</code> (recommended), Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To give certain instance types a higher chance of launching first, use <code>capacityOptimizedPrioritized</code> . Set a priority for each instance type by using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code> . You can assign the same priority to different <code>LaunchTemplateOverrides</code> . EC2 implements the priorities on a best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code> , the same priority is applied when fulfilling On-Demand capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * Reserved.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContext() {
            return null;
        }

        /**
         * Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot Fleet request below the current size of the Spot Fleet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
            return null;
        }

        /**
         * The behavior when a Spot Instance is interrupted.
         * <p>
         * The default is <code>terminate</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * The number of Spot pools across which to allocate your target Spot capacity.
         * <p>
         * Valid only when Spot <em>AllocationStrategy</em> is set to <code>lowest-price</code> . Spot Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * <p>
         * Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstancePoolsToUseCount() {
            return null;
        }

        /**
         * The launch specifications for the Spot Fleet request.
         * <p>
         * If you specify <code>LaunchSpecifications</code> , you can't specify <code>LaunchTemplateConfigs</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchSpecifications() {
            return null;
        }

        /**
         * The launch template and overrides.
         * <p>
         * If you specify <code>LaunchTemplateConfigs</code> , you can't specify <code>LaunchSpecifications</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateConfigs() {
            return null;
        }

        /**
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request.
         * <p>
         * Spot Fleet registers the running Spot Instances with the specified Classic Load Balancers and target groups.
         * <p>
         * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancersConfig() {
            return null;
        }

        /**
         * The order of the launch template overrides to use in fulfilling On-Demand capacity.
         * <p>
         * If you specify <code>lowestPrice</code> , Spot Fleet uses price to determine the order, launching the lowest price first. If you specify <code>prioritized</code> , Spot Fleet uses the priority that you assign to each Spot Fleet launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to <code>lowestPrice</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnDemandAllocationStrategy() {
            return null;
        }

        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay.
         * <p>
         * You can use the <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnDemandMaxTotalPrice() {
            return null;
        }

        /**
         * The number of On-Demand units to request.
         * <p>
         * You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of 0 and add capacity later.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandTargetCapacity() {
            return null;
        }

        /**
         * Indicates whether Spot Fleet should replace unhealthy instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
            return null;
        }

        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotMaintenanceStrategies() {
            return null;
        }

        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         * <p>
         * You can use the <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotMaxTotalPrice() {
            return null;
        }

        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * <p>
         * The default is the On-Demand price.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
            return null;
        }

        /**
         * The unit for the target capacity.
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetCapacityUnitType() {
            return null;
        }

        /**
         * Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
            return null;
        }

        /**
         * The type of request.
         * <p>
         * Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it. When this value is <code>request</code> , the Spot Fleet only places the required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code> , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code> . <code>instant</code> is listed but is not used by Spot Fleet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The start date and time of the request, in UTC format ( *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         * <p>
         * By default, Amazon EC2 starts fulfilling the request immediately.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
            return null;
        }

        /**
         * The end date and time of the request, in UTC format ( *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         * <p>
         * After the end date and time, no new Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you cancel it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetRequestConfigDataProperty> {
            java.lang.String iamFleetRole;
            java.lang.Number targetCapacity;
            java.lang.String allocationStrategy;
            java.lang.String context;
            java.lang.String excessCapacityTerminationPolicy;
            java.lang.String instanceInterruptionBehavior;
            java.lang.Number instancePoolsToUseCount;
            java.lang.Object launchSpecifications;
            java.lang.Object launchTemplateConfigs;
            java.lang.Object loadBalancersConfig;
            java.lang.String onDemandAllocationStrategy;
            java.lang.String onDemandMaxTotalPrice;
            java.lang.Number onDemandTargetCapacity;
            java.lang.Object replaceUnhealthyInstances;
            java.lang.Object spotMaintenanceStrategies;
            java.lang.String spotMaxTotalPrice;
            java.lang.String spotPrice;
            java.lang.String targetCapacityUnitType;
            java.lang.Object terminateInstancesWithExpiration;
            java.lang.String type;
            java.lang.String validFrom;
            java.lang.String validUntil;

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getIamFleetRole}
             * @param iamFleetRole The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that grants the Spot Fleet the permission to request, launch, terminate, and tag instances on your behalf. This parameter is required.
             *                     For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot Fleet Prerequisites</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> . Spot Fleet can terminate Spot Instances on your behalf when you cancel its Spot Fleet request or when the Spot Fleet request expires, if you set <code>TerminateInstancesWithExpiration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamFleetRole(java.lang.String iamFleetRole) {
                this.iamFleetRole = iamFleetRole;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTargetCapacity}
             * @param targetCapacity The number of units to request for the Spot Fleet. This parameter is required.
             *                       You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of 0 and add capacity later.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacity(java.lang.Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getAllocationStrategy}
             * @param allocationStrategy Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the Spot Fleet request.
             *                           If the allocation strategy is <code>lowestPrice</code> , Spot Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
             *                           <p>
             *                           If the allocation strategy is <code>diversified</code> , Spot Fleet launches instances from all the Spot Instance pools that you specify.
             *                           <p>
             *                           If the allocation strategy is <code>capacityOptimized</code> (recommended), Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To give certain instance types a higher chance of launching first, use <code>capacityOptimizedPrioritized</code> . Set a priority for each instance type by using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code> . You can assign the same priority to different <code>LaunchTemplateOverrides</code> . EC2 implements the priorities on a best-effort basis, but optimizes for capacity first. <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses a launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code> , the same priority is applied when fulfilling On-Demand capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getContext}
             * @param context Reserved.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder context(java.lang.String context) {
                this.context = context;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getExcessCapacityTerminationPolicy}
             * @param excessCapacityTerminationPolicy Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot Fleet request below the current size of the Spot Fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excessCapacityTerminationPolicy(java.lang.String excessCapacityTerminationPolicy) {
                this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted.
             *                                     The default is <code>terminate</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getInstancePoolsToUseCount}
             * @param instancePoolsToUseCount The number of Spot pools across which to allocate your target Spot capacity.
             *                                Valid only when Spot <em>AllocationStrategy</em> is set to <code>lowest-price</code> . Spot Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
             *                                <p>
             *                                Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePoolsToUseCount(java.lang.Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specifications for the Spot Fleet request.
             *                             If you specify <code>LaunchSpecifications</code> , you can't specify <code>LaunchTemplateConfigs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(software.amazon.awscdk.core.IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specifications for the Spot Fleet request.
             *                             If you specify <code>LaunchSpecifications</code> , you can't specify <code>LaunchTemplateConfigs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchSpecifications(java.util.List<? extends java.lang.Object> launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchTemplateConfigs}
             * @param launchTemplateConfigs The launch template and overrides.
             *                              If you specify <code>LaunchTemplateConfigs</code> , you can't specify <code>LaunchSpecifications</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigs(software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLaunchTemplateConfigs}
             * @param launchTemplateConfigs The launch template and overrides.
             *                              If you specify <code>LaunchTemplateConfigs</code> , you can't specify <code>LaunchSpecifications</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateConfigs(java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLoadBalancersConfig}
             * @param loadBalancersConfig One or more Classic Load Balancers and target groups to attach to the Spot Fleet request.
             *                            Spot Fleet registers the running Spot Instances with the specified Classic Load Balancers and target groups.
             *                            <p>
             *                            With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancersConfig(software.amazon.awscdk.core.IResolvable loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getLoadBalancersConfig}
             * @param loadBalancersConfig One or more Classic Load Balancers and target groups to attach to the Spot Fleet request.
             *                            Spot Fleet registers the running Spot Instances with the specified Classic Load Balancers and target groups.
             *                            <p>
             *                            With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancersConfig(software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getOnDemandAllocationStrategy}
             * @param onDemandAllocationStrategy The order of the launch template overrides to use in fulfilling On-Demand capacity.
             *                                   If you specify <code>lowestPrice</code> , Spot Fleet uses price to determine the order, launching the lowest price first. If you specify <code>prioritized</code> , Spot Fleet uses the priority that you assign to each Spot Fleet launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to <code>lowestPrice</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandAllocationStrategy(java.lang.String onDemandAllocationStrategy) {
                this.onDemandAllocationStrategy = onDemandAllocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getOnDemandMaxTotalPrice}
             * @param onDemandMaxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
             *                              You can use the <code>onDemandMaxTotalPrice</code> parameter, the <code>spotMaxTotalPrice</code> parameter, or both parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxTotalPrice(java.lang.String onDemandMaxTotalPrice) {
                this.onDemandMaxTotalPrice = onDemandMaxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getOnDemandTargetCapacity}
             * @param onDemandTargetCapacity The number of On-Demand units to request.
             *                               You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of 0 and add capacity later.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandTargetCapacity(java.lang.Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getReplaceUnhealthyInstances}
             * @param replaceUnhealthyInstances Indicates whether Spot Fleet should replace unhealthy instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceUnhealthyInstances(java.lang.Boolean replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getReplaceUnhealthyInstances}
             * @param replaceUnhealthyInstances Indicates whether Spot Fleet should replace unhealthy instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceUnhealthyInstances(software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getSpotMaintenanceStrategies}
             * @param spotMaintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaintenanceStrategies(software.amazon.awscdk.core.IResolvable spotMaintenanceStrategies) {
                this.spotMaintenanceStrategies = spotMaintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getSpotMaintenanceStrategies}
             * @param spotMaintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaintenanceStrategies(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotMaintenanceStrategiesProperty spotMaintenanceStrategies) {
                this.spotMaintenanceStrategies = spotMaintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getSpotMaxTotalPrice}
             * @param spotMaxTotalPrice The maximum amount per hour for Spot Instances that you're willing to pay.
             *                          You can use the <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code> parameter, or both parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxTotalPrice(java.lang.String spotMaxTotalPrice) {
                this.spotMaxTotalPrice = spotMaxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getSpotPrice}
             * @param spotPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
             *                  The default is the On-Demand price.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotPrice(java.lang.String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTargetCapacityUnitType}
             * @param targetCapacityUnitType The unit for the target capacity.
             *                               Default: <code>units</code> (translates to number of instances)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacityUnitType(java.lang.String targetCapacityUnitType) {
                this.targetCapacityUnitType = targetCapacityUnitType;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTerminateInstancesWithExpiration}
             * @param terminateInstancesWithExpiration Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateInstancesWithExpiration(java.lang.Boolean terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getTerminateInstancesWithExpiration}
             * @param terminateInstancesWithExpiration Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminateInstancesWithExpiration(software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getType}
             * @param type The type of request.
             *             Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it. When this value is <code>request</code> , the Spot Fleet only places the required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code> , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code> . <code>instant</code> is listed but is not used by Spot Fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getValidFrom}
             * @param validFrom The start date and time of the request, in UTC format ( *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
             *                  By default, Amazon EC2 starts fulfilling the request immediately.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validFrom(java.lang.String validFrom) {
                this.validFrom = validFrom;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetRequestConfigDataProperty#getValidUntil}
             * @param validUntil The end date and time of the request, in UTC format ( *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
             *                   After the end date and time, no new Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you cancel it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validUntil(java.lang.String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetRequestConfigDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetRequestConfigDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetRequestConfigDataProperty {
            private final java.lang.String iamFleetRole;
            private final java.lang.Number targetCapacity;
            private final java.lang.String allocationStrategy;
            private final java.lang.String context;
            private final java.lang.String excessCapacityTerminationPolicy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Number instancePoolsToUseCount;
            private final java.lang.Object launchSpecifications;
            private final java.lang.Object launchTemplateConfigs;
            private final java.lang.Object loadBalancersConfig;
            private final java.lang.String onDemandAllocationStrategy;
            private final java.lang.String onDemandMaxTotalPrice;
            private final java.lang.Number onDemandTargetCapacity;
            private final java.lang.Object replaceUnhealthyInstances;
            private final java.lang.Object spotMaintenanceStrategies;
            private final java.lang.String spotMaxTotalPrice;
            private final java.lang.String spotPrice;
            private final java.lang.String targetCapacityUnitType;
            private final java.lang.Object terminateInstancesWithExpiration;
            private final java.lang.String type;
            private final java.lang.String validFrom;
            private final java.lang.String validUntil;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamFleetRole = software.amazon.jsii.Kernel.get(this, "iamFleetRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetCapacity = software.amazon.jsii.Kernel.get(this, "targetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excessCapacityTerminationPolicy = software.amazon.jsii.Kernel.get(this, "excessCapacityTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instancePoolsToUseCount = software.amazon.jsii.Kernel.get(this, "instancePoolsToUseCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.launchSpecifications = software.amazon.jsii.Kernel.get(this, "launchSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.launchTemplateConfigs = software.amazon.jsii.Kernel.get(this, "launchTemplateConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loadBalancersConfig = software.amazon.jsii.Kernel.get(this, "loadBalancersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandAllocationStrategy = software.amazon.jsii.Kernel.get(this, "onDemandAllocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onDemandMaxTotalPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onDemandTargetCapacity = software.amazon.jsii.Kernel.get(this, "onDemandTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.replaceUnhealthyInstances = software.amazon.jsii.Kernel.get(this, "replaceUnhealthyInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaintenanceStrategies = software.amazon.jsii.Kernel.get(this, "spotMaintenanceStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxTotalPrice = software.amazon.jsii.Kernel.get(this, "spotMaxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetCapacityUnitType = software.amazon.jsii.Kernel.get(this, "targetCapacityUnitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminateInstancesWithExpiration = software.amazon.jsii.Kernel.get(this, "terminateInstancesWithExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validFrom = software.amazon.jsii.Kernel.get(this, "validFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validUntil = software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamFleetRole = java.util.Objects.requireNonNull(builder.iamFleetRole, "iamFleetRole is required");
                this.targetCapacity = java.util.Objects.requireNonNull(builder.targetCapacity, "targetCapacity is required");
                this.allocationStrategy = builder.allocationStrategy;
                this.context = builder.context;
                this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
                this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
                this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
                this.launchSpecifications = builder.launchSpecifications;
                this.launchTemplateConfigs = builder.launchTemplateConfigs;
                this.loadBalancersConfig = builder.loadBalancersConfig;
                this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
                this.onDemandMaxTotalPrice = builder.onDemandMaxTotalPrice;
                this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
                this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
                this.spotMaintenanceStrategies = builder.spotMaintenanceStrategies;
                this.spotMaxTotalPrice = builder.spotMaxTotalPrice;
                this.spotPrice = builder.spotPrice;
                this.targetCapacityUnitType = builder.targetCapacityUnitType;
                this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
                this.type = builder.type;
                this.validFrom = builder.validFrom;
                this.validUntil = builder.validUntil;
            }

            @Override
            public final java.lang.String getIamFleetRole() {
                return this.iamFleetRole;
            }

            @Override
            public final java.lang.Number getTargetCapacity() {
                return this.targetCapacity;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.String getContext() {
                return this.context;
            }

            @Override
            public final java.lang.String getExcessCapacityTerminationPolicy() {
                return this.excessCapacityTerminationPolicy;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.Number getInstancePoolsToUseCount() {
                return this.instancePoolsToUseCount;
            }

            @Override
            public final java.lang.Object getLaunchSpecifications() {
                return this.launchSpecifications;
            }

            @Override
            public final java.lang.Object getLaunchTemplateConfigs() {
                return this.launchTemplateConfigs;
            }

            @Override
            public final java.lang.Object getLoadBalancersConfig() {
                return this.loadBalancersConfig;
            }

            @Override
            public final java.lang.String getOnDemandAllocationStrategy() {
                return this.onDemandAllocationStrategy;
            }

            @Override
            public final java.lang.String getOnDemandMaxTotalPrice() {
                return this.onDemandMaxTotalPrice;
            }

            @Override
            public final java.lang.Number getOnDemandTargetCapacity() {
                return this.onDemandTargetCapacity;
            }

            @Override
            public final java.lang.Object getReplaceUnhealthyInstances() {
                return this.replaceUnhealthyInstances;
            }

            @Override
            public final java.lang.Object getSpotMaintenanceStrategies() {
                return this.spotMaintenanceStrategies;
            }

            @Override
            public final java.lang.String getSpotMaxTotalPrice() {
                return this.spotMaxTotalPrice;
            }

            @Override
            public final java.lang.String getSpotPrice() {
                return this.spotPrice;
            }

            @Override
            public final java.lang.String getTargetCapacityUnitType() {
                return this.targetCapacityUnitType;
            }

            @Override
            public final java.lang.Object getTerminateInstancesWithExpiration() {
                return this.terminateInstancesWithExpiration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValidFrom() {
                return this.validFrom;
            }

            @Override
            public final java.lang.String getValidUntil() {
                return this.validUntil;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("iamFleetRole", om.valueToTree(this.getIamFleetRole()));
                data.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getContext() != null) {
                    data.set("context", om.valueToTree(this.getContext()));
                }
                if (this.getExcessCapacityTerminationPolicy() != null) {
                    data.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getInstancePoolsToUseCount() != null) {
                    data.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                }
                if (this.getLaunchSpecifications() != null) {
                    data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                }
                if (this.getLaunchTemplateConfigs() != null) {
                    data.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
                }
                if (this.getLoadBalancersConfig() != null) {
                    data.set("loadBalancersConfig", om.valueToTree(this.getLoadBalancersConfig()));
                }
                if (this.getOnDemandAllocationStrategy() != null) {
                    data.set("onDemandAllocationStrategy", om.valueToTree(this.getOnDemandAllocationStrategy()));
                }
                if (this.getOnDemandMaxTotalPrice() != null) {
                    data.set("onDemandMaxTotalPrice", om.valueToTree(this.getOnDemandMaxTotalPrice()));
                }
                if (this.getOnDemandTargetCapacity() != null) {
                    data.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                }
                if (this.getReplaceUnhealthyInstances() != null) {
                    data.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
                }
                if (this.getSpotMaintenanceStrategies() != null) {
                    data.set("spotMaintenanceStrategies", om.valueToTree(this.getSpotMaintenanceStrategies()));
                }
                if (this.getSpotMaxTotalPrice() != null) {
                    data.set("spotMaxTotalPrice", om.valueToTree(this.getSpotMaxTotalPrice()));
                }
                if (this.getSpotPrice() != null) {
                    data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                }
                if (this.getTargetCapacityUnitType() != null) {
                    data.set("targetCapacityUnitType", om.valueToTree(this.getTargetCapacityUnitType()));
                }
                if (this.getTerminateInstancesWithExpiration() != null) {
                    data.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValidFrom() != null) {
                    data.set("validFrom", om.valueToTree(this.getValidFrom()));
                }
                if (this.getValidUntil() != null) {
                    data.set("validUntil", om.valueToTree(this.getValidUntil()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetRequestConfigDataProperty.Jsii$Proxy that = (SpotFleetRequestConfigDataProperty.Jsii$Proxy) o;

                if (!iamFleetRole.equals(that.iamFleetRole)) return false;
                if (!targetCapacity.equals(that.targetCapacity)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
                if (this.excessCapacityTerminationPolicy != null ? !this.excessCapacityTerminationPolicy.equals(that.excessCapacityTerminationPolicy) : that.excessCapacityTerminationPolicy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.instancePoolsToUseCount != null ? !this.instancePoolsToUseCount.equals(that.instancePoolsToUseCount) : that.instancePoolsToUseCount != null) return false;
                if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
                if (this.launchTemplateConfigs != null ? !this.launchTemplateConfigs.equals(that.launchTemplateConfigs) : that.launchTemplateConfigs != null) return false;
                if (this.loadBalancersConfig != null ? !this.loadBalancersConfig.equals(that.loadBalancersConfig) : that.loadBalancersConfig != null) return false;
                if (this.onDemandAllocationStrategy != null ? !this.onDemandAllocationStrategy.equals(that.onDemandAllocationStrategy) : that.onDemandAllocationStrategy != null) return false;
                if (this.onDemandMaxTotalPrice != null ? !this.onDemandMaxTotalPrice.equals(that.onDemandMaxTotalPrice) : that.onDemandMaxTotalPrice != null) return false;
                if (this.onDemandTargetCapacity != null ? !this.onDemandTargetCapacity.equals(that.onDemandTargetCapacity) : that.onDemandTargetCapacity != null) return false;
                if (this.replaceUnhealthyInstances != null ? !this.replaceUnhealthyInstances.equals(that.replaceUnhealthyInstances) : that.replaceUnhealthyInstances != null) return false;
                if (this.spotMaintenanceStrategies != null ? !this.spotMaintenanceStrategies.equals(that.spotMaintenanceStrategies) : that.spotMaintenanceStrategies != null) return false;
                if (this.spotMaxTotalPrice != null ? !this.spotMaxTotalPrice.equals(that.spotMaxTotalPrice) : that.spotMaxTotalPrice != null) return false;
                if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
                if (this.targetCapacityUnitType != null ? !this.targetCapacityUnitType.equals(that.targetCapacityUnitType) : that.targetCapacityUnitType != null) return false;
                if (this.terminateInstancesWithExpiration != null ? !this.terminateInstancesWithExpiration.equals(that.terminateInstancesWithExpiration) : that.terminateInstancesWithExpiration != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.validFrom != null ? !this.validFrom.equals(that.validFrom) : that.validFrom != null) return false;
                return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iamFleetRole.hashCode();
                result = 31 * result + (this.targetCapacity.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
                result = 31 * result + (this.excessCapacityTerminationPolicy != null ? this.excessCapacityTerminationPolicy.hashCode() : 0);
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.hashCode() : 0);
                result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
                result = 31 * result + (this.launchTemplateConfigs != null ? this.launchTemplateConfigs.hashCode() : 0);
                result = 31 * result + (this.loadBalancersConfig != null ? this.loadBalancersConfig.hashCode() : 0);
                result = 31 * result + (this.onDemandAllocationStrategy != null ? this.onDemandAllocationStrategy.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxTotalPrice != null ? this.onDemandMaxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.onDemandTargetCapacity != null ? this.onDemandTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.replaceUnhealthyInstances != null ? this.replaceUnhealthyInstances.hashCode() : 0);
                result = 31 * result + (this.spotMaintenanceStrategies != null ? this.spotMaintenanceStrategies.hashCode() : 0);
                result = 31 * result + (this.spotMaxTotalPrice != null ? this.spotMaxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
                result = 31 * result + (this.targetCapacityUnitType != null ? this.targetCapacityUnitType.hashCode() : 0);
                result = 31 * result + (this.terminateInstancesWithExpiration != null ? this.terminateInstancesWithExpiration.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.validFrom != null ? this.validFrom.hashCode() : 0);
                result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tags for a Spot Fleet resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotFleetTagSpecificationProperty spotFleetTagSpecificationProperty = SpotFleetTagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotFleetTagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource.
         * <p>
         * Currently, the only resource type that is supported is <code>instance</code> . To tag the Spot Fleet request on creation, use the <code>TagSpecifications</code> parameter in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetRequestConfigData.html"><code>SpotFleetRequestConfigData</code></a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotFleetTagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link SpotFleetTagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource.
             *                     Currently, the only resource type that is supported is <code>instance</code> . To tag the Spot Fleet request on creation, use the <code>TagSpecifications</code> parameter in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetRequestConfigData.html"><code>SpotFleetRequestConfigData</code></a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotFleetTagSpecificationProperty#getTags}
             * @param tags The tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotFleetTagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotFleetTagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotFleetTagSpecificationProperty.Jsii$Proxy that = (SpotFleetTagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotMaintenanceStrategiesProperty spotMaintenanceStrategiesProperty = SpotMaintenanceStrategiesProperty.builder()
     *         .capacityRebalance(SpotCapacityRebalanceProperty.builder()
     *                 .replacementStrategy("replacementStrategy")
     *                 .terminationDelay(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotMaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotMaintenanceStrategiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotMaintenanceStrategiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityRebalance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotMaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotMaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotMaintenanceStrategiesProperty> {
            java.lang.Object capacityRebalance;

            /**
             * Sets the value of {@link SpotMaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             *                          For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.core.IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Sets the value of {@link SpotMaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             *                          For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotCapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotMaintenanceStrategiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotMaintenanceStrategiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotMaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotMaintenanceStrategiesProperty {
            private final java.lang.Object capacityRebalance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityRebalance = builder.capacityRebalance;
            }

            @Override
            public final java.lang.Object getCapacityRebalance() {
                return this.capacityRebalance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityRebalance() != null) {
                    data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotMaintenanceStrategiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotMaintenanceStrategiesProperty.Jsii$Proxy that = (SpotMaintenanceStrategiesProperty.Jsii$Proxy) o;

                return this.capacityRebalance != null ? this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes Spot Instance placement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotPlacementProperty spotPlacementProperty = SpotPlacementProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .groupName("groupName")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotPlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone.
         * <p>
         * To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The name of the placement group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * The tenancy of the instance (if the instance is running in a VPC).
         * <p>
         * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotPlacementProperty> {
            java.lang.String availabilityZone;
            java.lang.String groupName;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link SpotPlacementProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone.
             *                         To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotPlacementProperty#getGroupName}
             * @param groupName The name of the placement group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link SpotPlacementProperty#getTenancy}
             * @param tenancy The tenancy of the instance (if the instance is running in a VPC).
             *                An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotPlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotPlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotPlacementProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.groupName = builder.groupName;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotPlacementProperty.Jsii$Proxy that = (SpotPlacementProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a load balancer target group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TargetGroupProperty targetGroupProperty = TargetGroupProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the target group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link TargetGroupProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the target group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupProperty.Jsii$Proxy that = (TargetGroupProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the target groups to attach to a Spot Fleet.
     * <p>
     * Spot Fleet registers the running Spot Instances with these target groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TargetGroupsConfigProperty targetGroupsConfigProperty = TargetGroupsConfigProperty.builder()
     *         .targetGroups(List.of(TargetGroupProperty.builder()
     *                 .arn("arn")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more target groups.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTargetGroups();

        /**
         * @return a {@link Builder} of {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupsConfigProperty> {
            java.lang.Object targetGroups;

            /**
             * Sets the value of {@link TargetGroupsConfigProperty#getTargetGroups}
             * @param targetGroups One or more target groups. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.core.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupsConfigProperty#getTargetGroups}
             * @param targetGroups One or more target groups. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<? extends java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupsConfigProperty {
            private final java.lang.Object targetGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroups = java.util.Objects.requireNonNull(builder.targetGroups, "targetGroups is required");
            }

            @Override
            public final java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupsConfigProperty.Jsii$Proxy that = (TargetGroupsConfigProperty.Jsii$Proxy) o;

                return this.targetGroups.equals(that.targetGroups);
            }

            @Override
            public final int hashCode() {
                int result = this.targetGroups.hashCode();
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total local storage, in GB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TotalLocalStorageGBRequestProperty totalLocalStorageGBRequestProperty = TotalLocalStorageGBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of total local storage, in GB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of total local storage, in GB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMax}
             * @param max The maximum amount of total local storage, in GB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMin}
             * @param min The minimum amount of total local storage, in GB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.TotalLocalStorageGBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBRequestProperty.Jsii$Proxy that = (TotalLocalStorageGBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of vCPUs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VCpuCountRangeRequestProperty vCpuCountRangeRequestProperty = VCpuCountRangeRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of vCPUs.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of vCPUs.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMax}
             * @param max The maximum number of vCPUs.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMin}
             * @param min The minimum number of vCPUs.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleet.VCpuCountRangeRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeRequestProperty.Jsii$Proxy that = (VCpuCountRangeRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSpotFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnSpotFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSpotFleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSpotFleetProps.Builder();
        }

        /**
         * Describes the configuration of a Spot Fleet request.
         * <p>
         * @return {@code this}
         * @param spotFleetRequestConfigData Describes the configuration of a Spot Fleet request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(final software.amazon.awscdk.core.IResolvable spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }
        /**
         * Describes the configuration of a Spot Fleet request.
         * <p>
         * @return {@code this}
         * @param spotFleetRequestConfigData Describes the configuration of a Spot Fleet request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty spotFleetRequestConfigData) {
            this.props.spotFleetRequestConfigData(spotFleetRequestConfigData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSpotFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnSpotFleet build() {
            return new software.amazon.awscdk.services.ec2.CfnSpotFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
