package software.amazon.awscdk.services.ec2;

/**
 * Block device.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * BlockDeviceVolume blockDeviceVolume;
 * BlockDevice blockDevice = BlockDevice.builder()
 *         .deviceName("deviceName")
 *         .volume(blockDeviceVolume)
 *         // the properties below are optional
 *         .mappingEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:14:06.384Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BlockDevice")
@software.amazon.jsii.Jsii.Proxy(BlockDevice.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BlockDevice extends software.amazon.jsii.JsiiSerializable {

    /**
     * The device name exposed to the EC2 instance.
     * <p>
     * For example, a value like <code>/dev/sdh</code>, <code>xvdh</code>.
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

    /**
     * Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume.
     * <p>
     * For example, a value like <code>BlockDeviceVolume.ebs(15)</code>, <code>BlockDeviceVolume.ephemeral(0)</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume getVolume();

    /**
     * If false, the device mapping will be suppressed.
     * <p>
     * If set to false for the root device, the instance might fail the Amazon EC2 health check.
     * Amazon EC2 Auto Scaling launches a replacement instance if the instance fails the health check.
     * <p>
     * Default: true - device mapping is left untouched
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMappingEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BlockDevice> {
        java.lang.String deviceName;
        software.amazon.awscdk.services.ec2.BlockDeviceVolume volume;
        java.lang.Boolean mappingEnabled;

        /**
         * Sets the value of {@link BlockDevice#getDeviceName}
         * @param deviceName The device name exposed to the EC2 instance. This parameter is required.
         *                   For example, a value like <code>/dev/sdh</code>, <code>xvdh</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceName(java.lang.String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        /**
         * Sets the value of {@link BlockDevice#getVolume}
         * @param volume Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume. This parameter is required.
         *               For example, a value like <code>BlockDeviceVolume.ebs(15)</code>, <code>BlockDeviceVolume.ephemeral(0)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volume(software.amazon.awscdk.services.ec2.BlockDeviceVolume volume) {
            this.volume = volume;
            return this;
        }

        /**
         * Sets the value of {@link BlockDevice#getMappingEnabled}
         * @param mappingEnabled If false, the device mapping will be suppressed.
         *                       If set to false for the root device, the instance might fail the Amazon EC2 health check.
         *                       Amazon EC2 Auto Scaling launches a replacement instance if the instance fails the health check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappingEnabled(java.lang.Boolean mappingEnabled) {
            this.mappingEnabled = mappingEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BlockDevice}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BlockDevice build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDevice {
        private final java.lang.String deviceName;
        private final software.amazon.awscdk.services.ec2.BlockDeviceVolume volume;
        private final java.lang.Boolean mappingEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volume = software.amazon.jsii.Kernel.get(this, "volume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class));
            this.mappingEnabled = software.amazon.jsii.Kernel.get(this, "mappingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceName = java.util.Objects.requireNonNull(builder.deviceName, "deviceName is required");
            this.volume = java.util.Objects.requireNonNull(builder.volume, "volume is required");
            this.mappingEnabled = builder.mappingEnabled;
        }

        @Override
        public final java.lang.String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.BlockDeviceVolume getVolume() {
            return this.volume;
        }

        @Override
        public final java.lang.Boolean getMappingEnabled() {
            return this.mappingEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deviceName", om.valueToTree(this.getDeviceName()));
            data.set("volume", om.valueToTree(this.getVolume()));
            if (this.getMappingEnabled() != null) {
                data.set("mappingEnabled", om.valueToTree(this.getMappingEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.BlockDevice"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BlockDevice.Jsii$Proxy that = (BlockDevice.Jsii$Proxy) o;

            if (!deviceName.equals(that.deviceName)) return false;
            if (!volume.equals(that.volume)) return false;
            return this.mappingEnabled != null ? this.mappingEnabled.equals(that.mappingEnabled) : that.mappingEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deviceName.hashCode();
            result = 31 * result + (this.volume.hashCode());
            result = 31 * result + (this.mappingEnabled != null ? this.mappingEnabled.hashCode() : 0);
            return result;
        }
    }
}
