package software.amazon.awscdk.services.ec2;

/**
 * Flow Log Destination configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * LogGroup logGroup;
 * Role role;
 * FlowLogDestinationConfig flowLogDestinationConfig = FlowLogDestinationConfig.builder()
 *         .logDestinationType(FlowLogDestinationType.CLOUD_WATCH_LOGS)
 *         // the properties below are optional
 *         .iamRole(role)
 *         .keyPrefix("keyPrefix")
 *         .logGroup(logGroup)
 *         .s3Bucket(bucket)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-23T01:54:30.395Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLogDestinationConfig")
@software.amazon.jsii.Jsii.Proxy(FlowLogDestinationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FlowLogDestinationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of destination to publish the flow logs to.
     * <p>
     * Default: - CLOUD_WATCH_LOGS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestinationType getLogDestinationType();

    /**
     * The IAM Role that has access to publish to CloudWatch logs.
     * <p>
     * Default: - default IAM role is created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getIamRole() {
        return null;
    }

    /**
     * S3 bucket key prefix to publish the flow logs to.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
        return null;
    }

    /**
     * The CloudWatch Logs Log Group to publish the flow logs to.
     * <p>
     * Default: - default log group is created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * S3 bucket to publish the flow logs to.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FlowLogDestinationConfig> {
        software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType;
        software.amazon.awscdk.services.iam.IRole iamRole;
        java.lang.String keyPrefix;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.s3.IBucket s3Bucket;

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getLogDestinationType}
         * @param logDestinationType The type of destination to publish the flow logs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getIamRole}
         * @param iamRole The IAM Role that has access to publish to CloudWatch logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRole(software.amazon.awscdk.services.iam.IRole iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getKeyPrefix}
         * @param keyPrefix S3 bucket key prefix to publish the flow logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPrefix(java.lang.String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getLogGroup}
         * @param logGroup The CloudWatch Logs Log Group to publish the flow logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getS3Bucket}
         * @param s3Bucket S3 bucket to publish the flow logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Bucket(software.amazon.awscdk.services.s3.IBucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowLogDestinationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FlowLogDestinationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowLogDestinationConfig {
        private final software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType;
        private final software.amazon.awscdk.services.iam.IRole iamRole;
        private final java.lang.String keyPrefix;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.s3.IBucket s3Bucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDestinationType = software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestinationType.class));
            this.iamRole = software.amazon.jsii.Kernel.get(this, "iamRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDestinationType = java.util.Objects.requireNonNull(builder.logDestinationType, "logDestinationType is required");
            this.iamRole = builder.iamRole;
            this.keyPrefix = builder.keyPrefix;
            this.logGroup = builder.logGroup;
            this.s3Bucket = builder.s3Bucket;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.FlowLogDestinationType getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getIamRole() {
            return this.iamRole;
        }

        @Override
        public final java.lang.String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            if (this.getIamRole() != null) {
                data.set("iamRole", om.valueToTree(this.getIamRole()));
            }
            if (this.getKeyPrefix() != null) {
                data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getS3Bucket() != null) {
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.FlowLogDestinationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowLogDestinationConfig.Jsii$Proxy that = (FlowLogDestinationConfig.Jsii$Proxy) o;

            if (!logDestinationType.equals(that.logDestinationType)) return false;
            if (this.iamRole != null ? !this.iamRole.equals(that.iamRole) : that.iamRole != null) return false;
            if (this.keyPrefix != null ? !this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            return this.s3Bucket != null ? this.s3Bucket.equals(that.s3Bucket) : that.s3Bucket == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDestinationType.hashCode();
            result = 31 * result + (this.iamRole != null ? this.iamRole.hashCode() : 0);
            result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.s3Bucket != null ? this.s3Bucket.hashCode() : 0);
            return result;
        }
    }
}
