package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnTransitGatewayVpcAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object options;
 * CfnTransitGatewayVpcAttachmentProps cfnTransitGatewayVpcAttachmentProps = CfnTransitGatewayVpcAttachmentProps.builder()
 *         .subnetIds(List.of("subnetIds"))
 *         .transitGatewayId("transitGatewayId")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .addSubnetIds(List.of("addSubnetIds"))
 *         .options(options)
 *         .removeSubnetIds(List.of("removeSubnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:24.846Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTransitGatewayVpcAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayVpcAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayVpcAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IDs of the subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayId();

    /**
     * The ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * The IDs of one or more subnets to add.
     * <p>
     * You can specify at most one subnet per Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddSubnetIds() {
        return null;
    }

    /**
     * The VPC attachment options in JSON or YAML.
     * <p>
     * <ul>
     * <li>DnsSupport (enable | disable)</li>
     * <li>Ipv6Support (enable| disable)</li>
     * <li>ApplianceModeSupport (enable | disable)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * The IDs of one or more subnets to remove.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRemoveSubnetIds() {
        return null;
    }

    /**
     * The tags for the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayVpcAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayVpcAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayVpcAttachmentProps> {
        java.util.List<java.lang.String> subnetIds;
        java.lang.String transitGatewayId;
        java.lang.String vpcId;
        java.util.List<java.lang.String> addSubnetIds;
        java.lang.Object options;
        java.util.List<java.lang.String> removeSubnetIds;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getSubnetIds}
         * @param subnetIds The IDs of the subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getTransitGatewayId}
         * @param transitGatewayId The ID of the transit gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getVpcId}
         * @param vpcId The ID of the VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getAddSubnetIds}
         * @param addSubnetIds The IDs of one or more subnets to add.
         *                     You can specify at most one subnet per Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addSubnetIds(java.util.List<java.lang.String> addSubnetIds) {
            this.addSubnetIds = addSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getOptions}
         * @param options The VPC attachment options in JSON or YAML.
         *                <ul>
         *                <li>DnsSupport (enable | disable)</li>
         *                <li>Ipv6Support (enable| disable)</li>
         *                <li>ApplianceModeSupport (enable | disable)</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.lang.Object options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getRemoveSubnetIds}
         * @param removeSubnetIds The IDs of one or more subnets to remove.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSubnetIds(java.util.List<java.lang.String> removeSubnetIds) {
            this.removeSubnetIds = removeSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayVpcAttachmentProps#getTags}
         * @param tags The tags for the VPC attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayVpcAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayVpcAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayVpcAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayVpcAttachmentProps {
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpcId;
        private final java.util.List<java.lang.String> addSubnetIds;
        private final java.lang.Object options;
        private final java.util.List<java.lang.String> removeSubnetIds;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addSubnetIds = software.amazon.jsii.Kernel.get(this, "addSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.removeSubnetIds = software.amazon.jsii.Kernel.get(this, "removeSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.transitGatewayId = java.util.Objects.requireNonNull(builder.transitGatewayId, "transitGatewayId is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.addSubnetIds = builder.addSubnetIds;
            this.options = builder.options;
            this.removeSubnetIds = builder.removeSubnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.util.List<java.lang.String> getAddSubnetIds() {
            return this.addSubnetIds;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.util.List<java.lang.String> getRemoveSubnetIds() {
            return this.removeSubnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAddSubnetIds() != null) {
                data.set("addSubnetIds", om.valueToTree(this.getAddSubnetIds()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getRemoveSubnetIds() != null) {
                data.set("removeSubnetIds", om.valueToTree(this.getRemoveSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTransitGatewayVpcAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayVpcAttachmentProps.Jsii$Proxy that = (CfnTransitGatewayVpcAttachmentProps.Jsii$Proxy) o;

            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!transitGatewayId.equals(that.transitGatewayId)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.addSubnetIds != null ? !this.addSubnetIds.equals(that.addSubnetIds) : that.addSubnetIds != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.removeSubnetIds != null ? !this.removeSubnetIds.equals(that.removeSubnetIds) : that.removeSubnetIds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.subnetIds.hashCode();
            result = 31 * result + (this.transitGatewayId.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.addSubnetIds != null ? this.addSubnetIds.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.removeSubnetIds != null ? this.removeSubnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
