package software.amazon.awscdk.services.ec2;

/**
 * Type of router used in route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "VPC")
 *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .name("Public")
 *                 .build(), SubnetConfiguration.builder()
 *                 .subnetType(SubnetType.ISOLATED)
 *                 .name("Isolated")
 *                 .build()))
 *         .build();
 * ((Subnet)vpc.isolatedSubnets[0]).addRoute("StaticRoute", AddRouteOptions.builder()
 *         .routerId(vpc.getInternetGatewayId())
 *         .routerType(RouterType.GATEWAY)
 *         .destinationCidrBlock("8.8.8.8/32")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:25.136Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.RouterType")
public enum RouterType {
    /**
     * Egress-only Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EGRESS_ONLY_INTERNET_GATEWAY,
    /**
     * Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GATEWAY,
    /**
     * Instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSTANCE,
    /**
     * NAT Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAT_GATEWAY,
    /**
     * Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NETWORK_INTERFACE,
    /**
     * VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VPC_PEERING_CONNECTION,
}
