package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::CapacityReservation`.
 * <p>
 * Creates a new Capacity Reservation with the specified attributes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations</a> in the <em>Amazon EC2 User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservation cfnCapacityReservation = CfnCapacityReservation.Builder.create(this, "MyCfnCapacityReservation")
 *         .availabilityZone("availabilityZone")
 *         .instanceCount(123)
 *         .instancePlatform("instancePlatform")
 *         .instanceType("instanceType")
 *         // the properties below are optional
 *         .ebsOptimized(false)
 *         .endDate("endDate")
 *         .endDateType("endDateType")
 *         .ephemeralStorage(false)
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .outPostArn("outPostArn")
 *         .placementGroupArn("placementGroupArn")
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-04T20:14:09.275Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservation")
public class CfnCapacityReservation extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCapacityReservation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityReservation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnCapacityReservation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::CapacityReservation`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityReservation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnCapacityReservationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Availability Zone in which the capacity is reserved.
     * <p>
     * For example: <code>us-east-1a</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the remaining capacity, which indicates the number of instances that can be launched in the Capacity Reservation.
     * <p>
     * For example: <code>9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAvailableInstanceCount() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Returns the type of instance for which the capacity is reserved.
     * <p>
     * For example: <code>m4.large</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "attrInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the tenancy of the Capacity Reservation.
     * <p>
     * For example: <code>dedicated</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTenancy() {
        return software.amazon.jsii.Kernel.get(this, "attrTenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the total number of instances for which the Capacity Reservation reserves capacity.
     * <p>
     * For example: <code>15</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrTotalInstanceCount() {
        return software.amazon.jsii.Kernel.get(this, "attrTotalInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", java.util.Objects.requireNonNull(value, "availabilityZone is required"));
    }

    /**
     * The number of instances for which to reserve capacity.
     * <p>
     * Valid range: 1 - 1000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount() {
        return software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of instances for which to reserve capacity.
     * <p>
     * Valid range: 1 - 1000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceCount(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "instanceCount", java.util.Objects.requireNonNull(value, "instanceCount is required"));
    }

    /**
     * The type of operating system for which to reserve capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePlatform() {
        return software.amazon.jsii.Kernel.get(this, "instancePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of operating system for which to reserve capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstancePlatform(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instancePlatform", java.util.Objects.requireNonNull(value, "instancePlatform is required"));
    }

    /**
     * The instance type for which to reserve capacity.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance type for which to reserve capacity.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
    }

    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptimized", value);
    }

    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptimized", value);
    }

    /**
     * The date and time at which the Capacity Reservation expires.
     * <p>
     * When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.
     * <p>
     * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code> . Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code> .
     * <p>
     * If the <code>EndDateType</code> is <code>limited</code> , the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time at which the Capacity Reservation expires.
     * <p>
     * When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.
     * <p>
     * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code> . Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code> .
     * <p>
     * If the <code>EndDateType</code> is <code>limited</code> , the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndDate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endDate", value);
    }

    /**
     * Indicates the way in which the Capacity Reservation ends.
     * <p>
     * A Capacity Reservation can have one of the following end types:
     * <p>
     * <ul>
     * <li><code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code> .</li>
     * <li><code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndDateType() {
        return software.amazon.jsii.Kernel.get(this, "endDateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the way in which the Capacity Reservation ends.
     * <p>
     * A Capacity Reservation can have one of the following end types:
     * <p>
     * <ul>
     * <li><code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code> .</li>
     * <li><code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndDateType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endDateType", value);
    }

    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:.
     * <p>
     * <ul>
     * <li><code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</li>
     * <li><code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</li>
     * </ul>
     * <p>
     * Default: <code>open</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:.
     * <p>
     * <ul>
     * <li><code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</li>
     * <li><code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</li>
     * </ul>
     * <p>
     * Default: <code>open</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMatchCriteria(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceMatchCriteria", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOutPostArn() {
        return software.amazon.jsii.Kernel.get(this, "outPostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutPostArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outPostArn", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html">Capacity Reservations for cluster placement groups</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "placementGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html">Capacity Reservations for cluster placement groups</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "placementGroupArn", value);
    }

    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:.
     * <p>
     * <ul>
     * <li><code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts .</li>
     * <li><code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:.
     * <p>
     * <ul>
     * <li><code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts .</li>
     * <li><code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTenancy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tenancy", value);
    }
    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservation.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag.
         * <p>
         * Specify <code>capacity-reservation</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags to apply to the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag.
             *                     Specify <code>capacity-reservation</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservation.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnCapacityReservation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnCapacityReservation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnCapacityReservationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnCapacityReservationProps.Builder();
        }

        /**
         * The Availability Zone in which to create the Capacity Reservation.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone in which to create the Capacity Reservation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The number of instances for which to reserve capacity.
         * <p>
         * Valid range: 1 - 1000
         * <p>
         * @return {@code this}
         * @param instanceCount The number of instances for which to reserve capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCount(final java.lang.Number instanceCount) {
            this.props.instanceCount(instanceCount);
            return this;
        }

        /**
         * The type of operating system for which to reserve capacity.
         * <p>
         * @return {@code this}
         * @param instancePlatform The type of operating system for which to reserve capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instancePlatform(final java.lang.String instancePlatform) {
            this.props.instancePlatform(instancePlatform);
            return this;
        }

        /**
         * The instance type for which to reserve capacity.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param instanceType The instance type for which to reserve capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the Capacity Reservation supports EBS-optimized instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances.
         * <p>
         * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the Capacity Reservation supports EBS-optimized instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * The date and time at which the Capacity Reservation expires.
         * <p>
         * When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.
         * <p>
         * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code> . Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code> .
         * <p>
         * If the <code>EndDateType</code> is <code>limited</code> , the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         * <p>
         * @return {@code this}
         * @param endDate The date and time at which the Capacity Reservation expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(final java.lang.String endDate) {
            this.props.endDate(endDate);
            return this;
        }

        /**
         * Indicates the way in which the Capacity Reservation ends.
         * <p>
         * A Capacity Reservation can have one of the following end types:
         * <p>
         * <ul>
         * <li><code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code> .</li>
         * <li><code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param endDateType Indicates the way in which the Capacity Reservation ends. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDateType(final java.lang.String endDateType) {
            this.props.endDateType(endDateType);
            return this;
        }

        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorage Indicates whether the Capacity Reservation supports instances with temporary, block-level storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final java.lang.Boolean ephemeralStorage) {
            this.props.ephemeralStorage(ephemeralStorage);
            return this;
        }
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorage Indicates whether the Capacity Reservation supports instances with temporary, block-level storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final software.amazon.awscdk.core.IResolvable ephemeralStorage) {
            this.props.ephemeralStorage(ephemeralStorage);
            return this;
        }

        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:.
         * <p>
         * <ul>
         * <li><code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</li>
         * <li><code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</li>
         * </ul>
         * <p>
         * Default: <code>open</code>
         * <p>
         * @return {@code this}
         * @param instanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation accepts. The options include:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(final java.lang.String instanceMatchCriteria) {
            this.props.instanceMatchCriteria(instanceMatchCriteria);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         * <p>
         * @return {@code this}
         * @param outPostArn The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outPostArn(final java.lang.String outPostArn) {
            this.props.outPostArn(outPostArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html">Capacity Reservations for cluster placement groups</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param placementGroupArn The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupArn(final java.lang.String placementGroupArn) {
            this.props.placementGroupArn(placementGroupArn);
            return this;
        }

        /**
         * The tags to apply to the Capacity Reservation during launch.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the Capacity Reservation during launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The tags to apply to the Capacity Reservation during launch.
         * <p>
         * @return {@code this}
         * @param tagSpecifications The tags to apply to the Capacity Reservation during launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:.
         * <p>
         * <ul>
         * <li><code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts .</li>
         * <li><code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tenancy Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(final java.lang.String tenancy) {
            this.props.tenancy(tenancy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnCapacityReservation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnCapacityReservation build() {
            return new software.amazon.awscdk.services.ec2.CfnCapacityReservation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
