package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnVPNConnection`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPNConnectionProps cfnVPNConnectionProps = CfnVPNConnectionProps.builder()
 *         .customerGatewayId("customerGatewayId")
 *         .type("type")
 *         // the properties below are optional
 *         .staticRoutesOnly(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayId("transitGatewayId")
 *         .vpnGatewayId("vpnGatewayId")
 *         .vpnTunnelOptionsSpecifications(List.of(VpnTunnelOptionsSpecificationProperty.builder()
 *                 .preSharedKey("preSharedKey")
 *                 .tunnelInsideCidr("tunnelInsideCidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-11T19:24:13.889Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPNConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPNConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId();

    /**
     * The type of VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Indicates whether the VPN connection uses static routes only.
     * <p>
     * Static routes must be used for devices that don't support BGP.
     * <p>
     * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return null;
    }

    /**
     * Any tags assigned to the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return null;
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPNConnectionProps> {
        java.lang.String customerGatewayId;
        java.lang.String type;
        java.lang.Object staticRoutesOnly;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String transitGatewayId;
        java.lang.String vpnGatewayId;
        java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getCustomerGatewayId}
         * @param customerGatewayId The ID of the customer gateway at your end of the VPN connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayId(java.lang.String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getType}
         * @param type The type of VPN connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only.
         *                         Static routes must be used for devices that don't support BGP.
         *                         <p>
         *                         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(java.lang.Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only.
         *                         Static routes must be used for devices that don't support BGP.
         *                         <p>
         *                         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(software.amazon.awscdk.core.IResolvable staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTags}
         * @param tags Any tags assigned to the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTransitGatewayId}
         * @param transitGatewayId The ID of the transit gateway associated with the VPN connection.
         *                         You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnGatewayId}
         * @param vpnGatewayId The ID of the virtual private gateway at the AWS side of the VPN connection.
         *                     You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(software.amazon.awscdk.core.IResolvable vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(java.util.List<? extends java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPNConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPNConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPNConnectionProps {
        private final java.lang.String customerGatewayId;
        private final java.lang.String type;
        private final java.lang.Object staticRoutesOnly;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpnGatewayId;
        private final java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerGatewayId = software.amazon.jsii.Kernel.get(this, "customerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.staticRoutesOnly = software.amazon.jsii.Kernel.get(this, "staticRoutesOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnGatewayId = software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnTunnelOptionsSpecifications = software.amazon.jsii.Kernel.get(this, "vpnTunnelOptionsSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerGatewayId = java.util.Objects.requireNonNull(builder.customerGatewayId, "customerGatewayId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.staticRoutesOnly = builder.staticRoutesOnly;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.transitGatewayId = builder.transitGatewayId;
            this.vpnGatewayId = builder.vpnGatewayId;
            this.vpnTunnelOptionsSpecifications = builder.vpnTunnelOptionsSpecifications;
        }

        @Override
        public final java.lang.String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final java.lang.Object getVpnTunnelOptionsSpecifications() {
            return this.vpnTunnelOptionsSpecifications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customerGatewayId", om.valueToTree(this.getCustomerGatewayId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getStaticRoutesOnly() != null) {
                data.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitGatewayId() != null) {
                data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }
            if (this.getVpnTunnelOptionsSpecifications() != null) {
                data.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPNConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPNConnectionProps.Jsii$Proxy that = (CfnVPNConnectionProps.Jsii$Proxy) o;

            if (!customerGatewayId.equals(that.customerGatewayId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.staticRoutesOnly != null ? !this.staticRoutesOnly.equals(that.staticRoutesOnly) : that.staticRoutesOnly != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            if (this.vpnGatewayId != null ? !this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId != null) return false;
            return this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.equals(that.vpnTunnelOptionsSpecifications) : that.vpnTunnelOptionsSpecifications == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customerGatewayId.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.staticRoutesOnly != null ? this.staticRoutesOnly.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.hashCode() : 0);
            return result;
        }
    }
}
