package software.amazon.awscdk.services.ec2;

/**
 * Target for a client VPN route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ClientVpnEndpoint endpoint = vpc.addClientVpnEndpoint("Endpoint", ClientVpnEndpointOptions.builder()
 *         .cidr("10.100.0.0/16")
 *         .serverCertificateArn("arn:aws:acm:us-east-1:123456789012:certificate/server-certificate-id")
 *         .userBasedAuthentication(ClientVpnUserBasedAuthentication.federated(samlProvider))
 *         .build());
 * // Client-to-client access
 * endpoint.addRoute("Route", ClientVpnRouteOptions.builder()
 *         .cidr("10.100.0.0/16")
 *         .target(ClientVpnRouteTarget.local())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-11T19:24:13.919Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnRouteTarget")
public abstract class ClientVpnRouteTarget extends software.amazon.jsii.JsiiObject {

    protected ClientVpnRouteTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClientVpnRouteTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ClientVpnRouteTarget() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Local network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnRouteTarget local() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class, "local", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class));
    }

    /**
     * Subnet.
     * <p>
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     * <p>
     * @param subnet This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ClientVpnRouteTarget subnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet subnet) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class, "subnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnRouteTarget.class), new Object[] { java.util.Objects.requireNonNull(subnet, "subnet is required") });
    }

    /**
     * The subnet ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.ClientVpnRouteTarget {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The subnet ID.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getSubnetId() {
            return software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
