package software.amazon.awscdk.services.ec2;

/**
 * Either an IPv4 or an IPv6 CIDR.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AclCidr aclCidr = AclCidr.anyIpv4();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:32.181Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AclCidr")
public abstract class AclCidr extends software.amazon.jsii.JsiiObject {

    protected AclCidr(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AclCidr(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AclCidr() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The CIDR containing all IPv4 addresses (i.e., 0.0.0.0/0).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidr anyIpv4() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclCidr.class, "anyIpv4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclCidr.class));
    }

    /**
     * The CIDR containing all IPv6 addresses (i.e., ::/0).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidr anyIpv6() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclCidr.class, "anyIpv6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclCidr.class));
    }

    /**
     * An IP network range in CIDR notation (for example, 172.16.0.0/24).
     * <p>
     * @param ipv4Cidr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidr ipv4(final @org.jetbrains.annotations.NotNull java.lang.String ipv4Cidr) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclCidr.class, "ipv4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclCidr.class), new Object[] { java.util.Objects.requireNonNull(ipv4Cidr, "ipv4Cidr is required") });
    }

    /**
     * An IPv6 network range in CIDR notation (for example, 2001:db8::/48).
     * <p>
     * @param ipv6Cidr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidr ipv6(final @org.jetbrains.annotations.NotNull java.lang.String ipv6Cidr) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.AclCidr.class, "ipv6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclCidr.class), new Object[] { java.util.Objects.requireNonNull(ipv6Cidr, "ipv6Cidr is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidrConfig toCidrConfig();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.AclCidr {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AclCidrConfig toCidrConfig() {
            return software.amazon.jsii.Kernel.call(this, "toCidrConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AclCidrConfig.class));
        }
    }
}
