package software.amazon.awscdk.services.ec2;

/**
 * Select the image based on a given SSM parameter.
 * <p>
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 * <p>
 * The AMI ID is selected using the values published to the SSM parameter store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * GenericSSMParameterImage genericSSMParameterImage = new GenericSSMParameterImage("parameterName", OperatingSystemType.LINUX, userData);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:32.829Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GenericSSMParameterImage")
public class GenericSSMParameterImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected GenericSSMParameterImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericSSMParameterImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param parameterName This parameter is required.
     * @param os This parameter is required.
     * @param userData
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericSSMParameterImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData userData) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required"), userData });
    }

    /**
     * @param parameterName This parameter is required.
     * @param os This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericSSMParameterImage(final @org.jetbrains.annotations.NotNull java.lang.String parameterName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType os) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required"), java.util.Objects.requireNonNull(os, "os is required") });
    }

    /**
     * Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Name of the SSM parameter we're looking up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterName() {
        return software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
