package software.amazon.awscdk.services.ec2;

/**
 * Supported EBS volume types for blockDevices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(ElasticsearchVersion.V7_4)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(100)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-20T22:19:59.392Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.EbsDeviceVolumeType")
public enum EbsDeviceVolumeType {
    /**
     * Magnetic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Provisioned IOPS SSD - IO1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO1,
    /**
     * Provisioned IOPS SSD - IO2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO2,
    /**
     * General Purpose SSD - GP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP2,
    /**
     * General Purpose SSD - GP3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP3,
    /**
     * Throughput Optimized HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ST1,
    /**
     * Cold HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SC1,
}
