package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAccessScope`.
 * <p>
 * Describes a Network Access Scope. A Network Access Scope defines outbound (egress) and inbound (ingress) traffic patterns, including sources, destinations, paths, and traffic types.
 * <p>
 * Network Access Analyzer identifies unintended network access to your resources on AWS . When you start an analysis on a Network Access Scope, Network Access Analyzer produces findings. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Network Access Analyzer User Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInsightsAccessScope cfnNetworkInsightsAccessScope = CfnNetworkInsightsAccessScope.Builder.create(this, "MyCfnNetworkInsightsAccessScope")
 *         .excludePaths(List.of(AccessScopePathRequestProperty.builder()
 *                 .destination(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .source(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .throughResources(List.of(ThroughResourcesStatementRequestProperty.builder()
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .matchPaths(List.of(AccessScopePathRequestProperty.builder()
 *                 .destination(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .source(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .throughResources(List.of(ThroughResourcesStatementRequestProperty.builder()
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:27:59.588Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope")
public class CfnNetworkInsightsAccessScope extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnNetworkInsightsAccessScope(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNetworkInsightsAccessScope(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::NetworkInsightsAccessScope`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnNetworkInsightsAccessScope(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScopeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::NetworkInsightsAccessScope`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnNetworkInsightsAccessScope(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The creation date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the Network Access Scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkInsightsAccessScopeArn() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkInsightsAccessScopeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Network Access Scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkInsightsAccessScopeId() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkInsightsAccessScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last updated date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedDate() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The paths to exclude.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludePaths() {
        return software.amazon.jsii.Kernel.get(this, "excludePaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The paths to exclude.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludePaths(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludePaths", value);
    }

    /**
     * The paths to exclude.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludePaths(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "excludePaths", value);
    }

    /**
     * The paths to match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMatchPaths() {
        return software.amazon.jsii.Kernel.get(this, "matchPaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The paths to match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatchPaths(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "matchPaths", value);
    }

    /**
     * The paths to match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatchPaths(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "matchPaths", value);
    }
    /**
     * Describes a path.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AccessScopePathRequestProperty accessScopePathRequestProperty = AccessScopePathRequestProperty.builder()
     *         .destination(PathStatementRequestProperty.builder()
     *                 .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
     *                         .destinationAddresses(List.of("destinationAddresses"))
     *                         .destinationPorts(List.of("destinationPorts"))
     *                         .destinationPrefixLists(List.of("destinationPrefixLists"))
     *                         .protocols(List.of("protocols"))
     *                         .sourceAddresses(List.of("sourceAddresses"))
     *                         .sourcePorts(List.of("sourcePorts"))
     *                         .sourcePrefixLists(List.of("sourcePrefixLists"))
     *                         .build())
     *                 .resourceStatement(ResourceStatementRequestProperty.builder()
     *                         .resources(List.of("resources"))
     *                         .resourceTypes(List.of("resourceTypes"))
     *                         .build())
     *                 .build())
     *         .source(PathStatementRequestProperty.builder()
     *                 .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
     *                         .destinationAddresses(List.of("destinationAddresses"))
     *                         .destinationPorts(List.of("destinationPorts"))
     *                         .destinationPrefixLists(List.of("destinationPrefixLists"))
     *                         .protocols(List.of("protocols"))
     *                         .sourceAddresses(List.of("sourceAddresses"))
     *                         .sourcePorts(List.of("sourcePorts"))
     *                         .sourcePrefixLists(List.of("sourcePrefixLists"))
     *                         .build())
     *                 .resourceStatement(ResourceStatementRequestProperty.builder()
     *                         .resources(List.of("resources"))
     *                         .resourceTypes(List.of("resourceTypes"))
     *                         .build())
     *                 .build())
     *         .throughResources(List.of(ThroughResourcesStatementRequestProperty.builder()
     *                 .resourceStatement(ResourceStatementRequestProperty.builder()
     *                         .resources(List.of("resources"))
     *                         .resourceTypes(List.of("resourceTypes"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.AccessScopePathRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessScopePathRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessScopePathRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * The source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * The through resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThroughResources() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessScopePathRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessScopePathRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessScopePathRequestProperty> {
            java.lang.Object destination;
            java.lang.Object source;
            java.lang.Object throughResources;

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getDestination}
             * @param destination The destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.core.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getDestination}
             * @param destination The destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.PathStatementRequestProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getSource}
             * @param source The source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.core.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getSource}
             * @param source The source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.PathStatementRequestProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getThroughResources}
             * @param throughResources The through resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughResources(software.amazon.awscdk.core.IResolvable throughResources) {
                this.throughResources = throughResources;
                return this;
            }

            /**
             * Sets the value of {@link AccessScopePathRequestProperty#getThroughResources}
             * @param throughResources The through resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughResources(java.util.List<? extends java.lang.Object> throughResources) {
                this.throughResources = throughResources;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessScopePathRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessScopePathRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessScopePathRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessScopePathRequestProperty {
            private final java.lang.Object destination;
            private final java.lang.Object source;
            private final java.lang.Object throughResources;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.throughResources = software.amazon.jsii.Kernel.get(this, "throughResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = builder.destination;
                this.source = builder.source;
                this.throughResources = builder.throughResources;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getThroughResources() {
                return this.throughResources;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }
                if (this.getThroughResources() != null) {
                    data.set("throughResources", om.valueToTree(this.getThroughResources()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.AccessScopePathRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessScopePathRequestProperty.Jsii$Proxy that = (AccessScopePathRequestProperty.Jsii$Proxy) o;

                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
                return this.throughResources != null ? this.throughResources.equals(that.throughResources) : that.throughResources == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination != null ? this.destination.hashCode() : 0;
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                result = 31 * result + (this.throughResources != null ? this.throughResources.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a packet header statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PacketHeaderStatementRequestProperty packetHeaderStatementRequestProperty = PacketHeaderStatementRequestProperty.builder()
     *         .destinationAddresses(List.of("destinationAddresses"))
     *         .destinationPorts(List.of("destinationPorts"))
     *         .destinationPrefixLists(List.of("destinationPrefixLists"))
     *         .protocols(List.of("protocols"))
     *         .sourceAddresses(List.of("sourceAddresses"))
     *         .sourcePorts(List.of("sourcePorts"))
     *         .sourcePrefixLists(List.of("sourcePrefixLists"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.PacketHeaderStatementRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(PacketHeaderStatementRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PacketHeaderStatementRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationAddresses() {
            return null;
        }

        /**
         * The destination ports.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationPorts() {
            return null;
        }

        /**
         * The destination prefix lists.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDestinationPrefixLists() {
            return null;
        }

        /**
         * The protocols.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
            return null;
        }

        /**
         * The source addresses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceAddresses() {
            return null;
        }

        /**
         * The source ports.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourcePorts() {
            return null;
        }

        /**
         * The source prefix lists.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourcePrefixLists() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PacketHeaderStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PacketHeaderStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PacketHeaderStatementRequestProperty> {
            java.util.List<java.lang.String> destinationAddresses;
            java.util.List<java.lang.String> destinationPorts;
            java.util.List<java.lang.String> destinationPrefixLists;
            java.util.List<java.lang.String> protocols;
            java.util.List<java.lang.String> sourceAddresses;
            java.util.List<java.lang.String> sourcePorts;
            java.util.List<java.lang.String> sourcePrefixLists;

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getDestinationAddresses}
             * @param destinationAddresses The destination addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationAddresses(java.util.List<java.lang.String> destinationAddresses) {
                this.destinationAddresses = destinationAddresses;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getDestinationPorts}
             * @param destinationPorts The destination ports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPorts(java.util.List<java.lang.String> destinationPorts) {
                this.destinationPorts = destinationPorts;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getDestinationPrefixLists}
             * @param destinationPrefixLists The destination prefix lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPrefixLists(java.util.List<java.lang.String> destinationPrefixLists) {
                this.destinationPrefixLists = destinationPrefixLists;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getProtocols}
             * @param protocols The protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocols(java.util.List<java.lang.String> protocols) {
                this.protocols = protocols;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getSourceAddresses}
             * @param sourceAddresses The source addresses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAddresses(java.util.List<java.lang.String> sourceAddresses) {
                this.sourceAddresses = sourceAddresses;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getSourcePorts}
             * @param sourcePorts The source ports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePorts(java.util.List<java.lang.String> sourcePorts) {
                this.sourcePorts = sourcePorts;
                return this;
            }

            /**
             * Sets the value of {@link PacketHeaderStatementRequestProperty#getSourcePrefixLists}
             * @param sourcePrefixLists The source prefix lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePrefixLists(java.util.List<java.lang.String> sourcePrefixLists) {
                this.sourcePrefixLists = sourcePrefixLists;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PacketHeaderStatementRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PacketHeaderStatementRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PacketHeaderStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PacketHeaderStatementRequestProperty {
            private final java.util.List<java.lang.String> destinationAddresses;
            private final java.util.List<java.lang.String> destinationPorts;
            private final java.util.List<java.lang.String> destinationPrefixLists;
            private final java.util.List<java.lang.String> protocols;
            private final java.util.List<java.lang.String> sourceAddresses;
            private final java.util.List<java.lang.String> sourcePorts;
            private final java.util.List<java.lang.String> sourcePrefixLists;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationAddresses = software.amazon.jsii.Kernel.get(this, "destinationAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.destinationPorts = software.amazon.jsii.Kernel.get(this, "destinationPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.destinationPrefixLists = software.amazon.jsii.Kernel.get(this, "destinationPrefixLists", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceAddresses = software.amazon.jsii.Kernel.get(this, "sourceAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourcePorts = software.amazon.jsii.Kernel.get(this, "sourcePorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourcePrefixLists = software.amazon.jsii.Kernel.get(this, "sourcePrefixLists", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationAddresses = builder.destinationAddresses;
                this.destinationPorts = builder.destinationPorts;
                this.destinationPrefixLists = builder.destinationPrefixLists;
                this.protocols = builder.protocols;
                this.sourceAddresses = builder.sourceAddresses;
                this.sourcePorts = builder.sourcePorts;
                this.sourcePrefixLists = builder.sourcePrefixLists;
            }

            @Override
            public final java.util.List<java.lang.String> getDestinationAddresses() {
                return this.destinationAddresses;
            }

            @Override
            public final java.util.List<java.lang.String> getDestinationPorts() {
                return this.destinationPorts;
            }

            @Override
            public final java.util.List<java.lang.String> getDestinationPrefixLists() {
                return this.destinationPrefixLists;
            }

            @Override
            public final java.util.List<java.lang.String> getProtocols() {
                return this.protocols;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceAddresses() {
                return this.sourceAddresses;
            }

            @Override
            public final java.util.List<java.lang.String> getSourcePorts() {
                return this.sourcePorts;
            }

            @Override
            public final java.util.List<java.lang.String> getSourcePrefixLists() {
                return this.sourcePrefixLists;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationAddresses() != null) {
                    data.set("destinationAddresses", om.valueToTree(this.getDestinationAddresses()));
                }
                if (this.getDestinationPorts() != null) {
                    data.set("destinationPorts", om.valueToTree(this.getDestinationPorts()));
                }
                if (this.getDestinationPrefixLists() != null) {
                    data.set("destinationPrefixLists", om.valueToTree(this.getDestinationPrefixLists()));
                }
                if (this.getProtocols() != null) {
                    data.set("protocols", om.valueToTree(this.getProtocols()));
                }
                if (this.getSourceAddresses() != null) {
                    data.set("sourceAddresses", om.valueToTree(this.getSourceAddresses()));
                }
                if (this.getSourcePorts() != null) {
                    data.set("sourcePorts", om.valueToTree(this.getSourcePorts()));
                }
                if (this.getSourcePrefixLists() != null) {
                    data.set("sourcePrefixLists", om.valueToTree(this.getSourcePrefixLists()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.PacketHeaderStatementRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PacketHeaderStatementRequestProperty.Jsii$Proxy that = (PacketHeaderStatementRequestProperty.Jsii$Proxy) o;

                if (this.destinationAddresses != null ? !this.destinationAddresses.equals(that.destinationAddresses) : that.destinationAddresses != null) return false;
                if (this.destinationPorts != null ? !this.destinationPorts.equals(that.destinationPorts) : that.destinationPorts != null) return false;
                if (this.destinationPrefixLists != null ? !this.destinationPrefixLists.equals(that.destinationPrefixLists) : that.destinationPrefixLists != null) return false;
                if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
                if (this.sourceAddresses != null ? !this.sourceAddresses.equals(that.sourceAddresses) : that.sourceAddresses != null) return false;
                if (this.sourcePorts != null ? !this.sourcePorts.equals(that.sourcePorts) : that.sourcePorts != null) return false;
                return this.sourcePrefixLists != null ? this.sourcePrefixLists.equals(that.sourcePrefixLists) : that.sourcePrefixLists == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationAddresses != null ? this.destinationAddresses.hashCode() : 0;
                result = 31 * result + (this.destinationPorts != null ? this.destinationPorts.hashCode() : 0);
                result = 31 * result + (this.destinationPrefixLists != null ? this.destinationPrefixLists.hashCode() : 0);
                result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
                result = 31 * result + (this.sourceAddresses != null ? this.sourceAddresses.hashCode() : 0);
                result = 31 * result + (this.sourcePorts != null ? this.sourcePorts.hashCode() : 0);
                result = 31 * result + (this.sourcePrefixLists != null ? this.sourcePrefixLists.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a path statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PathStatementRequestProperty pathStatementRequestProperty = PathStatementRequestProperty.builder()
     *         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
     *                 .destinationAddresses(List.of("destinationAddresses"))
     *                 .destinationPorts(List.of("destinationPorts"))
     *                 .destinationPrefixLists(List.of("destinationPrefixLists"))
     *                 .protocols(List.of("protocols"))
     *                 .sourceAddresses(List.of("sourceAddresses"))
     *                 .sourcePorts(List.of("sourcePorts"))
     *                 .sourcePrefixLists(List.of("sourcePrefixLists"))
     *                 .build())
     *         .resourceStatement(ResourceStatementRequestProperty.builder()
     *                 .resources(List.of("resources"))
     *                 .resourceTypes(List.of("resourceTypes"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.PathStatementRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(PathStatementRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathStatementRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The packet header statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPacketHeaderStatement() {
            return null;
        }

        /**
         * The resource statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceStatement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PathStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PathStatementRequestProperty> {
            java.lang.Object packetHeaderStatement;
            java.lang.Object resourceStatement;

            /**
             * Sets the value of {@link PathStatementRequestProperty#getPacketHeaderStatement}
             * @param packetHeaderStatement The packet header statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packetHeaderStatement(software.amazon.awscdk.core.IResolvable packetHeaderStatement) {
                this.packetHeaderStatement = packetHeaderStatement;
                return this;
            }

            /**
             * Sets the value of {@link PathStatementRequestProperty#getPacketHeaderStatement}
             * @param packetHeaderStatement The packet header statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packetHeaderStatement(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.PacketHeaderStatementRequestProperty packetHeaderStatement) {
                this.packetHeaderStatement = packetHeaderStatement;
                return this;
            }

            /**
             * Sets the value of {@link PathStatementRequestProperty#getResourceStatement}
             * @param resourceStatement The resource statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceStatement(software.amazon.awscdk.core.IResolvable resourceStatement) {
                this.resourceStatement = resourceStatement;
                return this;
            }

            /**
             * Sets the value of {@link PathStatementRequestProperty#getResourceStatement}
             * @param resourceStatement The resource statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceStatement(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.ResourceStatementRequestProperty resourceStatement) {
                this.resourceStatement = resourceStatement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathStatementRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PathStatementRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PathStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathStatementRequestProperty {
            private final java.lang.Object packetHeaderStatement;
            private final java.lang.Object resourceStatement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.packetHeaderStatement = software.amazon.jsii.Kernel.get(this, "packetHeaderStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceStatement = software.amazon.jsii.Kernel.get(this, "resourceStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.packetHeaderStatement = builder.packetHeaderStatement;
                this.resourceStatement = builder.resourceStatement;
            }

            @Override
            public final java.lang.Object getPacketHeaderStatement() {
                return this.packetHeaderStatement;
            }

            @Override
            public final java.lang.Object getResourceStatement() {
                return this.resourceStatement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPacketHeaderStatement() != null) {
                    data.set("packetHeaderStatement", om.valueToTree(this.getPacketHeaderStatement()));
                }
                if (this.getResourceStatement() != null) {
                    data.set("resourceStatement", om.valueToTree(this.getResourceStatement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.PathStatementRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathStatementRequestProperty.Jsii$Proxy that = (PathStatementRequestProperty.Jsii$Proxy) o;

                if (this.packetHeaderStatement != null ? !this.packetHeaderStatement.equals(that.packetHeaderStatement) : that.packetHeaderStatement != null) return false;
                return this.resourceStatement != null ? this.resourceStatement.equals(that.resourceStatement) : that.resourceStatement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.packetHeaderStatement != null ? this.packetHeaderStatement.hashCode() : 0;
                result = 31 * result + (this.resourceStatement != null ? this.resourceStatement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a resource statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ResourceStatementRequestProperty resourceStatementRequestProperty = ResourceStatementRequestProperty.builder()
     *         .resources(List.of("resources"))
     *         .resourceTypes(List.of("resourceTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.ResourceStatementRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceStatementRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceStatementRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
            return null;
        }

        /**
         * The resource types.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceStatementRequestProperty> {
            java.util.List<java.lang.String> resources;
            java.util.List<java.lang.String> resourceTypes;

            /**
             * Sets the value of {@link ResourceStatementRequestProperty#getResources}
             * @param resources The resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(java.util.List<java.lang.String> resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link ResourceStatementRequestProperty#getResourceTypes}
             * @param resourceTypes The resource types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceStatementRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceStatementRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceStatementRequestProperty {
            private final java.util.List<java.lang.String> resources;
            private final java.util.List<java.lang.String> resourceTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resources = builder.resources;
                this.resourceTypes = builder.resourceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getResources() {
                return this.resources;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResources() != null) {
                    data.set("resources", om.valueToTree(this.getResources()));
                }
                if (this.getResourceTypes() != null) {
                    data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.ResourceStatementRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceStatementRequestProperty.Jsii$Proxy that = (ResourceStatementRequestProperty.Jsii$Proxy) o;

                if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
                return this.resourceTypes != null ? this.resourceTypes.equals(that.resourceTypes) : that.resourceTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resources != null ? this.resources.hashCode() : 0;
                result = 31 * result + (this.resourceTypes != null ? this.resourceTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a through resource statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ThroughResourcesStatementRequestProperty throughResourcesStatementRequestProperty = ThroughResourcesStatementRequestProperty.builder()
     *         .resourceStatement(ResourceStatementRequestProperty.builder()
     *                 .resources(List.of("resources"))
     *                 .resourceTypes(List.of("resourceTypes"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.ThroughResourcesStatementRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ThroughResourcesStatementRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThroughResourcesStatementRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceStatement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThroughResourcesStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThroughResourcesStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThroughResourcesStatementRequestProperty> {
            java.lang.Object resourceStatement;

            /**
             * Sets the value of {@link ThroughResourcesStatementRequestProperty#getResourceStatement}
             * @param resourceStatement The resource statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceStatement(software.amazon.awscdk.core.IResolvable resourceStatement) {
                this.resourceStatement = resourceStatement;
                return this;
            }

            /**
             * Sets the value of {@link ThroughResourcesStatementRequestProperty#getResourceStatement}
             * @param resourceStatement The resource statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceStatement(software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.ResourceStatementRequestProperty resourceStatement) {
                this.resourceStatement = resourceStatement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThroughResourcesStatementRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThroughResourcesStatementRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThroughResourcesStatementRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThroughResourcesStatementRequestProperty {
            private final java.lang.Object resourceStatement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceStatement = software.amazon.jsii.Kernel.get(this, "resourceStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceStatement = builder.resourceStatement;
            }

            @Override
            public final java.lang.Object getResourceStatement() {
                return this.resourceStatement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceStatement() != null) {
                    data.set("resourceStatement", om.valueToTree(this.getResourceStatement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScope.ThroughResourcesStatementRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThroughResourcesStatementRequestProperty.Jsii$Proxy that = (ThroughResourcesStatementRequestProperty.Jsii$Proxy) o;

                return this.resourceStatement != null ? this.resourceStatement.equals(that.resourceStatement) : that.resourceStatement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceStatement != null ? this.resourceStatement.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScopeProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The paths to exclude.
         * <p>
         * @return {@code this}
         * @param excludePaths The paths to exclude. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludePaths(final software.amazon.awscdk.core.IResolvable excludePaths) {
            this.props().excludePaths(excludePaths);
            return this;
        }
        /**
         * The paths to exclude.
         * <p>
         * @return {@code this}
         * @param excludePaths The paths to exclude. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludePaths(final java.util.List<? extends java.lang.Object> excludePaths) {
            this.props().excludePaths(excludePaths);
            return this;
        }

        /**
         * The paths to match.
         * <p>
         * @return {@code this}
         * @param matchPaths The paths to match. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPaths(final software.amazon.awscdk.core.IResolvable matchPaths) {
            this.props().matchPaths(matchPaths);
            return this;
        }
        /**
         * The paths to match.
         * <p>
         * @return {@code this}
         * @param matchPaths The paths to match. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPaths(final java.util.List<? extends java.lang.Object> matchPaths) {
            this.props().matchPaths(matchPaths);
            return this;
        }

        /**
         * The tags.
         * <p>
         * @return {@code this}
         * @param tags The tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope build() {
            return new software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScopeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScopeProps.Builder();
            }
            return this.props;
        }
    }
}
