package software.amazon.awscdk.services.ec2;

/**
 * Aspect that applies IMDS configuration on EC2 Launch Template constructs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * LaunchTemplateRequireImdsv2Aspect launchTemplateRequireImdsv2Aspect = LaunchTemplateRequireImdsv2Aspect.Builder.create()
 *         .suppressWarnings(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:28:00.033Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LaunchTemplateRequireImdsv2Aspect")
public class LaunchTemplateRequireImdsv2Aspect extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IAspect {

    protected LaunchTemplateRequireImdsv2Aspect(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LaunchTemplateRequireImdsv2Aspect(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplateRequireImdsv2Aspect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2AspectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplateRequireImdsv2Aspect() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * All aspects can visit an IConstruct.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void visit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct node) {
        software.amazon.jsii.Kernel.call(this, "visit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     * <p>
     * @param node The scope to add the warning to. This parameter is required.
     * @param message The warning message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void warn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct node, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "warn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getSuppressWarnings() {
        return software.amazon.jsii.Kernel.get(this, "suppressWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2Aspect}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2Aspect> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2AspectProps.Builder props;

        private Builder() {
        }

        /**
         * Whether warning annotations from this Aspect should be suppressed or not.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param suppressWarnings Whether warning annotations from this Aspect should be suppressed or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressWarnings(final java.lang.Boolean suppressWarnings) {
            this.props().suppressWarnings(suppressWarnings);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2Aspect}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2Aspect build() {
            return new software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2Aspect(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2AspectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.LaunchTemplateRequireImdsv2AspectProps.Builder();
            }
            return this.props;
        }
    }
}
