package software.amazon.awscdk.services.ec2;

/**
 * Creates a new EBS Volume in AWS EC2.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Instance instance;
 * Role role;
 * Volume volume = Volume.Builder.create(this, "Volume")
 *         .availabilityZone("us-west-2a")
 *         .size(Size.gibibytes(500))
 *         .encrypted(true)
 *         .build();
 * volume.grantAttachVolume(role, List.of(instance));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:28:00.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Volume")
public class Volume extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IVolume {

    protected Volume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Volume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Volume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing EBS Volume into the Stack.
     * <p>
     * @param scope the scope of the import. This parameter is required.
     * @param id the ID of the imported Volume in the construct tree. This parameter is required.
     * @param attrs the attributes of the imported Volume. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVolume fromVolumeAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VolumeAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Volume.class, "fromVolumeAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVolume.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Grants permission to attach this Volume to an instance.
     * <p>
     * CAUTION: Granting an instance permission to attach to itself using this method will lead to
     * an unresolvable circular reference between the instance role and the instance.
     * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
     * volume to itself.
     * <p>
     * @param grantee This parameter is required.
     * @param instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances) {
        return software.amazon.jsii.Kernel.call(this, "grantAttachVolume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), instances });
    }

    /**
     * Grants permission to attach this Volume to an instance.
     * <p>
     * CAUTION: Granting an instance permission to attach to itself using this method will lead to
     * an unresolvable circular reference between the instance role and the instance.
     * Use {&#64;link IVolume.grantAttachVolumeToSelf} to grant an instance permission to attach this
     * volume to itself.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantAttachVolume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants permission to attach the Volume by a ResourceTag condition.
     * <p>
     * If you are looking to
     * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
     * this volume to <strong>itself</strong> then this is the method you want to use.
     * <p>
     * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
     * constructs and this Volume, and then conditioning the Grant such that the grantee is only
     * given the ability to AttachVolume if both the Volume and the destination Instance have that
     * tag applied to them.
     * <p>
     * @param grantee This parameter is required.
     * @param constructs This parameter is required.
     * @param tagKeySuffix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.constructs.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix) {
        return software.amazon.jsii.Kernel.call(this, "grantAttachVolumeByResourceTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix });
    }

    /**
     * Grants permission to attach the Volume by a ResourceTag condition.
     * <p>
     * If you are looking to
     * grant an Instance, AutoScalingGroup, EC2-Fleet, SpotFleet, ECS host, etc the ability to attach
     * this volume to <strong>itself</strong> then this is the method you want to use.
     * <p>
     * This is implemented by adding a Tag with key <code>VolumeGrantAttach-&lt;suffix&gt;</code> to the given
     * constructs and this Volume, and then conditioning the Grant such that the grantee is only
     * given the ability to AttachVolume if both the Volume and the destination Instance have that
     * tag applied to them.
     * <p>
     * @param grantee This parameter is required.
     * @param constructs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantAttachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.constructs.Construct> constructs) {
        return software.amazon.jsii.Kernel.call(this, "grantAttachVolumeByResourceTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required") });
    }

    /**
     * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
     * <p>
     * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
     * volume from itself.
     * <p>
     * @param grantee This parameter is required.
     * @param instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IInstance> instances) {
        return software.amazon.jsii.Kernel.call(this, "grantDetachVolume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), instances });
    }

    /**
     * Grants permission to detach this Volume from an instance CAUTION: Granting an instance permission to detach from itself using this method will lead to an unresolvable circular reference between the instance role and the instance.
     * <p>
     * Use {&#64;link IVolume.grantDetachVolumeFromSelf} to grant an instance permission to detach this
     * volume from itself.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantDetachVolume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants permission to detach the Volume by a ResourceTag condition.
     * <p>
     * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
     * and is subject to the same conditions.
     * <p>
     * @param grantee This parameter is required.
     * @param constructs This parameter is required.
     * @param tagKeySuffix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.constructs.Construct> constructs, final @org.jetbrains.annotations.Nullable java.lang.String tagKeySuffix) {
        return software.amazon.jsii.Kernel.call(this, "grantDetachVolumeByResourceTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required"), tagKeySuffix });
    }

    /**
     * Grants permission to detach the Volume by a ResourceTag condition.
     * <p>
     * This is implemented via the same mechanism as {&#64;link IVolume.grantAttachVolumeByResourceTag},
     * and is subject to the same conditions.
     * <p>
     * @param grantee This parameter is required.
     * @param constructs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDetachVolumeByResourceTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.util.List<software.constructs.Construct> constructs) {
        return software.amazon.jsii.Kernel.call(this, "grantDetachVolumeByResourceTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(constructs, "constructs is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateProps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VolumeProps props) {
        software.amazon.jsii.Kernel.call(this, "validateProps", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The availability zone that the EBS Volume is contained within (ex: us-west-2a).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The EBS Volume's ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVolumeId() {
        return software.amazon.jsii.Kernel.get(this, "volumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The customer-managed encryption key that is used to encrypt the Volume.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Volume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Volume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.VolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.VolumeProps.Builder();
        }

        /**
         * The Availability Zone in which to create the volume.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone in which to create the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * Indicates whether the volume is auto-enabled for I/O operations.
         * <p>
         * By default, Amazon EBS disables I/O to the volume from attached EC2
         * instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and
         * you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(final java.lang.Boolean autoEnableIo) {
            this.props.autoEnableIo(autoEnableIo);
            return this;
        }

        /**
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         * <p>
         * See {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html#considerations|Considerations and limitations}
         * for the constraints of multi-attach.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableMultiAttach Indicates whether Amazon EBS Multi-Attach is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMultiAttach(final java.lang.Boolean enableMultiAttach) {
            this.props.enableMultiAttach(enableMultiAttach);
            return this;
        }

        /**
         * Specifies whether the volume should be encrypted.
         * <p>
         * The effect of setting the encryption state to true depends on the volume origin
         * (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information,
         * see {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default|Encryption by Default}
         * in the Amazon Elastic Compute Cloud User Guide.
         * <p>
         * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
         * {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances|Supported Instance Types.}
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param encrypted Specifies whether the volume should be encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        /**
         * The customer-managed encryption key that is used to encrypt the Volume.
         * <p>
         * The encrypted property must
         * be true if this is provided.
         * <p>
         * Note: If using an {&#64;link aws-kms.IKey} created from a {&#64;link aws-kms.Key.fromKeyArn()} here,
         * then the KMS key <strong>must</strong> have the following in its Key policy; otherwise, the Volume
         * will fail to create.
         * <p>
         * <blockquote><pre>
         *  {
         *    "Effect": "Allow",
         *    "Principal": { "AWS": "&lt;arn for your account-user&gt; ex: arn:aws:iam::00000000000:root" },
         *    "Resource": "*",
         *    "Action": [
         *      "kms:DescribeKey",
         *      "kms:GenerateDataKeyWithoutPlainText",
         *    ],
         *    "Condition": {
         *      "StringEquals": {
         *        "kms:ViaService": "ec2.&lt;Region&gt;.amazonaws.com", (eg: ec2.us-east-1.amazonaws.com)
         *        "kms:CallerAccount": "0000000000" (your account ID)
         *      }
         *    }
         *  }
         * </pre></blockquote>
         * <p>
         * Default: The default KMS key for the account, region, and EC2 service is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey The customer-managed encryption key that is used to encrypt the Volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * The number of I/O operations per second (IOPS) to provision for the volume.
         * <p>
         * The maximum ratio is 50 IOPS/GiB for PROVISIONED_IOPS_SSD,
         * and 500 IOPS/GiB for both PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3.
         * See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
         * for more information.
         * <p>
         * This parameter is valid only for PROVISIONED_IOPS_SSD, PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3 volumes.
         * <p>
         * Default: None -- Required for io1 and io2 volumes. The default for gp3 volumes is 3,000 IOPS if omitted.
         * <p>
         * @return {@code this}
         * @param iops The number of I/O operations per second (IOPS) to provision for the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(final java.lang.Number iops) {
            this.props.iops(iops);
            return this;
        }

        /**
         * Policy to apply when the volume is removed from the stack.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the volume is removed from the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The size of the volume, in GiBs.
         * <p>
         * You must specify either a snapshot ID or a volume size.
         * See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
         * for details on the allowable size for each type of volume.
         * <p>
         * Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.
         * <p>
         * @return {@code this}
         * @param size The size of the volume, in GiBs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(final software.amazon.awscdk.core.Size size) {
            this.props.size(size);
            return this;
        }

        /**
         * The snapshot from which to create the volume.
         * <p>
         * You must specify either a snapshot ID or a volume size.
         * <p>
         * Default: The EBS volume is not created from a snapshot.
         * <p>
         * @return {@code this}
         * @param snapshotId The snapshot from which to create the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotId(final java.lang.String snapshotId) {
            this.props.snapshotId(snapshotId);
            return this;
        }

        /**
         * The value of the physicalName property of this resource.
         * <p>
         * Default: The physical name will be allocated by CloudFormation at deployment time
         * <p>
         * @return {@code this}
         * @param volumeName The value of the physicalName property of this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeName(final java.lang.String volumeName) {
            this.props.volumeName(volumeName);
            return this;
        }

        /**
         * The type of the volume;
         * <p>
         * what type of storage to use to form the EBS Volume.
         * <p>
         * Default: {@link EbsDeviceVolumeType.GENERAL_PURPOSE_SSD}
         * <p>
         * @return {@code this}
         * @param volumeType The type of the volume;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType) {
            this.props.volumeType(volumeType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Volume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Volume build() {
            return new software.amazon.awscdk.services.ec2.Volume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
