package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Host`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:50.731Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnHost")
public class CfnHost extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnHost(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHost(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnHost.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::Host`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnHost(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnHostProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAvailabilityZone() {
        return this.jsiiGet("availabilityZone", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAvailabilityZone(final java.lang.String value) {
        this.jsiiSet("availabilityZone", java.util.Objects.requireNonNull(value, "availabilityZone is required"));
    }

    /**
     * `AWS::EC2::Host.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getInstanceType() {
        return this.jsiiGet("instanceType", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Host.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceType(final java.lang.String value) {
        this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
    }

    /**
     * `AWS::EC2::Host.AutoPlacement`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAutoPlacement() {
        return this.jsiiGet("autoPlacement", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Host.AutoPlacement`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAutoPlacement(final java.lang.String value) {
        this.jsiiSet("autoPlacement", value);
    }

    /**
     * `AWS::EC2::Host.HostRecovery`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHostRecovery() {
        return this.jsiiGet("hostRecovery", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Host.HostRecovery`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHostRecovery(final java.lang.String value) {
        this.jsiiSet("hostRecovery", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnHost}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnHostProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnHostProps.Builder();
        }

        /**
         * @return {@code this}
         * @param availabilityZone `AWS::EC2::Host.AvailabilityZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * @return {@code this}
         * @param instanceType `AWS::EC2::Host.InstanceType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * @return {@code this}
         * @param autoPlacement `AWS::EC2::Host.AutoPlacement`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder autoPlacement(final java.lang.String autoPlacement) {
            this.props.autoPlacement(autoPlacement);
            return this;
        }

        /**
         * @return {@code this}
         * @param hostRecovery `AWS::EC2::Host.HostRecovery`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder hostRecovery(final java.lang.String hostRecovery) {
            this.props.hostRecovery(hostRecovery);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnHost}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnHost build() {
            return new software.amazon.awscdk.services.ec2.CfnHost(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
