package software.amazon.awscdk.services.ec2;

/**
 * This represents a single EC2 instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:50.804Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Instance")
public class Instance extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IInstance {

    protected Instance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Instance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Instance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.InstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to the instance.
     * 
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Adds a statement to the IAM role assumed by the instance.
     * 
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add command to the startup script of the instance. The command must be in the scripting language supported by the instance's OS (i.e. Linux/Windows).
     * 
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserData(final java.lang.String... commands) {
        this.jsiiCall("addUserData", Void.class, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Allows specify security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * the underlying instance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.CfnInstance getInstance() {
        return this.jsiiGet("instance", software.amazon.awscdk.services.ec2.CfnInstance.class);
    }

    /**
     * The availability zone the instance was launched in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", java.lang.String.class);
    }

    /**
     * The instance's ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * Private DNS name for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", java.lang.String.class);
    }

    /**
     * Private IP for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", java.lang.String.class);
    }

    /**
     * Publicly-routable DNS name for this instance.
     * 
     * (May be an empty string if the instance does not have a public name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", java.lang.String.class);
    }

    /**
     * Publicly-routable IP  address for this instance.
     * 
     * (May be an empty string if the instance does not have a public IP).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", java.lang.String.class);
    }

    /**
     * The type of OS the instance is running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
    }

    /**
     * The IAM role assumed by the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * UserData for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.UserData getUserData() {
        return this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Instance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.InstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.InstanceProps.Builder();
        }

        /**
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * @return {@code this}
         * @param machineImage AMI to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return {@code this}
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default. This property is only used when you do not provide a security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * @return {@code this}
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * @return {@code this}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(final software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        /**
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * @return {@code this}
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether source/destination checking is enabled on the instance. A value of true means that checking is enabled, and false means that checking is disabled. The value must be false for the instance to perform NAT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(final java.lang.Boolean sourceDestCheck) {
            this.props.sourceDestCheck(sourceDestCheck);
            return this;
        }

        /**
         * @return {@code this}
         * @param userData Specific UserData to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpcSubnets Where to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Instance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Instance build() {
            return new software.amazon.awscdk.services.ec2.Instance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
