package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Instance`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.3 (build 26aa77c)", date = "2019-11-12T00:10:04.590Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::Instance`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnInstance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::Instance`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnInstance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrAvailabilityZone() {
        return this.jsiiGet("attrAvailabilityZone", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPrivateDnsName() {
        return this.jsiiGet("attrPrivateDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPrivateIp() {
        return this.jsiiGet("attrPrivateIp", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPublicDnsName() {
        return this.jsiiGet("attrPublicDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPublicIp() {
        return this.jsiiGet("attrPublicIp", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::EC2::Instance.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAdditionalInfo() {
        return this.jsiiGet("additionalInfo", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAdditionalInfo(final java.lang.String value) {
        this.jsiiSet("additionalInfo", value);
    }

    /**
     * `AWS::EC2::Instance.Affinity`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAffinity() {
        return this.jsiiGet("affinity", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.Affinity`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAffinity(final java.lang.String value) {
        this.jsiiSet("affinity", value);
    }

    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAvailabilityZone() {
        return this.jsiiGet("availabilityZone", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAvailabilityZone(final java.lang.String value) {
        this.jsiiSet("availabilityZone", value);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getBlockDeviceMappings() {
        return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBlockDeviceMappings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBlockDeviceMappings(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::EC2::Instance.CpuOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCpuOptions() {
        return this.jsiiGet("cpuOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.CpuOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCpuOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cpuOptions", value);
    }

    /**
     * `AWS::EC2::Instance.CpuOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCpuOptions(final software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty value) {
        this.jsiiSet("cpuOptions", value);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCreditSpecification() {
        return this.jsiiGet("creditSpecification", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCreditSpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("creditSpecification", value);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCreditSpecification(final software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty value) {
        this.jsiiSet("creditSpecification", value);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDisableApiTermination() {
        return this.jsiiGet("disableApiTermination", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDisableApiTermination(final java.lang.Boolean value) {
        this.jsiiSet("disableApiTermination", value);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDisableApiTermination(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("disableApiTermination", value);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEbsOptimized() {
        return this.jsiiGet("ebsOptimized", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEbsOptimized(final java.lang.Boolean value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEbsOptimized(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getElasticGpuSpecifications() {
        return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticGpuSpecifications(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticGpuSpecifications(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getElasticInferenceAccelerators() {
        return this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticInferenceAccelerators(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticInferenceAccelerators(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    /**
     * `AWS::EC2::Instance.HostId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHostId() {
        return this.jsiiGet("hostId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.HostId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHostId(final java.lang.String value) {
        this.jsiiSet("hostId", value);
    }

    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getIamInstanceProfile() {
        return this.jsiiGet("iamInstanceProfile", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIamInstanceProfile(final java.lang.String value) {
        this.jsiiSet("iamInstanceProfile", value);
    }

    /**
     * `AWS::EC2::Instance.ImageId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.ImageId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setImageId(final java.lang.String value) {
        this.jsiiSet("imageId", value);
    }

    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getInstanceInitiatedShutdownBehavior() {
        return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceInitiatedShutdownBehavior(final java.lang.String value) {
        this.jsiiSet("instanceInitiatedShutdownBehavior", value);
    }

    /**
     * `AWS::EC2::Instance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getInstanceType() {
        return this.jsiiGet("instanceType", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceType(final java.lang.String value) {
        this.jsiiSet("instanceType", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getIpv6AddressCount() {
        return this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6AddressCount(final java.lang.Number value) {
        this.jsiiSet("ipv6AddressCount", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getIpv6Addresses() {
        return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6Addresses(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6Addresses(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    /**
     * `AWS::EC2::Instance.KernelId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getKernelId() {
        return this.jsiiGet("kernelId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.KernelId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKernelId(final java.lang.String value) {
        this.jsiiSet("kernelId", value);
    }

    /**
     * `AWS::EC2::Instance.KeyName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getKeyName() {
        return this.jsiiGet("keyName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.KeyName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKeyName(final java.lang.String value) {
        this.jsiiSet("keyName", value);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLaunchTemplate() {
        return this.jsiiGet("launchTemplate", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplate(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("launchTemplate", value);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplate(final software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty value) {
        this.jsiiSet("launchTemplate", value);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLicenseSpecifications() {
        return this.jsiiGet("licenseSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLicenseSpecifications(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLicenseSpecifications(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMonitoring() {
        return this.jsiiGet("monitoring", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMonitoring(final java.lang.Boolean value) {
        this.jsiiSet("monitoring", value);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMonitoring(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("monitoring", value);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getNetworkInterfaces() {
        return this.jsiiGet("networkInterfaces", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkInterfaces(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("networkInterfaces", value);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkInterfaces(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("networkInterfaces", value);
    }

    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getPlacementGroupName() {
        return this.jsiiGet("placementGroupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPlacementGroupName(final java.lang.String value) {
        this.jsiiSet("placementGroupName", value);
    }

    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getPrivateIpAddress() {
        return this.jsiiGet("privateIpAddress", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPrivateIpAddress(final java.lang.String value) {
        this.jsiiSet("privateIpAddress", value);
    }

    /**
     * `AWS::EC2::Instance.RamdiskId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRamdiskId() {
        return this.jsiiGet("ramdiskId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.RamdiskId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRamdiskId(final java.lang.String value) {
        this.jsiiSet("ramdiskId", value);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("securityGroupIds", java.util.List.class));
    }

    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIds(final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("securityGroups", java.util.List.class));
    }

    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroups(final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSourceDestCheck() {
        return this.jsiiGet("sourceDestCheck", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceDestCheck(final java.lang.Boolean value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceDestCheck(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSsmAssociations() {
        return this.jsiiGet("ssmAssociations", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSsmAssociations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ssmAssociations", value);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSsmAssociations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("ssmAssociations", value);
    }

    /**
     * `AWS::EC2::Instance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getSubnetId() {
        return this.jsiiGet("subnetId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnetId(final java.lang.String value) {
        this.jsiiSet("subnetId", value);
    }

    /**
     * `AWS::EC2::Instance.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getTenancy() {
        return this.jsiiGet("tenancy", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTenancy(final java.lang.String value) {
        this.jsiiSet("tenancy", value);
    }

    /**
     * `AWS::EC2::Instance.UserData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getUserData() {
        return this.jsiiGet("userData", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.UserData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setUserData(final java.lang.String value) {
        this.jsiiSet("userData", value);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getVolumes() {
        return this.jsiiGet("volumes", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVolumes(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("volumes", value);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVolumes(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("volumes", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociationParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AssociationParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.AssociationParameterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnInstance.AssociationParameterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValue();

        /**
         * @return a {@link Builder} of {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.util.List<java.lang.String> value;

            /**
             * Sets the value of Key
             * @param key `CfnInstance.AssociationParameterProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnInstance.AssociationParameterProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.util.List<java.lang.String> value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AssociationParameterProperty build() {
                return new Jsii$Proxy(key, value);
            }
        }

        /**
         * An implementation for {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociationParameterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String key, final java.util.List<java.lang.String> value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.util.List<java.lang.String> getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociationParameterProperty.Jsii$Proxy that = (AssociationParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceName();

        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getEbs() {
            return null;
        }

        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getNoDevice() {
            return null;
        }

        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String deviceName;
            private java.lang.Object ebs;
            private java.lang.Object noDevice;
            private java.lang.String virtualName;

            /**
             * Sets the value of DeviceName
             * @param deviceName `CfnInstance.BlockDeviceMappingProperty.DeviceName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of Ebs
             * @param ebs `CfnInstance.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of Ebs
             * @param ebs `CfnInstance.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ebs(software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of NoDevice
             * @param noDevice `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noDevice(software.amazon.awscdk.core.IResolvable noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of NoDevice
             * @param noDevice `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder noDevice(software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of VirtualName
             * @param virtualName `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(deviceName, ebs, noDevice, virtualName);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.Object noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = this.jsiiGet("deviceName", java.lang.String.class);
                this.ebs = this.jsiiGet("ebs", java.lang.Object.class);
                this.noDevice = this.jsiiGet("noDevice", java.lang.Object.class);
                this.virtualName = this.jsiiGet("virtualName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String deviceName, final java.lang.Object ebs, final java.lang.Object noDevice, final java.lang.String virtualName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = java.util.Objects.requireNonNull(deviceName, "deviceName is required");
                this.ebs = ebs;
                this.noDevice = noDevice;
                this.virtualName = virtualName;
            }

            @Override
            public java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public java.lang.Object getNoDevice() {
                return this.noDevice;
            }

            @Override
            public java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceName", om.valueToTree(this.getDeviceName()));
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (!deviceName.equals(that.deviceName)) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public int hashCode() {
                int result = this.deviceName.hashCode();
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CpuOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.CpuOptionsProperty.CoreCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-corecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getCoreCount() {
            return null;
        }

        /**
         * `CfnInstance.CpuOptionsProperty.ThreadsPerCore`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-threadspercore
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number coreCount;
            private java.lang.Number threadsPerCore;

            /**
             * Sets the value of CoreCount
             * @param coreCount `CfnInstance.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder coreCount(java.lang.Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            /**
             * Sets the value of ThreadsPerCore
             * @param threadsPerCore `CfnInstance.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CpuOptionsProperty build() {
                return new Jsii$Proxy(coreCount, threadsPerCore);
            }
        }

        /**
         * An implementation for {@link CpuOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CpuOptionsProperty {
            private final java.lang.Number coreCount;
            private final java.lang.Number threadsPerCore;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreCount = this.jsiiGet("coreCount", java.lang.Number.class);
                this.threadsPerCore = this.jsiiGet("threadsPerCore", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number coreCount, final java.lang.Number threadsPerCore) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreCount = coreCount;
                this.threadsPerCore = threadsPerCore;
            }

            @Override
            public java.lang.Number getCoreCount() {
                return this.coreCount;
            }

            @Override
            public java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoreCount() != null) {
                    data.set("coreCount", om.valueToTree(this.getCoreCount()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CpuOptionsProperty.Jsii$Proxy that = (CpuOptionsProperty.Jsii$Proxy) o;

                if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
                return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
            }

            @Override
            public int hashCode() {
                int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreditSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.CreditSpecificationProperty.CPUCredits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getCpuCredits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param cpuCredits `CfnInstance.CreditSpecificationProperty.CPUCredits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cpuCredits(java.lang.String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CreditSpecificationProperty build() {
                return new Jsii$Proxy(cpuCredits);
            }
        }

        /**
         * An implementation for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreditSpecificationProperty {
            private final java.lang.String cpuCredits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuCredits = this.jsiiGet("cpuCredits", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cpuCredits) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuCredits = cpuCredits;
            }

            @Override
            public java.lang.String getCpuCredits() {
                return this.cpuCredits;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuCredits() != null) {
                    data.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreditSpecificationProperty.Jsii$Proxy that = (CreditSpecificationProperty.Jsii$Proxy) o;

                return this.cpuCredits != null ? this.cpuCredits.equals(that.cpuCredits) : that.cpuCredits == null;
            }

            @Override
            public int hashCode() {
                int result = this.cpuCredits != null ? this.cpuCredits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.EbsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.EbsProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getIops() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-instance-ebs-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * `CfnInstance.EbsProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object deleteOnTermination;
            private java.lang.Object encrypted;
            private java.lang.Number iops;
            private java.lang.String kmsKeyId;
            private java.lang.String snapshotId;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnInstance.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnInstance.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of Encrypted
             * @param encrypted `CfnInstance.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of Encrypted
             * @param encrypted `CfnInstance.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of Iops
             * @param iops `CfnInstance.EbsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of KmsKeyId
             * @param kmsKeyId `CfnInstance.EbsProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of SnapshotId
             * @param snapshotId `CfnInstance.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of VolumeSize
             * @param volumeSize `CfnInstance.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of VolumeType
             * @param volumeType `CfnInstance.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EbsProperty build() {
                return new Jsii$Proxy(deleteOnTermination, encrypted, iops, kmsKeyId, snapshotId, volumeSize, volumeType);
            }
        }

        /**
         * An implementation for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.encrypted = this.jsiiGet("encrypted", java.lang.Object.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
                this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
                this.snapshotId = this.jsiiGet("snapshotId", java.lang.String.class);
                this.volumeSize = this.jsiiGet("volumeSize", java.lang.Number.class);
                this.volumeType = this.jsiiGet("volumeType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object deleteOnTermination, final java.lang.Object encrypted, final java.lang.Number iops, final java.lang.String kmsKeyId, final java.lang.String snapshotId, final java.lang.Number volumeSize, final java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = deleteOnTermination;
                this.encrypted = encrypted;
                this.iops = iops;
                this.kmsKeyId = kmsKeyId;
                this.snapshotId = snapshotId;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.EbsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsProperty.Jsii$Proxy that = (EbsProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticGpuSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.ElasticGpuSpecificationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String type;

            /**
             * Sets the value of Type
             * @param type `CfnInstance.ElasticGpuSpecificationProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticGpuSpecificationProperty build() {
                return new Jsii$Proxy(type);
            }
        }

        /**
         * An implementation for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticGpuSpecificationProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticGpuSpecificationProperty.Jsii$Proxy that = (ElasticGpuSpecificationProperty.Jsii$Proxy) o;

                return this.type.equals(that.type);
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticInferenceAcceleratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String type;

            /**
             * Sets the value of Type
             * @param type `CfnInstance.ElasticInferenceAcceleratorProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticInferenceAcceleratorProperty build() {
                return new Jsii$Proxy(type);
            }
        }

        /**
         * An implementation for {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticInferenceAcceleratorProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticInferenceAcceleratorProperty.Jsii$Proxy that = (ElasticInferenceAcceleratorProperty.Jsii$Proxy) o;

                return this.type.equals(that.type);
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceIpv6AddressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param ipv6Address `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Address(java.lang.String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InstanceIpv6AddressProperty build() {
                return new Jsii$Proxy(ipv6Address);
            }
        }

        /**
         * An implementation for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceIpv6AddressProperty {
            private final java.lang.String ipv6Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv6Address = this.jsiiGet("ipv6Address", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String ipv6Address) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv6Address = java.util.Objects.requireNonNull(ipv6Address, "ipv6Address is required");
            }

            @Override
            public java.lang.String getIpv6Address() {
                return this.ipv6Address;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipv6Address", om.valueToTree(this.getIpv6Address()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceIpv6AddressProperty.Jsii$Proxy that = (InstanceIpv6AddressProperty.Jsii$Proxy) o;

                return this.ipv6Address.equals(that.ipv6Address);
            }

            @Override
            public int hashCode() {
                int result = this.ipv6Address.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchTemplateSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String version;
            private java.lang.String launchTemplateId;
            private java.lang.String launchTemplateName;

            /**
             * Sets the value of Version
             * @param version `CfnInstance.LaunchTemplateSpecificationProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of LaunchTemplateId
             * @param launchTemplateId `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of LaunchTemplateName
             * @param launchTemplateName `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateSpecificationProperty build() {
                return new Jsii$Proxy(version, launchTemplateId, launchTemplateName);
            }
        }

        /**
         * An implementation for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateSpecificationProperty {
            private final java.lang.String version;
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = this.jsiiGet("version", java.lang.String.class);
                this.launchTemplateId = this.jsiiGet("launchTemplateId", java.lang.String.class);
                this.launchTemplateName = this.jsiiGet("launchTemplateName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String version, final java.lang.String launchTemplateId, final java.lang.String launchTemplateName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = java.util.Objects.requireNonNull(version, "version is required");
                this.launchTemplateId = launchTemplateId;
                this.launchTemplateName = launchTemplateName;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchTemplateSpecificationProperty.Jsii$Proxy that = (LaunchTemplateSpecificationProperty.Jsii$Proxy) o;

                if (!version.equals(that.version)) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.launchTemplateName != null ? this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName == null;
            }

            @Override
            public int hashCode() {
                int result = this.version.hashCode();
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(LicenseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param licenseConfigurationArn `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder licenseConfigurationArn(java.lang.String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LicenseSpecificationProperty build() {
                return new Jsii$Proxy(licenseConfigurationArn);
            }
        }

        /**
         * An implementation for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseSpecificationProperty {
            private final java.lang.String licenseConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.licenseConfigurationArn = this.jsiiGet("licenseConfigurationArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String licenseConfigurationArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.licenseConfigurationArn = java.util.Objects.requireNonNull(licenseConfigurationArn, "licenseConfigurationArn is required");
            }

            @Override
            public java.lang.String getLicenseConfigurationArn() {
                return this.licenseConfigurationArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LicenseSpecificationProperty.Jsii$Proxy that = (LicenseSpecificationProperty.Jsii$Proxy) o;

                return this.licenseConfigurationArn.equals(that.licenseConfigurationArn);
            }

            @Override
            public int hashCode() {
                int result = this.licenseConfigurationArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceIndex();

        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getAssociatePublicIpAddress() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.GroupSet`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getGroupSet() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getIpv6AddressCount() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getIpv6Addresses() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getPrivateIpAddresses() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        /**
         * `CfnInstance.NetworkInterfaceProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String deviceIndex;
            private java.lang.Object associatePublicIpAddress;
            private java.lang.Object deleteOnTermination;
            private java.lang.String description;
            private java.util.List<java.lang.String> groupSet;
            private java.lang.Number ipv6AddressCount;
            private java.lang.Object ipv6Addresses;
            private java.lang.String networkInterfaceId;
            private java.lang.String privateIpAddress;
            private java.lang.Object privateIpAddresses;
            private java.lang.Number secondaryPrivateIpAddressCount;
            private java.lang.String subnetId;

            /**
             * Sets the value of DeviceIndex
             * @param deviceIndex `CfnInstance.NetworkInterfaceProperty.DeviceIndex`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deviceIndex(java.lang.String deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param associatePublicIpAddress `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param associatePublicIpAddress `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associatePublicIpAddress(software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of DeleteOnTermination
             * @param deleteOnTermination `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of Description
             * @param description `CfnInstance.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of GroupSet
             * @param groupSet `CfnInstance.NetworkInterfaceProperty.GroupSet`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder groupSet(java.util.List<java.lang.String> groupSet) {
                this.groupSet = groupSet;
                return this;
            }

            /**
             * Sets the value of Ipv6AddressCount
             * @param ipv6AddressCount `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            /**
             * Sets the value of Ipv6Addresses
             * @param ipv6Addresses `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of Ipv6Addresses
             * @param ipv6Addresses `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipv6Addresses(java.util.List<java.lang.Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            /**
             * Sets the value of NetworkInterfaceId
             * @param networkInterfaceId `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddress
             * @param privateIpAddress `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddresses
             * @param privateIpAddresses `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddresses
             * @param privateIpAddresses `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddresses(java.util.List<java.lang.Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param secondaryPrivateIpAddressCount `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            /**
             * Sets the value of SubnetId
             * @param subnetId `CfnInstance.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(deviceIndex, associatePublicIpAddress, deleteOnTermination, description, groupSet, ipv6AddressCount, ipv6Addresses, networkInterfaceId, privateIpAddress, privateIpAddresses, secondaryPrivateIpAddressCount, subnetId);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.String deviceIndex;
            private final java.lang.Object associatePublicIpAddress;
            private final java.lang.Object deleteOnTermination;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> groupSet;
            private final java.lang.Number ipv6AddressCount;
            private final java.lang.Object ipv6Addresses;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.Object privateIpAddresses;
            private final java.lang.Number secondaryPrivateIpAddressCount;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceIndex = this.jsiiGet("deviceIndex", java.lang.String.class);
                this.associatePublicIpAddress = this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.groupSet = this.jsiiGet("groupSet", java.util.List.class);
                this.ipv6AddressCount = this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
                this.ipv6Addresses = this.jsiiGet("ipv6Addresses", java.lang.Object.class);
                this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
                this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
                this.privateIpAddresses = this.jsiiGet("privateIpAddresses", java.lang.Object.class);
                this.secondaryPrivateIpAddressCount = this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String deviceIndex, final java.lang.Object associatePublicIpAddress, final java.lang.Object deleteOnTermination, final java.lang.String description, final java.util.List<java.lang.String> groupSet, final java.lang.Number ipv6AddressCount, final java.lang.Object ipv6Addresses, final java.lang.String networkInterfaceId, final java.lang.String privateIpAddress, final java.lang.Object privateIpAddresses, final java.lang.Number secondaryPrivateIpAddressCount, final java.lang.String subnetId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceIndex = java.util.Objects.requireNonNull(deviceIndex, "deviceIndex is required");
                this.associatePublicIpAddress = associatePublicIpAddress;
                this.deleteOnTermination = deleteOnTermination;
                this.description = description;
                this.groupSet = groupSet;
                this.ipv6AddressCount = ipv6AddressCount;
                this.ipv6Addresses = ipv6Addresses;
                this.networkInterfaceId = networkInterfaceId;
                this.privateIpAddress = privateIpAddress;
                this.privateIpAddresses = privateIpAddresses;
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                this.subnetId = subnetId;
            }

            @Override
            public java.lang.String getDeviceIndex() {
                return this.deviceIndex;
            }

            @Override
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.associatePublicIpAddress;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.util.List<java.lang.String> getGroupSet() {
                return this.groupSet;
            }

            @Override
            public java.lang.Number getIpv6AddressCount() {
                return this.ipv6AddressCount;
            }

            @Override
            public java.lang.Object getIpv6Addresses() {
                return this.ipv6Addresses;
            }

            @Override
            public java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public java.lang.Object getPrivateIpAddresses() {
                return this.privateIpAddresses;
            }

            @Override
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.secondaryPrivateIpAddressCount;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                if (this.getAssociatePublicIpAddress() != null) {
                    data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                }
                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getGroupSet() != null) {
                    data.set("groupSet", om.valueToTree(this.getGroupSet()));
                }
                if (this.getIpv6AddressCount() != null) {
                    data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                }
                if (this.getIpv6Addresses() != null) {
                    data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getPrivateIpAddresses() != null) {
                    data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                }
                if (this.getSecondaryPrivateIpAddressCount() != null) {
                    data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (!deviceIndex.equals(that.deviceIndex)) return false;
                if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.groupSet != null ? !this.groupSet.equals(that.groupSet) : that.groupSet != null) return false;
                if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
                if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
                if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public int hashCode() {
                int result = this.deviceIndex.hashCode();
                result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
                result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.groupSet != null ? this.groupSet.hashCode() : 0);
                result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
                result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
                result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(NoDeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NoDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NoDeviceProperty build() {
                return new Jsii$Proxy();
            }
        }

        /**
         * An implementation for {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoDeviceProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy() {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PrivateIpAddressSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrimary();

        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object primary;
            private java.lang.String privateIpAddress;

            /**
             * Sets the value of Primary
             * @param primary `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder primary(java.lang.Boolean primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of Primary
             * @param primary `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder primary(software.amazon.awscdk.core.IResolvable primary) {
                this.primary = primary;
                return this;
            }

            /**
             * Sets the value of PrivateIpAddress
             * @param privateIpAddress `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii$Proxy(primary, privateIpAddress);
            }
        }

        /**
         * An implementation for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateIpAddressSpecificationProperty {
            private final java.lang.Object primary;
            private final java.lang.String privateIpAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primary = this.jsiiGet("primary", java.lang.Object.class);
                this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object primary, final java.lang.String privateIpAddress) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primary = java.util.Objects.requireNonNull(primary, "primary is required");
                this.privateIpAddress = java.util.Objects.requireNonNull(privateIpAddress, "privateIpAddress is required");
            }

            @Override
            public java.lang.Object getPrimary() {
                return this.primary;
            }

            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primary", om.valueToTree(this.getPrimary()));
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrivateIpAddressSpecificationProperty.Jsii$Proxy that = (PrivateIpAddressSpecificationProperty.Jsii$Proxy) o;

                if (!primary.equals(that.primary)) return false;
                return this.privateIpAddress.equals(that.privateIpAddress);
            }

            @Override
            public int hashCode() {
                int result = this.primary.hashCode();
                result = 31 * result + (this.privateIpAddress.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(SsmAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SsmAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.SsmAssociationProperty.DocumentName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDocumentName();

        /**
         * `CfnInstance.SsmAssociationProperty.AssociationParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getAssociationParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String documentName;
            private java.lang.Object associationParameters;

            /**
             * Sets the value of DocumentName
             * @param documentName `CfnInstance.SsmAssociationProperty.DocumentName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder documentName(java.lang.String documentName) {
                this.documentName = documentName;
                return this;
            }

            /**
             * Sets the value of AssociationParameters
             * @param associationParameters `CfnInstance.SsmAssociationProperty.AssociationParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associationParameters(software.amazon.awscdk.core.IResolvable associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            /**
             * Sets the value of AssociationParameters
             * @param associationParameters `CfnInstance.SsmAssociationProperty.AssociationParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder associationParameters(java.util.List<java.lang.Object> associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SsmAssociationProperty build() {
                return new Jsii$Proxy(documentName, associationParameters);
            }
        }

        /**
         * An implementation for {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsmAssociationProperty {
            private final java.lang.String documentName;
            private final java.lang.Object associationParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentName = this.jsiiGet("documentName", java.lang.String.class);
                this.associationParameters = this.jsiiGet("associationParameters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String documentName, final java.lang.Object associationParameters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentName = java.util.Objects.requireNonNull(documentName, "documentName is required");
                this.associationParameters = associationParameters;
            }

            @Override
            public java.lang.String getDocumentName() {
                return this.documentName;
            }

            @Override
            public java.lang.Object getAssociationParameters() {
                return this.associationParameters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentName", om.valueToTree(this.getDocumentName()));
                if (this.getAssociationParameters() != null) {
                    data.set("associationParameters", om.valueToTree(this.getAssociationParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsmAssociationProperty.Jsii$Proxy that = (SsmAssociationProperty.Jsii$Proxy) o;

                if (!documentName.equals(that.documentName)) return false;
                return this.associationParameters != null ? this.associationParameters.equals(that.associationParameters) : that.associationParameters == null;
            }

            @Override
            public int hashCode() {
                int result = this.documentName.hashCode();
                result = 31 * result + (this.associationParameters != null ? this.associationParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance.VolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.VolumeProperty.Device`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDevice();

        /**
         * `CfnInstance.VolumeProperty.VolumeId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVolumeId();

        /**
         * @return a {@link Builder} of {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String device;
            private java.lang.String volumeId;

            /**
             * Sets the value of Device
             * @param device `CfnInstance.VolumeProperty.Device`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder device(java.lang.String device) {
                this.device = device;
                return this;
            }

            /**
             * Sets the value of VolumeId
             * @param volumeId `CfnInstance.VolumeProperty.VolumeId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder volumeId(java.lang.String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VolumeProperty build() {
                return new Jsii$Proxy(device, volumeId);
            }
        }

        /**
         * An implementation for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeProperty {
            private final java.lang.String device;
            private final java.lang.String volumeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.device = this.jsiiGet("device", java.lang.String.class);
                this.volumeId = this.jsiiGet("volumeId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String device, final java.lang.String volumeId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.device = java.util.Objects.requireNonNull(device, "device is required");
                this.volumeId = java.util.Objects.requireNonNull(volumeId, "volumeId is required");
            }

            @Override
            public java.lang.String getDevice() {
                return this.device;
            }

            @Override
            public java.lang.String getVolumeId() {
                return this.volumeId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("device", om.valueToTree(this.getDevice()));
                data.set("volumeId", om.valueToTree(this.getVolumeId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnInstance.VolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeProperty.Jsii$Proxy that = (VolumeProperty.Jsii$Proxy) o;

                if (!device.equals(that.device)) return false;
                return this.volumeId.equals(that.volumeId);
            }

            @Override
            public int hashCode() {
                int result = this.device.hashCode();
                result = 31 * result + (this.volumeId.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param additionalInfo `AWS::EC2::Instance.AdditionalInfo`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder additionalInfo(final java.lang.String additionalInfo) {
            this.props().additionalInfo(additionalInfo);
            return this;
        }

        /**
         * @return {@code this}
         * @param affinity `AWS::EC2::Instance.Affinity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder affinity(final java.lang.String affinity) {
            this.props().affinity(affinity);
            return this;
        }

        /**
         * @return {@code this}
         * @param availabilityZone `AWS::EC2::Instance.AvailabilityZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * @return {@code this}
         * @param blockDeviceMappings `AWS::EC2::Instance.BlockDeviceMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder blockDeviceMappings(final software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }
        /**
         * @return {@code this}
         * @param blockDeviceMappings `AWS::EC2::Instance.BlockDeviceMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder blockDeviceMappings(final java.util.List<java.lang.Object> blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        /**
         * @return {@code this}
         * @param cpuOptions `AWS::EC2::Instance.CpuOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cpuOptions(final software.amazon.awscdk.core.IResolvable cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }
        /**
         * @return {@code this}
         * @param cpuOptions `AWS::EC2::Instance.CpuOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cpuOptions(final software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param creditSpecification `AWS::EC2::Instance.CreditSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder creditSpecification(final software.amazon.awscdk.core.IResolvable creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }
        /**
         * @return {@code this}
         * @param creditSpecification `AWS::EC2::Instance.CreditSpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder creditSpecification(final software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        /**
         * @return {@code this}
         * @param disableApiTermination `AWS::EC2::Instance.DisableApiTermination`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableApiTermination(final java.lang.Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }
        /**
         * @return {@code this}
         * @param disableApiTermination `AWS::EC2::Instance.DisableApiTermination`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder disableApiTermination(final software.amazon.awscdk.core.IResolvable disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        /**
         * @return {@code this}
         * @param ebsOptimized `AWS::EC2::Instance.EbsOptimized`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }
        /**
         * @return {@code this}
         * @param ebsOptimized `AWS::EC2::Instance.EbsOptimized`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ebsOptimized(final software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * @return {@code this}
         * @param elasticGpuSpecifications `AWS::EC2::Instance.ElasticGpuSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticGpuSpecifications(final software.amazon.awscdk.core.IResolvable elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }
        /**
         * @return {@code this}
         * @param elasticGpuSpecifications `AWS::EC2::Instance.ElasticGpuSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticGpuSpecifications(final java.util.List<java.lang.Object> elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        /**
         * @return {@code this}
         * @param elasticInferenceAccelerators `AWS::EC2::Instance.ElasticInferenceAccelerators`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticInferenceAccelerators(final software.amazon.awscdk.core.IResolvable elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }
        /**
         * @return {@code this}
         * @param elasticInferenceAccelerators `AWS::EC2::Instance.ElasticInferenceAccelerators`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder elasticInferenceAccelerators(final java.util.List<java.lang.Object> elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        /**
         * @return {@code this}
         * @param hostId `AWS::EC2::Instance.HostId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder hostId(final java.lang.String hostId) {
            this.props().hostId(hostId);
            return this;
        }

        /**
         * @return {@code this}
         * @param iamInstanceProfile `AWS::EC2::Instance.IamInstanceProfile`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder iamInstanceProfile(final java.lang.String iamInstanceProfile) {
            this.props().iamInstanceProfile(iamInstanceProfile);
            return this;
        }

        /**
         * @return {@code this}
         * @param imageId `AWS::EC2::Instance.ImageId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder imageId(final java.lang.String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        /**
         * @return {@code this}
         * @param instanceInitiatedShutdownBehavior `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceInitiatedShutdownBehavior(final java.lang.String instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        /**
         * @return {@code this}
         * @param instanceType `AWS::EC2::Instance.InstanceType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * @return {@code this}
         * @param ipv6AddressCount `AWS::EC2::Instance.Ipv6AddressCount`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6AddressCount(final java.lang.Number ipv6AddressCount) {
            this.props().ipv6AddressCount(ipv6AddressCount);
            return this;
        }

        /**
         * @return {@code this}
         * @param ipv6Addresses `AWS::EC2::Instance.Ipv6Addresses`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(final software.amazon.awscdk.core.IResolvable ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }
        /**
         * @return {@code this}
         * @param ipv6Addresses `AWS::EC2::Instance.Ipv6Addresses`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(final java.util.List<java.lang.Object> ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        /**
         * @return {@code this}
         * @param kernelId `AWS::EC2::Instance.KernelId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder kernelId(final java.lang.String kernelId) {
            this.props().kernelId(kernelId);
            return this;
        }

        /**
         * @return {@code this}
         * @param keyName `AWS::EC2::Instance.KeyName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keyName(final java.lang.String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        /**
         * @return {@code this}
         * @param launchTemplate `AWS::EC2::Instance.LaunchTemplate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplate(final software.amazon.awscdk.core.IResolvable launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }
        /**
         * @return {@code this}
         * @param launchTemplate `AWS::EC2::Instance.LaunchTemplate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplate(final software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        /**
         * @return {@code this}
         * @param licenseSpecifications `AWS::EC2::Instance.LicenseSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder licenseSpecifications(final software.amazon.awscdk.core.IResolvable licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }
        /**
         * @return {@code this}
         * @param licenseSpecifications `AWS::EC2::Instance.LicenseSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder licenseSpecifications(final java.util.List<java.lang.Object> licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        /**
         * @return {@code this}
         * @param monitoring `AWS::EC2::Instance.Monitoring`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder monitoring(final java.lang.Boolean monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }
        /**
         * @return {@code this}
         * @param monitoring `AWS::EC2::Instance.Monitoring`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder monitoring(final software.amazon.awscdk.core.IResolvable monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        /**
         * @return {@code this}
         * @param networkInterfaces `AWS::EC2::Instance.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaces(final software.amazon.awscdk.core.IResolvable networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }
        /**
         * @return {@code this}
         * @param networkInterfaces `AWS::EC2::Instance.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaces(final java.util.List<java.lang.Object> networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        /**
         * @return {@code this}
         * @param placementGroupName `AWS::EC2::Instance.PlacementGroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder placementGroupName(final java.lang.String placementGroupName) {
            this.props().placementGroupName(placementGroupName);
            return this;
        }

        /**
         * @return {@code this}
         * @param privateIpAddress `AWS::EC2::Instance.PrivateIpAddress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddress(final java.lang.String privateIpAddress) {
            this.props().privateIpAddress(privateIpAddress);
            return this;
        }

        /**
         * @return {@code this}
         * @param ramdiskId `AWS::EC2::Instance.RamdiskId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ramdiskId(final java.lang.String ramdiskId) {
            this.props().ramdiskId(ramdiskId);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroupIds `AWS::EC2::Instance.SecurityGroupIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props().securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroups `AWS::EC2::Instance.SecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * @return {@code this}
         * @param sourceDestCheck `AWS::EC2::Instance.SourceDestCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(final java.lang.Boolean sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }
        /**
         * @return {@code this}
         * @param sourceDestCheck `AWS::EC2::Instance.SourceDestCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(final software.amazon.awscdk.core.IResolvable sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        /**
         * @return {@code this}
         * @param ssmAssociations `AWS::EC2::Instance.SsmAssociations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ssmAssociations(final software.amazon.awscdk.core.IResolvable ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }
        /**
         * @return {@code this}
         * @param ssmAssociations `AWS::EC2::Instance.SsmAssociations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ssmAssociations(final java.util.List<java.lang.Object> ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        /**
         * @return {@code this}
         * @param subnetId `AWS::EC2::Instance.SubnetId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(final java.lang.String subnetId) {
            this.props().subnetId(subnetId);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::EC2::Instance.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @param tenancy `AWS::EC2::Instance.Tenancy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tenancy(final java.lang.String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        /**
         * @return {@code this}
         * @param userData `AWS::EC2::Instance.UserData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder userData(final java.lang.String userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @return {@code this}
         * @param volumes `AWS::EC2::Instance.Volumes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder volumes(final software.amazon.awscdk.core.IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }
        /**
         * @return {@code this}
         * @param volumes `AWS::EC2::Instance.Volumes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder volumes(final java.util.List<java.lang.Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnInstance build() {
            return new software.amazon.awscdk.services.ec2.CfnInstance(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnInstanceProps.Builder();
            }
            return this.props;
        }
    }
}
