package software.amazon.awscdk.services.ec2;

/**
 * Define an AWS Virtual Private Cloud.
 * 
 * See the package-level documentation of this package for an overview
 * of the various dimensions in which you can configure your VPC.
 * 
 * For example:
 * 
 * ```ts
 * import { SubnetType, Vpc } from '@aws-cdk/aws-ec2'
 * 
 * const vpc = new Vpc(this, 'TheVPC', {
 *    cidr: "10.0.0.0/16"
 * })
 * 
 * // Iterate the private subnets
 * const selection = vpc.selectSubnets({
 *    subnetType: SubnetType.PRIVATE
 * });
 * 
 * for (const subnet of selection.subnets) {
 *    // ...
 * }
 * ```
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.3 (build 26aa77c)", date = "2019-11-12T00:10:04.674Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Vpc")
public class Vpc extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IVpc {

    protected Vpc(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Vpc(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_CIDR_RANGE", java.lang.String.class);
        DEFAULT_SUBNETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_SUBNETS", java.util.List.class);
    }

    /**
     * Vpc creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Vpc(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Vpc creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Vpc(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing VPC from by querying the AWS environment this stack is deployed to.
     * 
     * This function only needs to be used to use VPCs not defined in your CDK
     * application. If you are looking to share a VPC between stacks, you can
     * pass the `Vpc` object between stacks and use it as normal.
     * 
     * See the package-level documentation of this package for constraints
     * on importing existing VPCs.
     * 
     * Calling this method will lead to a lookup when the CDK CLI is executed.
     * You can therefore not use any values that will only be available at
     * CloudFormation execution time (i.e., Tokens).
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.IVpc fromLookup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromLookup", software.amazon.awscdk.services.ec2.IVpc.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Import an exported VPC.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.IVpc fromVpcAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromVpcAttributes", software.amazon.awscdk.services.ec2.IVpc.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     * 
     * @deprecated use `addGatewayEndpoint()` instead
     * @param id This parameter is required.
     * @param subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id, final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     * 
     * @deprecated use `addGatewayEndpoint()` instead
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new gateway endpoint to this VPC.
     * 
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addGatewayEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions options) {
        return this.jsiiCall("addGatewayEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new interface endpoint to this VPC.
     * 
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint addInterfaceEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions options) {
        return this.jsiiCall("addInterfaceEndpoint", software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     * 
     * @deprecated use `addGatewayEndpoint()` instead
     * @param id This parameter is required.
     * @param subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id, final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     * 
     * @deprecated use `addGatewayEndpoint()` instead
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new VPN connection to this VPC.
     * 
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.VpnConnection addVpnConnection(final java.lang.String id, final software.amazon.awscdk.services.ec2.VpnConnectionOptions options) {
        return this.jsiiCall("addVpnConnection", software.amazon.awscdk.services.ec2.VpnConnection.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     * 
     * @param selection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects(final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return java.util.Collections.unmodifiableList(this.jsiiCall("selectSubnetObjects", java.util.List.class, new Object[] { selection }));
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("selectSubnetObjects", java.util.List.class));
    }

    /**
     * Returns IDs of selected subnets.
     * 
     * @param selection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class, new Object[] { selection });
    }

    /**
     * Returns IDs of selected subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets() {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class);
    }

    /**
     * The default CIDR range used when creating VPCs. This can be overridden using VpcProps when creating a VPCNetwork resource. e.g. new VpcResource(this, { cidr: '192.168.0.0./16' }).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_CIDR_RANGE;

    /**
     * The default subnet configuration.
     * 
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * AZs for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("availabilityZones", java.util.List.class));
    }

    /**
     * Dependencies for internet connectivity.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
        return this.jsiiGet("internetConnectivityEstablished", software.amazon.awscdk.core.IDependable.class);
    }

    /**
     * List of isolated subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getIsolatedSubnets() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("isolatedSubnets", java.util.List.class));
    }

    /**
     * Dependencies for NAT connectivity.
     * 
     * @deprecated - This value is no longer used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected java.util.List<software.amazon.awscdk.core.IConstruct> getNatDependencies() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("natDependencies", java.util.List.class));
    }

    /**
     * List of private subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPrivateSubnets() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("privateSubnets", java.util.List.class));
    }

    /**
     * List of public subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPublicSubnets() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("publicSubnets", java.util.List.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcCidrBlock() {
        return this.jsiiGet("vpcCidrBlock", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getVpcCidrBlockAssociations() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("vpcCidrBlockAssociations", java.util.List.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcDefaultNetworkAcl() {
        return this.jsiiGet("vpcDefaultNetworkAcl", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcDefaultSecurityGroup() {
        return this.jsiiGet("vpcDefaultSecurityGroup", java.lang.String.class);
    }

    /**
     * Identifier for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getVpcIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("vpcIpv6CidrBlocks", java.util.List.class));
    }

    /**
     * Identifier for the VPN gateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpnGatewayId() {
        return this.jsiiGet("vpnGatewayId", java.lang.String.class);
    }

    /**
     * If this is set to true, don't error out on trying to select subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getIncompleteSubnetDefinition() {
        return this.jsiiGet("incompleteSubnetDefinition", java.lang.Boolean.class);
    }

    /**
     * If this is set to true, don't error out on trying to select subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIncompleteSubnetDefinition(final java.lang.Boolean value) {
        this.jsiiSet("incompleteSubnetDefinition", java.util.Objects.requireNonNull(value, "incompleteSubnetDefinition is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Vpc}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.VpcProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param cidr The CIDR range to use for the VPC, e.g. '10.0.0.0/16'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(final java.lang.String cidr) {
            this.props().cidr(cidr);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultInstanceTenancy The default tenancy of instances launched into the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceTenancy(final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy) {
            this.props().defaultInstanceTenancy(defaultInstanceTenancy);
            return this;
        }

        /**
         * @return {@code this}
         * @param enableDnsHostnames Indicates whether the instances launched in the VPC get public DNS hostnames. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsHostnames(final java.lang.Boolean enableDnsHostnames) {
            this.props().enableDnsHostnames(enableDnsHostnames);
            return this;
        }

        /**
         * @return {@code this}
         * @param enableDnsSupport Indicates whether the DNS resolution is supported for the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsSupport(final java.lang.Boolean enableDnsSupport) {
            this.props().enableDnsSupport(enableDnsSupport);
            return this;
        }

        /**
         * @return {@code this}
         * @param gatewayEndpoints Gateway endpoints to add to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayEndpoints(final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.props().gatewayEndpoints(gatewayEndpoints);
            return this;
        }

        /**
         * @return {@code this}
         * @param maxAzs Define the maximum number of AZs to use in this region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAzs(final java.lang.Number maxAzs) {
            this.props().maxAzs(maxAzs);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param natGatewayProvider What type of NAT provider to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder natGatewayProvider(final software.amazon.awscdk.services.ec2.NatProvider natGatewayProvider) {
            this.props().natGatewayProvider(natGatewayProvider);
            return this;
        }

        /**
         * @return {@code this}
         * @param natGateways The number of NAT Gateways/Instances to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGateways(final java.lang.Number natGateways) {
            this.props().natGateways(natGateways);
            return this;
        }

        /**
         * @return {@code this}
         * @param natGatewaySubnets Configures the subnets which will have NAT Gateways/Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewaySubnets(final software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets) {
            this.props().natGatewaySubnets(natGatewaySubnets);
            return this;
        }

        /**
         * @return {@code this}
         * @param subnetConfiguration Configure the subnets to build for each AZ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetConfiguration(final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration) {
            this.props().subnetConfiguration(subnetConfiguration);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpnConnections VPN connections to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnConnections(final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections) {
            this.props().vpnConnections(vpnConnections);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpnGateway Indicates whether a VPN gateway should be created and attached to this VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGateway(final java.lang.Boolean vpnGateway) {
            this.props().vpnGateway(vpnGateway);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpnGatewayAsn The private Autonomous System Number (ASN) for the VPN gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayAsn(final java.lang.Number vpnGatewayAsn) {
            this.props().vpnGatewayAsn(vpnGatewayAsn);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpnRoutePropagation Where to propagate VPN routes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnRoutePropagation(final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation) {
            this.props().vpnRoutePropagation(vpnRoutePropagation);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Vpc}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Vpc build() {
            return new software.amazon.awscdk.services.ec2.Vpc(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.VpcProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.VpcProps.Builder();
            }
            return this.props;
        }
    }
}
