package software.amazon.awscdk.services.ec2;

/**
 * Properties for looking up an existing VPC.
 * 
 * The combination of properties must specify filter down to exactly one
 * non-default VPC, otherwise an error is raised.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:44.627Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcLookupOptions")
@software.amazon.jsii.Jsii.Proxy(VpcLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to match the default VPC.
     * 
     * Default: Don't care whether we return the default VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getIsDefault() {
        return null;
    }

    /**
     * Optional tag for subnet group name. If not provided, we'll look at the aws-cdk:subnet-name tag. If the subnet does not have the specified tag, we'll use its type as the name.
     * 
     * Default: aws-cdk:subnet-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getSubnetGroupNameTag() {
        return null;
    }

    /**
     * Tags on the VPC.
     * 
     * The VPC must have all of these tags
     * 
     * Default: Don't filter on tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The ID of the VPC.
     * 
     * If given, will import exactly this VPC.
     * 
     * Default: Don't filter on vpcId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getVpcId() {
        return null;
    }

    /**
     * The name of the VPC.
     * 
     * If given, will import the VPC with this name.
     * 
     * Default: Don't filter on vpcName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getVpcName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean isDefault;
        private java.lang.String subnetGroupNameTag;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private java.lang.String vpcId;
        private java.lang.String vpcName;

        /**
         * Sets the value of IsDefault
         * @param isDefault Whether to match the default VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDefault(java.lang.Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        /**
         * Sets the value of SubnetGroupNameTag
         * @param subnetGroupNameTag Optional tag for subnet group name. If not provided, we'll look at the aws-cdk:subnet-name tag. If the subnet does not have the specified tag, we'll use its type as the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupNameTag(java.lang.String subnetGroupNameTag) {
            this.subnetGroupNameTag = subnetGroupNameTag;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags Tags on the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId The ID of the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of VpcName
         * @param vpcName The name of the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcName(java.lang.String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcLookupOptions build() {
            return new Jsii$Proxy(isDefault, subnetGroupNameTag, tags, vpcId, vpcName);
        }
    }

    /**
     * An implementation for {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcLookupOptions {
        private final java.lang.Boolean isDefault;
        private final java.lang.String subnetGroupNameTag;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String vpcId;
        private final java.lang.String vpcName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.isDefault = this.jsiiGet("isDefault", java.lang.Boolean.class);
            this.subnetGroupNameTag = this.jsiiGet("subnetGroupNameTag", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.Map.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.vpcName = this.jsiiGet("vpcName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean isDefault, final java.lang.String subnetGroupNameTag, final java.util.Map<java.lang.String, java.lang.String> tags, final java.lang.String vpcId, final java.lang.String vpcName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.isDefault = isDefault;
            this.subnetGroupNameTag = subnetGroupNameTag;
            this.tags = tags;
            this.vpcId = vpcId;
            this.vpcName = vpcName;
        }

        @Override
        public java.lang.Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public java.lang.String getSubnetGroupNameTag() {
            return this.subnetGroupNameTag;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.String getVpcName() {
            return this.vpcName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIsDefault() != null) {
                data.set("isDefault", om.valueToTree(this.getIsDefault()));
            }
            if (this.getSubnetGroupNameTag() != null) {
                data.set("subnetGroupNameTag", om.valueToTree(this.getSubnetGroupNameTag()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            if (this.getVpcName() != null) {
                data.set("vpcName", om.valueToTree(this.getVpcName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcLookupOptions.Jsii$Proxy that = (VpcLookupOptions.Jsii$Proxy) o;

            if (this.isDefault != null ? !this.isDefault.equals(that.isDefault) : that.isDefault != null) return false;
            if (this.subnetGroupNameTag != null ? !this.subnetGroupNameTag.equals(that.subnetGroupNameTag) : that.subnetGroupNameTag != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
            return this.vpcName != null ? this.vpcName.equals(that.vpcName) : that.vpcName == null;
        }

        @Override
        public int hashCode() {
            int result = this.isDefault != null ? this.isDefault.hashCode() : 0;
            result = 31 * result + (this.subnetGroupNameTag != null ? this.subnetGroupNameTag.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            result = 31 * result + (this.vpcName != null ? this.vpcName.hashCode() : 0);
            return result;
        }
    }
}
