package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::TrafficMirrorFilterRule`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:17.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTrafficMirrorFilterRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficMirrorFilterRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnTrafficMirrorFilterRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationCidrBlock();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleAction`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRuleAction();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getRuleNumber();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSourceCidrBlock();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTrafficDirection();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTrafficMirrorFilterId();

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getDestinationPortRange() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getProtocol() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getSourcePortRange() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficMirrorFilterRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficMirrorFilterRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String destinationCidrBlock;
        private java.lang.String ruleAction;
        private java.lang.Number ruleNumber;
        private java.lang.String sourceCidrBlock;
        private java.lang.String trafficDirection;
        private java.lang.String trafficMirrorFilterId;
        private java.lang.String description;
        private java.lang.Object destinationPortRange;
        private java.lang.Number protocol;
        private java.lang.Object sourcePortRange;

        /**
         * Sets the value of DestinationCidrBlock
         * @param destinationCidrBlock `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of RuleAction
         * @param ruleAction `AWS::EC2::TrafficMirrorFilterRule.RuleAction`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ruleAction(java.lang.String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        /**
         * Sets the value of RuleNumber
         * @param ruleNumber `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ruleNumber(java.lang.Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        /**
         * Sets the value of SourceCidrBlock
         * @param sourceCidrBlock `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceCidrBlock(java.lang.String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        /**
         * Sets the value of TrafficDirection
         * @param trafficDirection `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder trafficDirection(java.lang.String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        /**
         * Sets the value of TrafficMirrorFilterId
         * @param trafficMirrorFilterId `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder trafficMirrorFilterId(java.lang.String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::EC2::TrafficMirrorFilterRule.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DestinationPortRange
         * @param destinationPortRange `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationPortRange(software.amazon.awscdk.core.IResolvable destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        /**
         * Sets the value of DestinationPortRange
         * @param destinationPortRange `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationPortRange(software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder protocol(java.lang.Number protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of SourcePortRange
         * @param sourcePortRange `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourcePortRange(software.amazon.awscdk.core.IResolvable sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        /**
         * Sets the value of SourcePortRange
         * @param sourcePortRange `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourcePortRange(software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficMirrorFilterRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnTrafficMirrorFilterRuleProps build() {
            return new Jsii$Proxy(destinationCidrBlock, ruleAction, ruleNumber, sourceCidrBlock, trafficDirection, trafficMirrorFilterId, description, destinationPortRange, protocol, sourcePortRange);
        }
    }

    /**
     * An implementation for {@link CfnTrafficMirrorFilterRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficMirrorFilterRuleProps {
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String ruleAction;
        private final java.lang.Number ruleNumber;
        private final java.lang.String sourceCidrBlock;
        private final java.lang.String trafficDirection;
        private final java.lang.String trafficMirrorFilterId;
        private final java.lang.String description;
        private final java.lang.Object destinationPortRange;
        private final java.lang.Number protocol;
        private final java.lang.Object sourcePortRange;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationCidrBlock = this.jsiiGet("destinationCidrBlock", java.lang.String.class);
            this.ruleAction = this.jsiiGet("ruleAction", java.lang.String.class);
            this.ruleNumber = this.jsiiGet("ruleNumber", java.lang.Number.class);
            this.sourceCidrBlock = this.jsiiGet("sourceCidrBlock", java.lang.String.class);
            this.trafficDirection = this.jsiiGet("trafficDirection", java.lang.String.class);
            this.trafficMirrorFilterId = this.jsiiGet("trafficMirrorFilterId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.destinationPortRange = this.jsiiGet("destinationPortRange", java.lang.Object.class);
            this.protocol = this.jsiiGet("protocol", java.lang.Number.class);
            this.sourcePortRange = this.jsiiGet("sourcePortRange", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String destinationCidrBlock, final java.lang.String ruleAction, final java.lang.Number ruleNumber, final java.lang.String sourceCidrBlock, final java.lang.String trafficDirection, final java.lang.String trafficMirrorFilterId, final java.lang.String description, final java.lang.Object destinationPortRange, final java.lang.Number protocol, final java.lang.Object sourcePortRange) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationCidrBlock = java.util.Objects.requireNonNull(destinationCidrBlock, "destinationCidrBlock is required");
            this.ruleAction = java.util.Objects.requireNonNull(ruleAction, "ruleAction is required");
            this.ruleNumber = java.util.Objects.requireNonNull(ruleNumber, "ruleNumber is required");
            this.sourceCidrBlock = java.util.Objects.requireNonNull(sourceCidrBlock, "sourceCidrBlock is required");
            this.trafficDirection = java.util.Objects.requireNonNull(trafficDirection, "trafficDirection is required");
            this.trafficMirrorFilterId = java.util.Objects.requireNonNull(trafficMirrorFilterId, "trafficMirrorFilterId is required");
            this.description = description;
            this.destinationPortRange = destinationPortRange;
            this.protocol = protocol;
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public java.lang.String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public java.lang.Number getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public java.lang.String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        @Override
        public java.lang.String getTrafficDirection() {
            return this.trafficDirection;
        }

        @Override
        public java.lang.String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Object getDestinationPortRange() {
            return this.destinationPortRange;
        }

        @Override
        public java.lang.Number getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.Object getSourcePortRange() {
            return this.sourcePortRange;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            data.set("ruleAction", om.valueToTree(this.getRuleAction()));
            data.set("ruleNumber", om.valueToTree(this.getRuleNumber()));
            data.set("sourceCidrBlock", om.valueToTree(this.getSourceCidrBlock()));
            data.set("trafficDirection", om.valueToTree(this.getTrafficDirection()));
            data.set("trafficMirrorFilterId", om.valueToTree(this.getTrafficMirrorFilterId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDestinationPortRange() != null) {
                data.set("destinationPortRange", om.valueToTree(this.getDestinationPortRange()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSourcePortRange() != null) {
                data.set("sourcePortRange", om.valueToTree(this.getSourcePortRange()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTrafficMirrorFilterRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficMirrorFilterRuleProps.Jsii$Proxy that = (CfnTrafficMirrorFilterRuleProps.Jsii$Proxy) o;

            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            if (!ruleAction.equals(that.ruleAction)) return false;
            if (!ruleNumber.equals(that.ruleNumber)) return false;
            if (!sourceCidrBlock.equals(that.sourceCidrBlock)) return false;
            if (!trafficDirection.equals(that.trafficDirection)) return false;
            if (!trafficMirrorFilterId.equals(that.trafficMirrorFilterId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.destinationPortRange != null ? !this.destinationPortRange.equals(that.destinationPortRange) : that.destinationPortRange != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sourcePortRange != null ? this.sourcePortRange.equals(that.sourcePortRange) : that.sourcePortRange == null;
        }

        @Override
        public int hashCode() {
            int result = this.destinationCidrBlock.hashCode();
            result = 31 * result + (this.ruleAction.hashCode());
            result = 31 * result + (this.ruleNumber.hashCode());
            result = 31 * result + (this.sourceCidrBlock.hashCode());
            result = 31 * result + (this.trafficDirection.hashCode());
            result = 31 * result + (this.trafficMirrorFilterId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.destinationPortRange != null ? this.destinationPortRange.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sourcePortRange != null ? this.sourcePortRange.hashCode() : 0);
            return result;
        }
    }
}
