package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:17.483Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServiceName();

    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcId();

    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getPolicyDocument() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getPrivateDnsEnabled() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<java.lang.String> getRouteTableIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getVpcEndpointType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String serviceName;
        private java.lang.String vpcId;
        private java.lang.Object policyDocument;
        private java.lang.Object privateDnsEnabled;
        private java.util.List<java.lang.String> routeTableIds;
        private java.util.List<java.lang.String> securityGroupIds;
        private java.util.List<java.lang.String> subnetIds;
        private java.lang.String vpcEndpointType;

        /**
         * Sets the value of ServiceName
         * @param serviceName `AWS::EC2::VPCEndpoint.ServiceName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId `AWS::EC2::VPCEndpoint.VpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of PolicyDocument
         * @param policyDocument `AWS::EC2::VPCEndpoint.PolicyDocument`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of PrivateDnsEnabled
         * @param privateDnsEnabled `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of PrivateDnsEnabled
         * @param privateDnsEnabled `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateDnsEnabled(software.amazon.awscdk.core.IResolvable privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of RouteTableIds
         * @param routeTableIds `AWS::EC2::VPCEndpoint.RouteTableIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
            this.routeTableIds = routeTableIds;
            return this;
        }

        /**
         * Sets the value of SecurityGroupIds
         * @param securityGroupIds `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of SubnetIds
         * @param subnetIds `AWS::EC2::VPCEndpoint.SubnetIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of VpcEndpointType
         * @param vpcEndpointType `AWS::EC2::VPCEndpoint.VpcEndpointType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcEndpointType(java.lang.String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCEndpointProps build() {
            return new Jsii$Proxy(serviceName, vpcId, policyDocument, privateDnsEnabled, routeTableIds, securityGroupIds, subnetIds, vpcEndpointType);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointProps {
        private final java.lang.String serviceName;
        private final java.lang.String vpcId;
        private final java.lang.Object policyDocument;
        private final java.lang.Object privateDnsEnabled;
        private final java.util.List<java.lang.String> routeTableIds;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String vpcEndpointType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.policyDocument = this.jsiiGet("policyDocument", java.lang.Object.class);
            this.privateDnsEnabled = this.jsiiGet("privateDnsEnabled", java.lang.Object.class);
            this.routeTableIds = this.jsiiGet("routeTableIds", java.util.List.class);
            this.securityGroupIds = this.jsiiGet("securityGroupIds", java.util.List.class);
            this.subnetIds = this.jsiiGet("subnetIds", java.util.List.class);
            this.vpcEndpointType = this.jsiiGet("vpcEndpointType", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String serviceName, final java.lang.String vpcId, final java.lang.Object policyDocument, final java.lang.Object privateDnsEnabled, final java.util.List<java.lang.String> routeTableIds, final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> subnetIds, final java.lang.String vpcEndpointType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceName = java.util.Objects.requireNonNull(serviceName, "serviceName is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.policyDocument = policyDocument;
            this.privateDnsEnabled = privateDnsEnabled;
            this.routeTableIds = routeTableIds;
            this.securityGroupIds = securityGroupIds;
            this.subnetIds = subnetIds;
            this.vpcEndpointType = vpcEndpointType;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public java.lang.Object getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public java.util.List<java.lang.String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public java.lang.String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceName", om.valueToTree(this.getServiceName()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getRouteTableIds() != null) {
                data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getVpcEndpointType() != null) {
                data.set("vpcEndpointType", om.valueToTree(this.getVpcEndpointType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointProps.Jsii$Proxy that = (CfnVPCEndpointProps.Jsii$Proxy) o;

            if (!serviceName.equals(that.serviceName)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.routeTableIds != null ? !this.routeTableIds.equals(that.routeTableIds) : that.routeTableIds != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            return this.vpcEndpointType != null ? this.vpcEndpointType.equals(that.vpcEndpointType) : that.vpcEndpointType == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceName.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.routeTableIds != null ? this.routeTableIds.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointType != null ? this.vpcEndpointType.hashCode() : 0);
            return result;
        }
    }
}
