package software.amazon.awscdk.services.ec2;

/**
 * Select the latest version of the indicated Windows version.
 * 
 * The AMI ID is selected using the values published to the SSM parameter store.
 * 
 * https://aws.amazon.com/blogs/mt/query-for-the-latest-windows-ami-using-systems-manager-parameter-store/
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:17.535Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.WindowsImage")
public class WindowsImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected WindowsImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WindowsImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param version This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WindowsImage(final software.amazon.awscdk.services.ec2.WindowsVersion version, final software.amazon.awscdk.services.ec2.WindowsImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required"), props });
    }

    /**
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WindowsImage(final software.amazon.awscdk.services.ec2.WindowsVersion version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Return the image to use in the given context.
     * 
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final software.amazon.awscdk.core.Construct scope) {
        return this.jsiiCall("getImage", software.amazon.awscdk.services.ec2.MachineImageConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.WindowsImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param version This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ec2.WindowsVersion version) {
            return new Builder(version);
        }

        private final software.amazon.awscdk.services.ec2.WindowsVersion version;
        private software.amazon.awscdk.services.ec2.WindowsImageProps.Builder props;

        private Builder(final software.amazon.awscdk.services.ec2.WindowsVersion version) {
            this.version = version;
        }

        /**
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.WindowsImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.WindowsImage build() {
            return new software.amazon.awscdk.services.ec2.WindowsImage(
                this.version,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.WindowsImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.WindowsImageProps.Builder();
            }
            return this.props;
        }
    }
}
