package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux image properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecurityGroup sg = SecurityGroup.fromSecurityGroupId(this, "FsxSecurityGroup", "{SECURITY-GROUP-ID}");
 * IFileSystem fs = LustreFileSystem.fromLustreFileSystemAttributes(this, "FsxLustreFileSystem", FileSystemAttributes.builder()
 *         .dnsName("{FILE-SYSTEM-DNS-NAME}")
 *         .fileSystemId("{FILE-SYSTEM-ID}")
 *         .securityGroup(sg)
 *         .build());
 * IVpc vpc = Vpc.fromVpcAttributes(this, "Vpc", VpcAttributes.builder()
 *         .availabilityZones(List.of("us-west-2a", "us-west-2b"))
 *         .publicSubnetIds(List.of("{US-WEST-2A-SUBNET-ID}", "{US-WEST-2B-SUBNET-ID}"))
 *         .vpcId("{VPC-ID}")
 *         .build());
 * Instance inst = Instance.Builder.create(this, "inst")
 *         .instanceType(InstanceType.of(InstanceClass.T2, InstanceSize.LARGE))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .build();
 * fs.connections.allowDefaultPortFrom(inst);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-06-14T14:06:35.429Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AmazonLinuxImageProps")
@software.amazon.jsii.Jsii.Proxy(AmazonLinuxImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AmazonLinuxImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the AMI ID is cached to be stable between deployments.
     * <p>
     * By default, the newest image is used on each deployment. This will cause
     * instances to be replaced whenever a new version is released, and may cause
     * downtime if there aren't enough running instances in the AutoScalingGroup
     * to reschedule the tasks on.
     * <p>
     * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
     * same value will be used on future runs. Your instances will not be replaced
     * but your AMI version will grow old over time. To refresh the AMI lookup,
     * you will have to evict the value from the cache using the <code>cdk context</code>
     * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
     * more information.
     * <p>
     * Can not be set to <code>true</code> in environment-agnostic stacks.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCachedInContext() {
        return null;
    }

    /**
     * CPU Type.
     * <p>
     * Default: X86_64
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxCpuType getCpuType() {
        return null;
    }

    /**
     * What edition of Amazon Linux to use.
     * <p>
     * Default: Standard
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
        return null;
    }

    /**
     * What generation of Amazon Linux to use.
     * <p>
     * Default: AmazonLinux
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
        return null;
    }

    /**
     * What kernel version of Amazon Linux to use.
     * <p>
     * Default: -
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxKernel getKernel() {
        return null;
    }

    /**
     * What storage backed image to use.
     * <p>
     * Default: GeneralPurpose
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
        return null;
    }

    /**
     * Initial user data.
     * <p>
     * Default: - Empty UserData for Linux machines
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * Virtualization type.
     * <p>
     * Default: HVM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AmazonLinuxImageProps> {
        java.lang.Boolean cachedInContext;
        software.amazon.awscdk.services.ec2.AmazonLinuxCpuType cpuType;
        software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition;
        software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation;
        software.amazon.awscdk.services.ec2.AmazonLinuxKernel kernel;
        software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage;
        software.amazon.awscdk.services.ec2.UserData userData;
        software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization;

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getCachedInContext}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments.
         *                        By default, the newest image is used on each deployment. This will cause
         *                        instances to be replaced whenever a new version is released, and may cause
         *                        downtime if there aren't enough running instances in the AutoScalingGroup
         *                        to reschedule the tasks on.
         *                        <p>
         *                        If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         *                        same value will be used on future runs. Your instances will not be replaced
         *                        but your AMI version will grow old over time. To refresh the AMI lookup,
         *                        you will have to evict the value from the cache using the <code>cdk context</code>
         *                        command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         *                        more information.
         *                        <p>
         *                        Can not be set to <code>true</code> in environment-agnostic stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(java.lang.Boolean cachedInContext) {
            this.cachedInContext = cachedInContext;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getCpuType}
         * @param cpuType CPU Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuType(software.amazon.awscdk.services.ec2.AmazonLinuxCpuType cpuType) {
            this.cpuType = cpuType;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getEdition}
         * @param edition What edition of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition) {
            this.edition = edition;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getGeneration}
         * @param generation What generation of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generation(software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation) {
            this.generation = generation;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getKernel}
         * @param kernel What kernel version of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernel(software.amazon.awscdk.services.ec2.AmazonLinuxKernel kernel) {
            this.kernel = kernel;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getStorage}
         * @param storage What storage backed image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage) {
            this.storage = storage;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getUserData}
         * @param userData Initial user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getVirtualization}
         * @param virtualization Virtualization type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualization(software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            this.virtualization = virtualization;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AmazonLinuxImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonLinuxImageProps {
        private final java.lang.Boolean cachedInContext;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxCpuType cpuType;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxKernel kernel;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cachedInContext = software.amazon.jsii.Kernel.get(this, "cachedInContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cpuType = software.amazon.jsii.Kernel.get(this, "cpuType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxCpuType.class));
            this.edition = software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class));
            this.generation = software.amazon.jsii.Kernel.get(this, "generation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class));
            this.kernel = software.amazon.jsii.Kernel.get(this, "kernel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxKernel.class));
            this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.virtualization = software.amazon.jsii.Kernel.get(this, "virtualization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cachedInContext = builder.cachedInContext;
            this.cpuType = builder.cpuType;
            this.edition = builder.edition;
            this.generation = builder.generation;
            this.kernel = builder.kernel;
            this.storage = builder.storage;
            this.userData = builder.userData;
            this.virtualization = builder.virtualization;
        }

        @Override
        public final java.lang.Boolean getCachedInContext() {
            return this.cachedInContext;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxCpuType getCpuType() {
            return this.cpuType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this.edition;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
            return this.generation;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxKernel getKernel() {
            return this.kernel;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this.storage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this.virtualization;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCachedInContext() != null) {
                data.set("cachedInContext", om.valueToTree(this.getCachedInContext()));
            }
            if (this.getCpuType() != null) {
                data.set("cpuType", om.valueToTree(this.getCpuType()));
            }
            if (this.getEdition() != null) {
                data.set("edition", om.valueToTree(this.getEdition()));
            }
            if (this.getGeneration() != null) {
                data.set("generation", om.valueToTree(this.getGeneration()));
            }
            if (this.getKernel() != null) {
                data.set("kernel", om.valueToTree(this.getKernel()));
            }
            if (this.getStorage() != null) {
                data.set("storage", om.valueToTree(this.getStorage()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVirtualization() != null) {
                data.set("virtualization", om.valueToTree(this.getVirtualization()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.AmazonLinuxImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AmazonLinuxImageProps.Jsii$Proxy that = (AmazonLinuxImageProps.Jsii$Proxy) o;

            if (this.cachedInContext != null ? !this.cachedInContext.equals(that.cachedInContext) : that.cachedInContext != null) return false;
            if (this.cpuType != null ? !this.cpuType.equals(that.cpuType) : that.cpuType != null) return false;
            if (this.edition != null ? !this.edition.equals(that.edition) : that.edition != null) return false;
            if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) return false;
            if (this.kernel != null ? !this.kernel.equals(that.kernel) : that.kernel != null) return false;
            if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.virtualization != null ? this.virtualization.equals(that.virtualization) : that.virtualization == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cachedInContext != null ? this.cachedInContext.hashCode() : 0;
            result = 31 * result + (this.cpuType != null ? this.cpuType.hashCode() : 0);
            result = 31 * result + (this.edition != null ? this.edition.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            result = 31 * result + (this.kernel != null ? this.kernel.hashCode() : 0);
            result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.virtualization != null ? this.virtualization.hashCode() : 0);
            return result;
        }
    }
}
