package software.amazon.awscdk.services.ec2;

/**
 * Options for creating {@link MultipartUserData}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * MultipartUserDataOptions multipartUserDataOptions = MultipartUserDataOptions.builder()
 *         .partsSeparator("partsSeparator")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-06-22T23:27:55.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.MultipartUserDataOptions")
@software.amazon.jsii.Jsii.Proxy(MultipartUserDataOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultipartUserDataOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The string used to separate parts in multipart user data archive (it's like MIME boundary).
     * <p>
     * This string should contain [a-zA-Z0-9()+,-./:=?] characters only, and should not be present in any part, or in text content of archive.
     * <p>
     * Default: `+AWS+CDK+User+Data+Separator==`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPartsSeparator() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MultipartUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultipartUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultipartUserDataOptions> {
        java.lang.String partsSeparator;

        /**
         * Sets the value of {@link MultipartUserDataOptions#getPartsSeparator}
         * @param partsSeparator The string used to separate parts in multipart user data archive (it's like MIME boundary).
         *                       This string should contain [a-zA-Z0-9()+,-./:=?] characters only, and should not be present in any part, or in text content of archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partsSeparator(java.lang.String partsSeparator) {
            this.partsSeparator = partsSeparator;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultipartUserDataOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultipartUserDataOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultipartUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultipartUserDataOptions {
        private final java.lang.String partsSeparator;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partsSeparator = software.amazon.jsii.Kernel.get(this, "partsSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partsSeparator = builder.partsSeparator;
        }

        @Override
        public final java.lang.String getPartsSeparator() {
            return this.partsSeparator;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPartsSeparator() != null) {
                data.set("partsSeparator", om.valueToTree(this.getPartsSeparator()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.MultipartUserDataOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultipartUserDataOptions.Jsii$Proxy that = (MultipartUserDataOptions.Jsii$Proxy) o;

            return this.partsSeparator != null ? this.partsSeparator.equals(that.partsSeparator) : that.partsSeparator == null;
        }

        @Override
        public final int hashCode() {
            int result = this.partsSeparator != null ? this.partsSeparator.hashCode() : 0;
            return result;
        }
    }
}
