package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::FlowLog`.
 * <p>
 * Specifies a VPC flow log that captures IP traffic for a specified network interface, subnet, or VPC. To view the log data, use Amazon CloudWatch Logs (CloudWatch Logs) to help troubleshoot connection issues. For example, you can use a flow log to investigate why certain traffic isn't reaching an instance, which can help you diagnose overly restrictive security group rules. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs</a> in the <em>Amazon VPC User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object destinationOptions;
 * CfnFlowLog cfnFlowLog = CfnFlowLog.Builder.create(this, "MyCfnFlowLog")
 *         .resourceId("resourceId")
 *         .resourceType("resourceType")
 *         .trafficType("trafficType")
 *         // the properties below are optional
 *         .deliverLogsPermissionArn("deliverLogsPermissionArn")
 *         .destinationOptions(destinationOptions)
 *         .logDestination("logDestination")
 *         .logDestinationType("logDestinationType")
 *         .logFormat("logFormat")
 *         .logGroupName("logGroupName")
 *         .maxAggregationInterval(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-01T09:58:35.641Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLog")
public class CfnFlowLog extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFlowLog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowLog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnFlowLog.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::FlowLog`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowLog(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnFlowLogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the flow log.
     * <p>
     * For example, <code>fl-123456abc123abc1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to apply to the flow logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDestinationOptions() {
        return software.amazon.jsii.Kernel.get(this, "destinationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationOptions(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "destinationOptions", java.util.Objects.requireNonNull(value, "destinationOptions is required"));
    }

    /**
     * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * The type of resource for which to create the flow log.
     * <p>
     * For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource for which to create the flow log.
     * <p>
     * For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
    }

    /**
     * The type of traffic to log.
     * <p>
     * You can log traffic that the resource accepts or rejects, or all traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTrafficType() {
        return software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of traffic to log.
     * <p>
     * You can log traffic that the resource accepts or rejects, or all traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trafficType", java.util.Objects.requireNonNull(value, "trafficType is required"));
    }

    /**
     * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return software.amazon.jsii.Kernel.get(this, "deliverLogsPermissionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliverLogsPermissionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliverLogsPermissionArn", value);
    }

    /**
     * The destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code> .
     * <p>
     * If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code> , specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code> , specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code> . Alternatively, use <code>LogGroupName</code> instead.
     * <p>
     * If LogDestinationType is <code>s3</code> , specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code> . For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code> , use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code> . You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code> .
     * <p>
     * If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code> , specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code> , specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code> . Alternatively, use <code>LogGroupName</code> instead.
     * <p>
     * If LogDestinationType is <code>s3</code> , specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code> . For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code> , use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code> . You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestination(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logDestination", value);
    }

    /**
     * The type of destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code> . To publish flow log data to Amazon S3, specify <code>s3</code> .
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code> . To publish flow log data to Amazon S3, specify <code>s3</code> .
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestinationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logDestinationType", value);
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> . If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
        return software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> . If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogFormat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logFormat", value);
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logGroupName", value);
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
        return software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxAggregationInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxAggregationInterval", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnFlowLog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnFlowLog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnFlowLogProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnFlowLogProps.Builder();
        }

        /**
         * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
         * <p>
         * @return {@code this}
         * @param resourceId The ID of the subnet, network interface, or VPC for which you want to create a flow log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The type of resource for which to create the flow log.
         * <p>
         * For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.
         * <p>
         * @return {@code this}
         * @param resourceType The type of resource for which to create the flow log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The type of traffic to log.
         * <p>
         * You can log traffic that the resource accepts or rejects, or all traffic.
         * <p>
         * @return {@code this}
         * @param trafficType The type of traffic to log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(final java.lang.String trafficType) {
            this.props.trafficType(trafficType);
            return this;
        }

        /**
         * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         * <p>
         * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         * <p>
         * @return {@code this}
         * @param deliverLogsPermissionArn The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(final java.lang.String deliverLogsPermissionArn) {
            this.props.deliverLogsPermissionArn(deliverLogsPermissionArn);
            return this;
        }

        /**
         * The destination options. The following options are supported:.
         * <p>
         * <ul>
         * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
         * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param destinationOptions The destination options. The following options are supported:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationOptions(final java.lang.Object destinationOptions) {
            this.props.destinationOptions(destinationOptions);
            return this;
        }

        /**
         * The destination to which the flow log data is to be published.
         * <p>
         * Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code> .
         * <p>
         * If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code> , specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code> , specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code> . Alternatively, use <code>LogGroupName</code> instead.
         * <p>
         * If LogDestinationType is <code>s3</code> , specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code> . For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code> , use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code> . You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.
         * <p>
         * @return {@code this}
         * @param logDestination The destination to which the flow log data is to be published. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(final java.lang.String logDestination) {
            this.props.logDestination(logDestination);
            return this;
        }

        /**
         * The type of destination to which the flow log data is to be published.
         * <p>
         * Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code> . To publish flow log data to Amazon S3, specify <code>s3</code> .
         * <p>
         * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         * <p>
         * Default: <code>cloud-watch-logs</code>
         * <p>
         * @return {@code this}
         * @param logDestinationType The type of destination to which the flow log data is to be published. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(final java.lang.String logDestinationType) {
            this.props.logDestinationType(logDestinationType);
            return this;
        }

        /**
         * The fields to include in the flow log record, in the order in which they should appear.
         * <p>
         * For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> . If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
         * <p>
         * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
         * <p>
         * @return {@code this}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(final java.lang.String logFormat) {
            this.props.logFormat(logFormat);
            return this;
        }

        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         * <p>
         * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         * <p>
         * @return {@code this}
         * @param logGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props.logGroupName(logGroupName);
            return this;
        }

        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         * <p>
         * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         * <p>
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         * <p>
         * Default: 600
         * <p>
         * @return {@code this}
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(final java.lang.Number maxAggregationInterval) {
            this.props.maxAggregationInterval(maxAggregationInterval);
            return this;
        }

        /**
         * The tags to apply to the flow logs.
         * <p>
         * @return {@code this}
         * @param tags The tags to apply to the flow logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnFlowLog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnFlowLog build() {
            return new software.amazon.awscdk.services.ec2.CfnFlowLog(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
