package software.amazon.awscdk.services.ec2;

/**
 * Create files on the EC2 instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .init(CloudFormationInit.fromElements(InitFile.fromString("/etc/my_instance", "This got written during instance startup")))
 *         .signals(Signals.waitForAll(SignalsOptions.builder()
 *                 .timeout(Duration.minutes(10))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-06T20:02:50.836Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitFile")
public abstract class InitFile extends software.amazon.awscdk.services.ec2.InitElement {

    protected InitFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param fileName This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected InitFile(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFileOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Create an asset from the given file.
     * <p>
     * This is appropriate for files that are too large to embed into the template.
     * <p>
     * @param targetFileName This parameter is required.
     * @param path This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileAssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Create an asset from the given file.
     * <p>
     * This is appropriate for files that are too large to embed into the template.
     * <p>
     * @param targetFileName This parameter is required.
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Use a file from an asset at instance startup time.
     * <p>
     * @param targetFileName This parameter is required.
     * @param asset This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromExistingAsset(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.assets.Asset asset, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromExistingAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(asset, "asset is required"), options });
    }

    /**
     * Use a file from an asset at instance startup time.
     * <p>
     * @param targetFileName This parameter is required.
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromExistingAsset(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.assets.Asset asset) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromExistingAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Read a file from disk and use its contents.
     * <p>
     * The file will be embedded in the template, so care should be taken to not
     * exceed the template size.
     * <p>
     * If options.base64encoded is set to true, this will base64-encode the file's contents.
     * <p>
     * @param targetFileName This parameter is required.
     * @param sourceFileName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromFileInline(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull java.lang.String sourceFileName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromFileInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(sourceFileName, "sourceFileName is required"), options });
    }

    /**
     * Read a file from disk and use its contents.
     * <p>
     * The file will be embedded in the template, so care should be taken to not
     * exceed the template size.
     * <p>
     * If options.base64encoded is set to true, this will base64-encode the file's contents.
     * <p>
     * @param targetFileName This parameter is required.
     * @param sourceFileName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromFileInline(final @org.jetbrains.annotations.NotNull java.lang.String targetFileName, final @org.jetbrains.annotations.NotNull java.lang.String sourceFileName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromFileInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(targetFileName, "targetFileName is required"), java.util.Objects.requireNonNull(sourceFileName, "sourceFileName is required") });
    }

    /**
     * Use a JSON-compatible object as the file content, write it to a JSON file.
     * <p>
     * May contain tokens.
     * <p>
     * @param fileName This parameter is required.
     * @param obj This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromObject(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> obj, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(obj, "obj is required"), options });
    }

    /**
     * Use a JSON-compatible object as the file content, write it to a JSON file.
     * <p>
     * May contain tokens.
     * <p>
     * @param fileName This parameter is required.
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromObject(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(obj, "obj is required") });
    }

    /**
     * Download a file from an S3 bucket at instance startup time.
     * <p>
     * @param fileName This parameter is required.
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromS3Object(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromS3Object", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), options });
    }

    /**
     * Download a file from an S3 bucket at instance startup time.
     * <p>
     * @param fileName This parameter is required.
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromS3Object(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromS3Object", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Use a literal string as the file content.
     * <p>
     * @param fileName This parameter is required.
     * @param content This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromString(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String content, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(content, "content is required"), options });
    }

    /**
     * Use a literal string as the file content.
     * <p>
     * @param fileName This parameter is required.
     * @param content This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromString(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String content) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(content, "content is required") });
    }

    /**
     * Download from a URL at instance startup time.
     * <p>
     * @param fileName This parameter is required.
     * @param url This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromUrl(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String url, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(url, "url is required"), options });
    }

    /**
     * Download from a URL at instance startup time.
     * <p>
     * @param fileName This parameter is required.
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile fromUrl(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "fromUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * Write a symlink with the given symlink target.
     * <p>
     * @param fileName This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile symlink(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitFileOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "symlink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Write a symlink with the given symlink target.
     * <p>
     * @param fileName This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitFile symlink(final @org.jetbrains.annotations.NotNull java.lang.String fileName, final @org.jetbrains.annotations.NotNull java.lang.String target) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitFile.class, "symlink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitFile.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Returns the init element type for this element.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getElementType() {
        return software.amazon.jsii.Kernel.get(this, "elementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ec2.InitFile {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
