package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnSecurityGroupIngress`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSecurityGroupIngressProps cfnSecurityGroupIngressProps = CfnSecurityGroupIngressProps.builder()
 *         .ipProtocol("ipProtocol")
 *         // the properties below are optional
 *         .cidrIp("cidrIp")
 *         .cidrIpv6("cidrIpv6")
 *         .description("description")
 *         .fromPort(123)
 *         .groupId("groupId")
 *         .groupName("groupName")
 *         .sourcePrefixListId("sourcePrefixListId")
 *         .sourceSecurityGroupId("sourceSecurityGroupId")
 *         .sourceSecurityGroupName("sourceSecurityGroupName")
 *         .sourceSecurityGroupOwnerId("sourceSecurityGroupOwnerId")
 *         .toPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:53.980Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroupIngressProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityGroupIngressProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityGroupIngressProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ).
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

    /**
     * The IPv4 address range, in CIDR format.
     * <p>
     * You must specify a source security group ( <code>SourcePrefixListId</code> or <code>SourceSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
        return null;
    }

    /**
     * The IPv6 address range, in CIDR format.
     * <p>
     * You must specify a source security group ( <code>SourcePrefixListId</code> or <code>SourceSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
        return null;
    }

    /**
     * Updates the description of an ingress (inbound) security group rule.
     * <p>
     * You can replace an existing description, or add a description to a rule that did not have one previously.
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * <p>
     * Use this for ICMP and any protocol that uses ports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
        return null;
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     * <p>
     * You must specify the <code>GroupName</code> property or the <code>GroupId</code> property. For security groups that are in a VPC, you must use the <code>GroupId</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
        return null;
    }

    /**
     * The name of the security group.
     * <p>
     * Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code> .
     * <p>
     * Constraints for EC2-Classic: ASCII characters
     * <p>
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=&amp;;{}!$*
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * [EC2-VPC only] The ID of a prefix list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourcePrefixListId() {
        return null;
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify either the security group ID or the security group name. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupId() {
        return null;
    }

    /**
     * [EC2-Classic, default VPC] The name of the source security group.
     * <p>
     * You can't specify this parameter in combination with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
     * <p>
     * You must specify the <code>GroupName</code> property or the <code>GroupId</code> property. For security groups that are in a VPC, you must use the <code>GroupId</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupName() {
        return null;
    }

    /**
     * [nondefault VPC] The AWS account ID for the source security group, if the source security group is in a different account.
     * <p>
     * You can't specify this property with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
     * <p>
     * If you specify <code>SourceSecurityGroupName</code> or <code>SourceSecurityGroupId</code> and that security group is owned by a different account than the account creating the stack, you must specify the <code>SourceSecurityGroupOwnerId</code> ; otherwise, this property is optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupOwnerId() {
        return null;
    }

    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * <p>
     * Use this for ICMP and any protocol that uses ports.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityGroupIngressProps> {
        java.lang.String ipProtocol;
        java.lang.String cidrIp;
        java.lang.String cidrIpv6;
        java.lang.String description;
        java.lang.Number fromPort;
        java.lang.String groupId;
        java.lang.String groupName;
        java.lang.String sourcePrefixListId;
        java.lang.String sourceSecurityGroupId;
        java.lang.String sourceSecurityGroupName;
        java.lang.String sourceSecurityGroupOwnerId;
        java.lang.Number toPort;

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getIpProtocol}
         * @param ipProtocol The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ). This parameter is required.
         *                   [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipProtocol(java.lang.String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getCidrIp}
         * @param cidrIp The IPv4 address range, in CIDR format.
         *               You must specify a source security group ( <code>SourcePrefixListId</code> or <code>SourceSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         *               <p>
         *               For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIp(java.lang.String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getCidrIpv6}
         * @param cidrIpv6 The IPv6 address range, in CIDR format.
         *                 You must specify a source security group ( <code>SourcePrefixListId</code> or <code>SourceSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         *                 <p>
         *                 For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIpv6(java.lang.String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getDescription}
         * @param description Updates the description of an ingress (inbound) security group rule.
         *                    You can replace an existing description, or add a description to a rule that did not have one previously.
         *                    <p>
         *                    Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getFromPort}
         * @param fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
         *                 A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         *                 <p>
         *                 Use this for ICMP and any protocol that uses ports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPort(java.lang.Number fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getGroupId}
         * @param groupId The ID of the security group.
         *                You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         *                <p>
         *                You must specify the <code>GroupName</code> property or the <code>GroupId</code> property. For security groups that are in a VPC, you must use the <code>GroupId</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getGroupName}
         * @param groupName The name of the security group.
         *                  Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code> .
         *                  <p>
         *                  Constraints for EC2-Classic: ASCII characters
         *                  <p>
         *                  Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=&amp;;{}!$*
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getSourcePrefixListId}
         * @param sourcePrefixListId [EC2-VPC only] The ID of a prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePrefixListId(java.lang.String sourcePrefixListId) {
            this.sourcePrefixListId = sourcePrefixListId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getSourceSecurityGroupId}
         * @param sourceSecurityGroupId The ID of the security group.
         *                              You must specify either the security group ID or the security group name. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceSecurityGroupId(java.lang.String sourceSecurityGroupId) {
            this.sourceSecurityGroupId = sourceSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getSourceSecurityGroupName}
         * @param sourceSecurityGroupName [EC2-Classic, default VPC] The name of the source security group.
         *                                You can't specify this parameter in combination with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
         *                                <p>
         *                                You must specify the <code>GroupName</code> property or the <code>GroupId</code> property. For security groups that are in a VPC, you must use the <code>GroupId</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceSecurityGroupName(java.lang.String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getSourceSecurityGroupOwnerId}
         * @param sourceSecurityGroupOwnerId [nondefault VPC] The AWS account ID for the source security group, if the source security group is in a different account.
         *                                   You can't specify this property with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
         *                                   <p>
         *                                   If you specify <code>SourceSecurityGroupName</code> or <code>SourceSecurityGroupId</code> and that security group is owned by a different account than the account creating the stack, you must specify the <code>SourceSecurityGroupOwnerId</code> ; otherwise, this property is optional.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceSecurityGroupOwnerId(java.lang.String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityGroupIngressProps#getToPort}
         * @param toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
         *               A value of <code>-1</code> indicates all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         *               <p>
         *               Use this for ICMP and any protocol that uses ports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toPort(java.lang.Number toPort) {
            this.toPort = toPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityGroupIngressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityGroupIngressProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityGroupIngressProps {
        private final java.lang.String ipProtocol;
        private final java.lang.String cidrIp;
        private final java.lang.String cidrIpv6;
        private final java.lang.String description;
        private final java.lang.Number fromPort;
        private final java.lang.String groupId;
        private final java.lang.String groupName;
        private final java.lang.String sourcePrefixListId;
        private final java.lang.String sourceSecurityGroupId;
        private final java.lang.String sourceSecurityGroupName;
        private final java.lang.String sourceSecurityGroupOwnerId;
        private final java.lang.Number toPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipProtocol = software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrIp = software.amazon.jsii.Kernel.get(this, "cidrIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrIpv6 = software.amazon.jsii.Kernel.get(this, "cidrIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourcePrefixListId = software.amazon.jsii.Kernel.get(this, "sourcePrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceSecurityGroupId = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceSecurityGroupName = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceSecurityGroupOwnerId = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipProtocol = java.util.Objects.requireNonNull(builder.ipProtocol, "ipProtocol is required");
            this.cidrIp = builder.cidrIp;
            this.cidrIpv6 = builder.cidrIpv6;
            this.description = builder.description;
            this.fromPort = builder.fromPort;
            this.groupId = builder.groupId;
            this.groupName = builder.groupName;
            this.sourcePrefixListId = builder.sourcePrefixListId;
            this.sourceSecurityGroupId = builder.sourceSecurityGroupId;
            this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
            this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
            this.toPort = builder.toPort;
        }

        @Override
        public final java.lang.String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final java.lang.String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final java.lang.String getCidrIpv6() {
            return this.cidrIpv6;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getFromPort() {
            return this.fromPort;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.String getSourcePrefixListId() {
            return this.sourcePrefixListId;
        }

        @Override
        public final java.lang.String getSourceSecurityGroupId() {
            return this.sourceSecurityGroupId;
        }

        @Override
        public final java.lang.String getSourceSecurityGroupName() {
            return this.sourceSecurityGroupName;
        }

        @Override
        public final java.lang.String getSourceSecurityGroupOwnerId() {
            return this.sourceSecurityGroupOwnerId;
        }

        @Override
        public final java.lang.Number getToPort() {
            return this.toPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
            if (this.getCidrIp() != null) {
                data.set("cidrIp", om.valueToTree(this.getCidrIp()));
            }
            if (this.getCidrIpv6() != null) {
                data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFromPort() != null) {
                data.set("fromPort", om.valueToTree(this.getFromPort()));
            }
            if (this.getGroupId() != null) {
                data.set("groupId", om.valueToTree(this.getGroupId()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getSourcePrefixListId() != null) {
                data.set("sourcePrefixListId", om.valueToTree(this.getSourcePrefixListId()));
            }
            if (this.getSourceSecurityGroupId() != null) {
                data.set("sourceSecurityGroupId", om.valueToTree(this.getSourceSecurityGroupId()));
            }
            if (this.getSourceSecurityGroupName() != null) {
                data.set("sourceSecurityGroupName", om.valueToTree(this.getSourceSecurityGroupName()));
            }
            if (this.getSourceSecurityGroupOwnerId() != null) {
                data.set("sourceSecurityGroupOwnerId", om.valueToTree(this.getSourceSecurityGroupOwnerId()));
            }
            if (this.getToPort() != null) {
                data.set("toPort", om.valueToTree(this.getToPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSecurityGroupIngressProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityGroupIngressProps.Jsii$Proxy that = (CfnSecurityGroupIngressProps.Jsii$Proxy) o;

            if (!ipProtocol.equals(that.ipProtocol)) return false;
            if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
            if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
            if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.sourcePrefixListId != null ? !this.sourcePrefixListId.equals(that.sourcePrefixListId) : that.sourcePrefixListId != null) return false;
            if (this.sourceSecurityGroupId != null ? !this.sourceSecurityGroupId.equals(that.sourceSecurityGroupId) : that.sourceSecurityGroupId != null) return false;
            if (this.sourceSecurityGroupName != null ? !this.sourceSecurityGroupName.equals(that.sourceSecurityGroupName) : that.sourceSecurityGroupName != null) return false;
            if (this.sourceSecurityGroupOwnerId != null ? !this.sourceSecurityGroupOwnerId.equals(that.sourceSecurityGroupOwnerId) : that.sourceSecurityGroupOwnerId != null) return false;
            return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ipProtocol.hashCode();
            result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
            result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
            result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.sourcePrefixListId != null ? this.sourcePrefixListId.hashCode() : 0);
            result = 31 * result + (this.sourceSecurityGroupId != null ? this.sourceSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.sourceSecurityGroupName != null ? this.sourceSecurityGroupName.hashCode() : 0);
            result = 31 * result + (this.sourceSecurityGroupOwnerId != null ? this.sourceSecurityGroupOwnerId.hashCode() : 0);
            result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
            return result;
        }
    }
}
