package software.amazon.awscdk.services.ec2;

/**
 * The type of VPC traffic to log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = new Vpc(this, "Vpc");
 * vpc.addFlowLog("FlowLogS3", FlowLogOptions.builder()
 *         .destination(FlowLogDestination.toS3())
 *         .build());
 * vpc.addFlowLog("FlowLogCloudWatch", FlowLogOptions.builder()
 *         .trafficType(FlowLogTrafficType.REJECT)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:54.230Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLogTrafficType")
public enum FlowLogTrafficType {
    /**
     * Only log accepts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACCEPT,
    /**
     * Log all requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Only log rejects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REJECT,
}
