package software.amazon.awscdk.services.ec2;

/**
 * Options when downloading files from S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.assets.Asset;
 * Instance instance;
 * Asset asset = Asset.Builder.create(this, "Asset")
 *         .path("./configure.sh")
 *         .build();
 * String localPath = instance.userData.addS3DownloadCommand(S3DownloadOptions.builder()
 *         .bucket(asset.getBucket())
 *         .bucketKey(asset.getS3ObjectKey())
 *         .region("us-east-1")
 *         .build());
 * instance.userData.addExecuteFileCommand(ExecuteFileOptions.builder()
 *         .filePath(localPath)
 *         .arguments("--verbose -y")
 *         .build());
 * asset.grantRead(instance.getRole());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:54.388Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.S3DownloadOptions")
@software.amazon.jsii.Jsii.Proxy(S3DownloadOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3DownloadOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the S3 bucket to download from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The key of the file to download.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketKey();

    /**
     * The name of the local file.
     * <p>
     * Default: Linux   - /tmp/bucketKey
     * Windows - %TEMP%/bucketKey
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalFile() {
        return null;
    }

    /**
     * The region of the S3 Bucket (needed for access via VPC Gateway).
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3DownloadOptions> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketKey;
        java.lang.String localFile;
        java.lang.String region;

        /**
         * Sets the value of {@link S3DownloadOptions#getBucket}
         * @param bucket Name of the S3 bucket to download from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3DownloadOptions#getBucketKey}
         * @param bucketKey The key of the file to download. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketKey(java.lang.String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        /**
         * Sets the value of {@link S3DownloadOptions#getLocalFile}
         * @param localFile The name of the local file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localFile(java.lang.String localFile) {
            this.localFile = localFile;
            return this;
        }

        /**
         * Sets the value of {@link S3DownloadOptions#getRegion}
         * @param region The region of the S3 Bucket (needed for access via VPC Gateway).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3DownloadOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3DownloadOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3DownloadOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DownloadOptions {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketKey;
        private final java.lang.String localFile;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketKey = software.amazon.jsii.Kernel.get(this, "bucketKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localFile = software.amazon.jsii.Kernel.get(this, "localFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.bucketKey = java.util.Objects.requireNonNull(builder.bucketKey, "bucketKey is required");
            this.localFile = builder.localFile;
            this.region = builder.region;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketKey() {
            return this.bucketKey;
        }

        @Override
        public final java.lang.String getLocalFile() {
            return this.localFile;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("bucketKey", om.valueToTree(this.getBucketKey()));
            if (this.getLocalFile() != null) {
                data.set("localFile", om.valueToTree(this.getLocalFile()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.S3DownloadOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3DownloadOptions.Jsii$Proxy that = (S3DownloadOptions.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!bucketKey.equals(that.bucketKey)) return false;
            if (this.localFile != null ? !this.localFile.equals(that.localFile) : that.localFile != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.bucketKey.hashCode());
            result = 31 * result + (this.localFile != null ? this.localFile.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
