package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SecurityGroupEgress`.
 * <p>
 * [EC2-VPC only] Adds the specified egress rules to a security group for use with a VPC.
 * <p>
 * An outbound rule permits instances to send traffic to the specified destination IPv4 or IPv6 CIDR address ranges, or to the specified destination security groups for the same VPC.
 * <p>
 * You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes.
 * <p>
 * You must specify only one of the following properties: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
 * <p>
 * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ). If you do not specify one of these parameters, the stack will launch successfully but the rule will not be added to the security group.
 * <p>
 * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
 * <p>
 * For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a> .
 * <p>
 * Use <code>AWS::EC2::SecurityGroupIngress</code> and <code>AWS::EC2::SecurityGroupEgress</code> only when necessary, typically to allow security groups to reference each other in ingress and egress rules. Otherwise, use the embedded ingress and egress rules of the security group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSecurityGroupEgress cfnSecurityGroupEgress = CfnSecurityGroupEgress.Builder.create(this, "MyCfnSecurityGroupEgress")
 *         .groupId("groupId")
 *         .ipProtocol("ipProtocol")
 *         // the properties below are optional
 *         .cidrIp("cidrIp")
 *         .cidrIpv6("cidrIpv6")
 *         .description("description")
 *         .destinationPrefixListId("destinationPrefixListId")
 *         .destinationSecurityGroupId("destinationSecurityGroupId")
 *         .fromPort(123)
 *         .toPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-19T19:24:27.477Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroupEgress")
public class CfnSecurityGroupEgress extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSecurityGroupEgress(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityGroupEgress(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::SecurityGroupEgress`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityGroupEgress(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupId() {
        return software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupId", java.util.Objects.requireNonNull(value, "groupId is required"));
    }

    /**
     * The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ).
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol() {
        return software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ).
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpProtocol(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
    }

    /**
     * The IPv4 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
        return software.amazon.jsii.Kernel.get(this, "cidrIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrIp(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cidrIp", value);
    }

    /**
     * The IPv6 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
        return software.amazon.jsii.Kernel.get(this, "cidrIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 address range, in CIDR format.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrIpv6(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cidrIpv6", value);
    }

    /**
     * The description of an egress (outbound) security group rule.
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of an egress (outbound) security group rule.
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * [EC2-VPC only] The prefix list IDs for an AWS service.
     * <p>
     * This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
        return software.amazon.jsii.Kernel.get(this, "destinationPrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * [EC2-VPC only] The prefix list IDs for an AWS service.
     * <p>
     * This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationPrefixListId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationPrefixListId", value);
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "destinationSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the security group.
     * <p>
     * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationSecurityGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationSecurityGroupId", value);
    }

    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
        return software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFromPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "fromPort", value);
    }

    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
        return software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * <p>
     * A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setToPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "toPort", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps.Builder();
        }

        /**
         * The ID of the security group.
         * <p>
         * You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         * <p>
         * @return {@code this}
         * @param groupId The ID of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(final java.lang.String groupId) {
            this.props.groupId(groupId);
            return this;
        }

        /**
         * The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ).
         * <p>
         * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         * <p>
         * @return {@code this}
         * @param ipProtocol The IP protocol name ( `tcp` , `udp` , `icmp` , `icmpv6` ) or number (see [Protocol Numbers](https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipProtocol(final java.lang.String ipProtocol) {
            this.props.ipProtocol(ipProtocol);
            return this;
        }

        /**
         * The IPv4 address range, in CIDR format.
         * <p>
         * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cidrIp The IPv4 address range, in CIDR format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIp(final java.lang.String cidrIp) {
            this.props.cidrIp(cidrIp);
            return this;
        }

        /**
         * The IPv6 address range, in CIDR format.
         * <p>
         * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cidrIpv6 The IPv6 address range, in CIDR format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrIpv6(final java.lang.String cidrIpv6) {
            this.props.cidrIpv6(cidrIpv6);
            return this;
        }

        /**
         * The description of an egress (outbound) security group rule.
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
         * <p>
         * @return {@code this}
         * @param description The description of an egress (outbound) security group rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * [EC2-VPC only] The prefix list IDs for an AWS service.
         * <p>
         * This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
         * <p>
         * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * <p>
         * @return {@code this}
         * @param destinationPrefixListId [EC2-VPC only] The prefix list IDs for an AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPrefixListId(final java.lang.String destinationPrefixListId) {
            this.props.destinationPrefixListId(destinationPrefixListId);
            return this;
        }

        /**
         * The ID of the security group.
         * <p>
         * You must specify a destination security group ( <code>DestinationPrefixListId</code> or <code>DestinationSecurityGroupId</code> ) or a CIDR range ( <code>CidrIp</code> or <code>CidrIpv6</code> ).
         * <p>
         * @return {@code this}
         * @param destinationSecurityGroupId The ID of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationSecurityGroupId(final java.lang.String destinationSecurityGroupId) {
            this.props.destinationSecurityGroupId(destinationSecurityGroupId);
            return this;
        }

        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
         * <p>
         * A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         * <p>
         * @return {@code this}
         * @param fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPort(final java.lang.Number fromPort) {
            this.props.fromPort(fromPort);
            return this;
        }

        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
         * <p>
         * A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         * <p>
         * @return {@code this}
         * @param toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toPort(final java.lang.Number toPort) {
            this.props.toPort(toPort);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress build() {
            return new software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
