package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 * <p>
 * Specifies the configuration information to launch a fleet--or group--of instances. An EC2 Fleet can launch multiple instance types across multiple Availability Zones, using the On-Demand Instance, Reserved Instance, and Spot Instance purchasing models together. Using EC2 Fleet, you can define separate On-Demand and Spot capacity targets, specify the instance types that work best for your applications, and specify how Amazon EC2 should distribute your fleet capacity within each purchasing model. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnEC2Fleet cfnEC2Fleet = CfnEC2Fleet.Builder.create(this, "MyCfnEC2Fleet")
 *         .launchTemplateConfigs(List.of(FleetLaunchTemplateConfigRequestProperty.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .maxPrice("maxPrice")
 *                         .placement(PlacementProperty.builder()
 *                                 .affinity("affinity")
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .hostId("hostId")
 *                                 .hostResourceGroupArn("hostResourceGroupArn")
 *                                 .partitionNumber(123)
 *                                 .spreadDomain("spreadDomain")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .priority(123)
 *                         .subnetId("subnetId")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .build()))
 *         .targetCapacitySpecification(TargetCapacitySpecificationRequestProperty.builder()
 *                 .totalTargetCapacity(123)
 *                 // the properties below are optional
 *                 .defaultTargetCapacityType("defaultTargetCapacityType")
 *                 .onDemandTargetCapacity(123)
 *                 .spotTargetCapacity(123)
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .build())
 *         // the properties below are optional
 *         .context("context")
 *         .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *         .onDemandOptions(OnDemandOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
 *                         .usageStrategy("usageStrategy")
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .replaceUnhealthyInstances(false)
 *         .spotOptions(SpotOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(CapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .terminateInstancesWithExpiration(false)
 *         .type("type")
 *         .validFrom("validFrom")
 *         .validUntil("validUntil")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:24.661Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnEC2Fleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEC2Fleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplateConfigs() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetCapacitySpecification() {
        return software.amazon.jsii.Kernel.get(this, "targetCapacitySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContext() {
        return software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContext(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "context", value);
    }

    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "excessCapacityTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcessCapacityTerminationPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "excessCapacityTerminationPolicy", value);
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandOptions() {
        return software.amazon.jsii.Kernel.get(this, "onDemandOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     * <p>
     * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
        return software.amazon.jsii.Kernel.get(this, "replaceUnhealthyInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     * <p>
     * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     * <p>
     * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
        return software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
     * <p>
     * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
     * <p>
     * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
     * <p>
     * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
     * <p>
     * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
     * <p>
     * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
     * <p>
     * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
        return software.amazon.jsii.Kernel.get(this, "terminateInstancesWithExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * The fleet type. The default value is `maintain` .
     * <p>
     * <ul>
     * <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
     * <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
     * <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fleet type. The default value is `maintain` .
     * <p>
     * <ul>
     * <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
     * <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
     * <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }

    /**
     * The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * The default is to start fulfilling the request immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
        return software.amazon.jsii.Kernel.get(this, "validFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * The default is to start fulfilling the request immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidFrom(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validFrom", value);
    }

    /**
     * The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
        return software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
     * <p>
     * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidUntil(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validUntil", value);
    }
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
     * <p>
     * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorCountRequestProperty acceleratorCountRequestProperty = AcceleratorCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of accelerators.
         * <p>
         * To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of accelerators.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMax}
             * @param max The maximum number of accelerators.
             *            To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMin}
             * @param min The minimum number of accelerators.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRequestProperty.Jsii$Proxy that = (AcceleratorCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total accelerator memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiBRequestProperty = AcceleratorTotalMemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of accelerator memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of accelerator memory, in MiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of accelerator memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of accelerator memory, in MiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbpsRequestProperty = BaselineEbsBandwidthMbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum baseline bandwidth, in Mbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum baseline bandwidth, in Mbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMax}
             * @param max The maximum baseline bandwidth, in Mbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMin}
             * @param min The minimum baseline bandwidth, in Mbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Spot Instance replacement strategy to use when Amazon EC2 emits a rebalance notification signal that your Spot Instance is at an elevated risk of being interrupted.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityRebalanceProperty capacityRebalanceProperty = CapacityRebalanceProperty.builder()
     *         .replacementStrategy("replacementStrategy")
     *         .terminationDelay(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityRebalanceProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityRebalanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityRebalanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The replacement strategy to use. Only available for fleets of type `maintain` .
         * <p>
         * <code>launch</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. EC2 Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
         * <p>
         * <code>launch-before-terminate</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplacementStrategy() {
            return null;
        }

        /**
         * The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
         * <p>
         * Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
         * <p>
         * Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
         * <p>
         * Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationDelay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityRebalanceProperty> {
            java.lang.String replacementStrategy;
            java.lang.Number terminationDelay;

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getReplacementStrategy}
             * @param replacementStrategy The replacement strategy to use. Only available for fleets of type `maintain` .
             *                            <code>launch</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. EC2 Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
             *                            <p>
             *                            <code>launch-before-terminate</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacementStrategy(java.lang.String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getTerminationDelay}
             * @param terminationDelay The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
             *                         Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
             *                         <p>
             *                         Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
             *                         <p>
             *                         Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationDelay(java.lang.Number terminationDelay) {
                this.terminationDelay = terminationDelay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityRebalanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityRebalanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityRebalanceProperty {
            private final java.lang.String replacementStrategy;
            private final java.lang.Number terminationDelay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replacementStrategy = software.amazon.jsii.Kernel.get(this, "replacementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationDelay = software.amazon.jsii.Kernel.get(this, "terminationDelay", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replacementStrategy = builder.replacementStrategy;
                this.terminationDelay = builder.terminationDelay;
            }

            @Override
            public final java.lang.String getReplacementStrategy() {
                return this.replacementStrategy;
            }

            @Override
            public final java.lang.Number getTerminationDelay() {
                return this.terminationDelay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplacementStrategy() != null) {
                    data.set("replacementStrategy", om.valueToTree(this.getReplacementStrategy()));
                }
                if (this.getTerminationDelay() != null) {
                    data.set("terminationDelay", om.valueToTree(this.getTerminationDelay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityRebalanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityRebalanceProperty.Jsii$Proxy that = (CapacityRebalanceProperty.Jsii$Proxy) o;

                if (this.replacementStrategy != null ? !this.replacementStrategy.equals(that.replacementStrategy) : that.replacementStrategy != null) return false;
                return this.terminationDelay != null ? this.terminationDelay.equals(that.terminationDelay) : that.terminationDelay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replacementStrategy != null ? this.replacementStrategy.hashCode() : 0;
                result = 31 * result + (this.terminationDelay != null ? this.terminationDelay.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
     * <p>
     * <blockquote>
     * <p>
     * This strategy can only be used if the EC2 Fleet is of type <code>instant</code> .
     * <p>
     * </blockquote>
     * <p>
     * For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <em>Amazon EC2 User Guide</em> . For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityReservationOptionsRequestProperty capacityReservationOptionsRequestProperty = CapacityReservationOptionsRequestProperty.builder()
     *         .usageStrategy("usageStrategy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * <p>
         * If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ).
         * <p>
         * If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsageStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationOptionsRequestProperty> {
            java.lang.String usageStrategy;

            /**
             * Sets the value of {@link CapacityReservationOptionsRequestProperty#getUsageStrategy}
             * @param usageStrategy Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
             *                      If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ).
             *                      <p>
             *                      If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageStrategy(java.lang.String usageStrategy) {
                this.usageStrategy = usageStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationOptionsRequestProperty {
            private final java.lang.String usageStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.usageStrategy = software.amazon.jsii.Kernel.get(this, "usageStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.usageStrategy = builder.usageStrategy;
            }

            @Override
            public final java.lang.String getUsageStrategy() {
                return this.usageStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUsageStrategy() != null) {
                    data.set("usageStrategy", om.valueToTree(this.getUsageStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationOptionsRequestProperty.Jsii$Proxy that = (CapacityReservationOptionsRequestProperty.Jsii$Proxy) o;

                return this.usageStrategy != null ? this.usageStrategy.equals(that.usageStrategy) : that.usageStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.usageStrategy != null ? this.usageStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a launch template and overrides for an EC2 Fleet.
     * <p>
     * <code>FleetLaunchTemplateConfigRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateConfigRequestProperty fleetLaunchTemplateConfigRequestProperty = FleetLaunchTemplateConfigRequestProperty.builder()
     *         .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .version("version")
     *                 .build())
     *         .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .maxPrice("maxPrice")
     *                 .placement(PlacementProperty.builder()
     *                         .affinity("affinity")
     *                         .availabilityZone("availabilityZone")
     *                         .groupName("groupName")
     *                         .hostId("hostId")
     *                         .hostResourceGroupArn("hostResourceGroupArn")
     *                         .partitionNumber(123)
     *                         .spreadDomain("spreadDomain")
     *                         .tenancy("tenancy")
     *                         .build())
     *                 .priority(123)
     *                 .subnetId("subnetId")
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateConfigRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch template to use.
         * <p>
         * You must specify either the launch template ID or launch template name in the request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateSpecification() {
            return null;
        }

        /**
         * Any parameters that you specify override the same parameters in the launch template.
         * <p>
         * For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateConfigRequestProperty> {
            java.lang.Object launchTemplateSpecification;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template to use.
             *                                    You must specify either the launch template ID or launch template name in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.core.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template to use.
             *                                    You must specify either the launch template ID or launch template name in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             *                  For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             *                  For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateConfigRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateConfigRequestProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateSpecification = software.amazon.jsii.Kernel.get(this, "launchTemplateSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = builder.launchTemplateSpecification;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateSpecification() != null) {
                    data.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies overrides for a launch template for an EC2 Fleet.
     * <p>
     * <code>FleetLaunchTemplateOverridesRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html">FleetLaunchTemplateConfigRequest</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateOverridesRequestProperty fleetLaunchTemplateOverridesRequestProperty = FleetLaunchTemplateOverridesRequestProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .maxPrice("maxPrice")
     *         .placement(PlacementProperty.builder()
     *                 .affinity("affinity")
     *                 .availabilityZone("availabilityZone")
     *                 .groupName("groupName")
     *                 .hostId("hostId")
     *                 .hostResourceGroupArn("hostResourceGroupArn")
     *                 .partitionNumber(123)
     *                 .spreadDomain("spreadDomain")
     *                 .tenancy("tenancy")
     *                 .build())
     *         .priority(123)
     *         .subnetId("subnetId")
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateOverridesRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone in which to launch the instances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The attributes for the instance types.
         * <p>
         * When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * The instance type.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceTypes</code> , you can't specify <code>InstanceRequirements</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxPrice() {
            return null;
        }

        /**
         * The location where the instance launched, if applicable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * The priority for the launch template override. The highest priority is launched first.
         * <p>
         * If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code> , EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
         * <p>
         * If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code> , EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
         * <p>
         * Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * The IDs of the subnets in which to launch the instances.
         * <p>
         * Separate multiple subnet IDs using commas (for example, <code>subnet-1234abcdeexample1, subnet-0987cdef6example2</code> ). A request of type <code>instant</code> can have only one subnet ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * The number of units provided by the specified instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateOverridesRequestProperty> {
            java.lang.String availabilityZone;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.String maxPrice;
            java.lang.Object placement;
            java.lang.Number priority;
            java.lang.String subnetId;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone in which to launch the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.core.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceType}
             * @param instanceType The instance type.
             *                     <blockquote>
             *                     <p>
             *                     If you specify <code>InstanceTypes</code> , you can't specify <code>InstanceRequirements</code> .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getMaxPrice}
             * @param maxPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement The location where the instance launched, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement The location where the instance launched, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnEC2Fleet.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPriority}
             * @param priority The priority for the launch template override. The highest priority is launched first.
             *                 If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code> , EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
             *                 <p>
             *                 If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code> , EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
             *                 <p>
             *                 Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getSubnetId}
             * @param subnetId The IDs of the subnets in which to launch the instances.
             *                 Separate multiple subnet IDs using commas (for example, <code>subnet-1234abcdeexample1, subnet-0987cdef6example2</code> ). A request of type <code>instant</code> can have only one subnet ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units provided by the specified instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateOverridesRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateOverridesRequestProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.String maxPrice;
            private final java.lang.Object placement;
            private final java.lang.Number priority;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.maxPrice = builder.maxPrice;
                this.placement = builder.placement;
                this.priority = builder.priority;
                this.subnetId = builder.subnetId;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMaxPrice() != null) {
                    data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the launch template to use for an EC2 Fleet.
     * <p>
     * You must specify either the launch template ID or launch template name in the request.
     * <p>
     * <code>FleetLaunchTemplateSpecificationRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html">FleetLaunchTemplateConfigRequest</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateSpecificationRequestProperty fleetLaunchTemplateSpecificationRequestProperty = FleetLaunchTemplateSpecificationRequestProperty.builder()
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the launch template.
         * <p>
         * If you specify the template ID, you can't specify the template name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template.
         * <p>
         * If you specify the template name, you can't specify the template ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * The launch template version number, `$Latest` , or `$Default` . You must specify a value, otherwise the request fails.
         * <p>
         * If the value is <code>$Latest</code> , Amazon EC2 uses the latest version of the launch template.
         * <p>
         * If the value is <code>$Default</code> , Amazon EC2 uses the default version of the launch template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationRequestProperty> {
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;
            java.lang.String version;

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template.
             *                         If you specify the template ID, you can't specify the template name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template.
             *                           If you specify the template name, you can't specify the template ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getVersion}
             * @param version The launch template version number, `$Latest` , or `$Default` . You must specify a value, otherwise the request fails.
             *                If the value is <code>$Latest</code> , Amazon EC2 uses the latest version of the launch template.
             *                <p>
             *                If the value is <code>$Default</code> , Amazon EC2 uses the default version of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationRequestProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The attributes for the instance types.
     * <p>
     * When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     * <p>
     * When you specify multiple parameters, you get instance types that satisfy all of the specified parameters. If you specify multiple values for a parameter, you get instance types that satisfy any of the specified values.
     * <p>
     * <blockquote>
     * <p>
     * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code> . All other parameters are optional. Any unspecified optional parameter is set to its default.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a> , <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a> , and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceRequirementsRequestProperty instanceRequirementsRequestProperty = InstanceRequirementsRequestProperty.builder()
     *         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
         * <p>
         * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
         * <li>For instance types with AMD devices, specify <code>amd</code> .</li>
         * <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
         * <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
         * </ul>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * The accelerators that must be on the instance type.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
         * <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
         * <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
         * <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
         * <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
         * <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
         * <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types that must be on the instance type.
         * <p>
         * <ul>
         * <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
         * <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
         * <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * Indicates whether bare metal instance types must be included, excluded, or required.
         * <p>
         * <ul>
         * <li>To include bare metal instance types, specify <code>included</code> .</li>
         * <li>To require only bare metal instance types, specify <code>required</code> .</li>
         * <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * Indicates whether burstable performance T instance types are included, excluded, or required.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
         * <p>
         * <ul>
         * <li>To include burstable performance instance types, specify <code>included</code> .</li>
         * <li>To require only burstable performance instance types, specify <code>required</code> .</li>
         * <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * The CPU manufacturers to include.
         * <p>
         * <ul>
         * <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
         * <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
         * <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
         * <p>
         * </blockquote>
         * <p>
         * Default: Any manufacturer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * The instance types to exclude.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
         * <p>
         * Default: No excluded instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether current or previous generation instance types are included.
         * <p>
         * The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * For current generation instance types, specify <code>current</code> .
         * <p>
         * For previous generation instance types, specify <code>previous</code> .
         * <p>
         * Default: Current and previous generation instance types
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required.
         * <p>
         * For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * <ul>
         * <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
         * <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
         * <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>included</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * The type of local storage that is required.
         * <p>
         * <ul>
         * <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
         * <li>For instance types with solid state drive (SDD) storage, specify <code>sdd</code> .</li>
         * </ul>
         * <p>
         * Default: <code>hdd</code> and <code>sdd</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory, in MiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryMiB() {
            return null;
        }

        /**
         * The minimum and maximum number of network interfaces.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * The price protection threshold for On-Demand Instances.
         * <p>
         * This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>20</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
         * <p>
         * Default: <code>false</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * The price protection threshold for Spot Instance.
         * <p>
         * This is the maximum you’ll pay for an Spot Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To turn off price protection, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>100</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of total local storage, in GB.
         * <p>
         * Default: No minimum or maximum limits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * The minimum and maximum number of vCPUs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVCpuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object memoryMiB;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;
            java.lang.Object vCpuCount;

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.core.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers Indicates whether instance types must have accelerators by specific manufacturers.
             *                                 <ul>
             *                                 <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
             *                                 <li>For instance types with AMD devices, specify <code>amd</code> .</li>
             *                                 <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
             *                                 <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
             *                                 </ul>
             *                                 <p>
             *                                 Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorNames}
             * @param acceleratorNames The accelerators that must be on the instance type.
             *                         <ul>
             *                         <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
             *                         <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
             *                         <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
             *                         <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
             *                         <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
             *                         <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
             *                         <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.core.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types that must be on the instance type.
             *                         <ul>
             *                         <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
             *                         <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
             *                         <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator type
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBareMetal}
             * @param bareMetal Indicates whether bare metal instance types must be included, excluded, or required.
             *                  <ul>
             *                  <li>To include bare metal instance types, specify <code>included</code> .</li>
             *                  <li>To require only bare metal instance types, specify <code>required</code> .</li>
             *                  <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
             *                  </ul>
             *                  <p>
             *                  Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.core.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBurstablePerformance}
             * @param burstablePerformance Indicates whether burstable performance T instance types are included, excluded, or required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
             *                             <p>
             *                             <ul>
             *                             <li>To include burstable performance instance types, specify <code>included</code> .</li>
             *                             <li>To require only burstable performance instance types, specify <code>required</code> .</li>
             *                             <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
             *                             </ul>
             *                             <p>
             *                             Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getCpuManufacturers}
             * @param cpuManufacturers The CPU manufacturers to include.
             *                         <ul>
             *                         <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
             *                         <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
             *                         <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
             *                         </ul>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude.
             *                              You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                              <p>
             *                              For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
             *                              <p>
             *                              Default: No excluded instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getInstanceGenerations}
             * @param instanceGenerations Indicates whether current or previous generation instance types are included.
             *                            The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
             *                            <p>
             *                            For current generation instance types, specify <code>current</code> .
             *                            <p>
             *                            For previous generation instance types, specify <code>previous</code> .
             *                            <p>
             *                            Default: Current and previous generation instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorage}
             * @param localStorage Indicates whether instance types with instance store volumes are included, excluded, or required.
             *                     For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
             *                     <p>
             *                     <ul>
             *                     <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
             *                     <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
             *                     <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Default: <code>included</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorageTypes}
             * @param localStorageTypes The type of local storage that is required.
             *                          <ul>
             *                          <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
             *                          <li>For instance types with solid state drive (SDD) storage, specify <code>sdd</code> .</li>
             *                          </ul>
             *                          <p>
             *                          Default: <code>hdd</code> and <code>sdd</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.core.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.core.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.core.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances.
             *                                                  This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                                  <p>
             *                                                  The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                                  <p>
             *                                                  To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                                  <p>
             *                                                  This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                                  <p>
             *                                                  <blockquote>
             *                                                  <p>
             *                                                  If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                                  <p>
             *                                                  </blockquote>
             *                                                  <p>
             *                                                  Default: <code>20</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.core.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instance.
             *                                              This is the maximum you’ll pay for an Spot Instance, expressed as a percentage above the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
             *                                              <p>
             *                                              The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                              <p>
             *                                              To turn off price protection, specify a high value, such as <code>999999</code> .
             *                                              <p>
             *                                              This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                              <p>
             *                                              <blockquote>
             *                                              <p>
             *                                              If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                              <p>
             *                                              </blockquote>
             *                                              <p>
             *                                              Default: <code>100</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.core.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.core.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsRequestProperty {
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object memoryMiB;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;
            private final java.lang.Object vCpuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.memoryMiB = builder.memoryMiB;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
                this.vCpuCount = builder.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getMemoryMiB() != null) {
                    data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }
                if (this.getVCpuCount() != null) {
                    data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsRequestProperty.Jsii$Proxy that = (InstanceRequirementsRequestProperty.Jsii$Proxy) o;

                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                if (this.totalLocalStorageGb != null ? !this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb != null) return false;
                return this.vCpuCount != null ? this.vCpuCount.equals(that.vCpuCount) : that.vCpuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0;
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                result = 31 * result + (this.vCpuCount != null ? this.vCpuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MaintenanceStrategiesProperty maintenanceStrategiesProperty = MaintenanceStrategiesProperty.builder()
     *         .capacityRebalance(CapacityRebalanceProperty.builder()
     *                 .replacementStrategy("replacementStrategy")
     *                 .terminationDelay(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceStrategiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceStrategiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityRebalance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceStrategiesProperty> {
            java.lang.Object capacityRebalance;

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.core.IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceStrategiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceStrategiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceStrategiesProperty {
            private final java.lang.Object capacityRebalance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityRebalance = builder.capacityRebalance;
            }

            @Override
            public final java.lang.Object getCapacityRebalance() {
                return this.capacityRebalance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityRebalance() != null) {
                    data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MaintenanceStrategiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceStrategiesProperty.Jsii$Proxy that = (MaintenanceStrategiesProperty.Jsii$Proxy) o;

                return this.capacityRebalance != null ? this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory per vCPU, in GiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpuRequestProperty = MemoryGiBPerVCpuRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMax}
             * @param max The maximum amount of memory per vCPU, in GiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMin}
             * @param min The minimum amount of memory per vCPU, in GiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuRequestProperty.Jsii$Proxy that = (MemoryGiBPerVCpuRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryMiBRequestProperty memoryMiBRequestProperty = MemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory, in MiB.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of memory, in MiB.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRequestProperty.Jsii$Proxy that = (MemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceCountRequestProperty networkInterfaceCountRequestProperty = NetworkInterfaceCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of network interfaces.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of network interfaces.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMax}
             * @param max The maximum number of network interfaces.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMin}
             * @param min The minimum number of network interfaces.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountRequestProperty.Jsii$Proxy that = (NetworkInterfaceCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the allocation strategy of On-Demand Instances in an EC2 Fleet.
     * <p>
     * <code>OnDemandOptionsRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * OnDemandOptionsRequestProperty onDemandOptionsRequestProperty = OnDemandOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
     *                 .usageStrategy("usageStrategy")
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
         * <p>
         * <code>lowest-price</code> - EC2 Fleet uses price to determine the order, launching the lowest price first.
         * <p>
         * <code>prioritized</code> - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
         * <p>
         * Default: <code>lowest-price</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationOptions() {
            return null;
        }

        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * The minimum target capacity for On-Demand Instances in the fleet.
         * <p>
         * If the minimum target capacity is not reached, the fleet launches no instances.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.Object capacityReservationOptions;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
             *                           <code>lowest-price</code> - EC2 Fleet uses price to determine the order, launching the lowest price first.
             *                           <p>
             *                           <code>prioritized</code> - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
             *                           <p>
             *                           Default: <code>lowest-price</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
             *                                   Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.core.IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
             *                                   Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity The minimum target capacity for On-Demand Instances in the fleet.
             *                          If the minimum target capacity is not reached, the fleet launches no instances.
             *                          <p>
             *                          Supported only for fleets of type <code>instant</code> .
             *                          <p>
             *                          At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.core.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.core.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Object capacityReservationOptions;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationOptions = software.amazon.jsii.Kernel.get(this, "capacityReservationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.capacityReservationOptions = builder.capacityReservationOptions;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Object getCapacityReservationOptions() {
                return this.capacityReservationOptions;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getCapacityReservationOptions() != null) {
                    data.set("capacityReservationOptions", om.valueToTree(this.getCapacityReservationOptions()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandOptionsRequestProperty.Jsii$Proxy that = (OnDemandOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.capacityReservationOptions != null ? !this.capacityReservationOptions.equals(that.capacityReservationOptions) : that.capacityReservationOptions != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.capacityReservationOptions != null ? this.capacityReservationOptions.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the placement of an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PlacementProperty placementProperty = PlacementProperty.builder()
     *         .affinity("affinity")
     *         .availabilityZone("availabilityZone")
     *         .groupName("groupName")
     *         .hostId("hostId")
     *         .hostResourceGroupArn("hostResourceGroupArn")
     *         .partitionNumber(123)
     *         .spreadDomain("spreadDomain")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the [ImportInstance](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html) command.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
            return null;
        }

        /**
         * The Availability Zone of the instance.
         * <p>
         * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The name of the placement group the instance is in.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * The ID of the Dedicated Host on which the instance resides.
         * <p>
         * This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * The ARN of the host resource group in which to launch the instances.
         * <p>
         * If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * The number of the partition that the instance is in.
         * <p>
         * Valid only if the placement group strategy is set to <code>partition</code> .
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitionNumber() {
            return null;
        }

        /**
         * Reserved for future use.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpreadDomain() {
            return null;
        }

        /**
         * The tenancy of the instance (if the instance is running in a VPC).
         * <p>
         * An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.
         * <p>
         * This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         * <p>
         * T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            java.lang.String affinity;
            java.lang.String availabilityZone;
            java.lang.String groupName;
            java.lang.String hostId;
            java.lang.String hostResourceGroupArn;
            java.lang.Number partitionNumber;
            java.lang.String spreadDomain;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAffinity}
             * @param affinity The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the [ImportInstance](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html) command.
             *                 This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone of the instance.
             *                         If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
             *                         <p>
             *                         This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupName}
             * @param groupName The name of the placement group the instance is in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId The ID of the Dedicated Host on which the instance resides.
             *               This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.
             *               <p>
             *               This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn The ARN of the host resource group in which to launch the instances.
             *                             If you specify a host resource group ARN, omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
             *                             <p>
             *                             This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getPartitionNumber}
             * @param partitionNumber The number of the partition that the instance is in.
             *                        Valid only if the placement group strategy is set to <code>partition</code> .
             *                        <p>
             *                        This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionNumber(java.lang.Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getSpreadDomain}
             * @param spreadDomain Reserved for future use.
             *                     This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spreadDomain(java.lang.String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy The tenancy of the instance (if the instance is running in a VPC).
             *                An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.
             *                <p>
             *                This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             *                <p>
             *                T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.Number partitionNumber;
            private final java.lang.String spreadDomain;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionNumber = software.amazon.jsii.Kernel.get(this, "partitionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spreadDomain = software.amazon.jsii.Kernel.get(this, "spreadDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = builder.affinity;
                this.availabilityZone = builder.availabilityZone;
                this.groupName = builder.groupName;
                this.hostId = builder.hostId;
                this.hostResourceGroupArn = builder.hostResourceGroupArn;
                this.partitionNumber = builder.partitionNumber;
                this.spreadDomain = builder.spreadDomain;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.Number getPartitionNumber() {
                return this.partitionNumber;
            }

            @Override
            public final java.lang.String getSpreadDomain() {
                return this.spreadDomain;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAffinity() != null) {
                    data.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getPartitionNumber() != null) {
                    data.set("partitionNumber", om.valueToTree(this.getPartitionNumber()));
                }
                if (this.getSpreadDomain() != null) {
                    data.set("spreadDomain", om.valueToTree(this.getSpreadDomain()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                if (this.partitionNumber != null ? !this.partitionNumber.equals(that.partitionNumber) : that.partitionNumber != null) return false;
                if (this.spreadDomain != null ? !this.spreadDomain.equals(that.spreadDomain) : that.spreadDomain != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.partitionNumber != null ? this.partitionNumber.hashCode() : 0);
                result = 31 * result + (this.spreadDomain != null ? this.spreadDomain.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of Spot Instances for an EC2 Fleet.
     * <p>
     * <code>SpotOptionsRequest</code> is a property of the <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotOptionsRequestProperty spotOptionsRequestProperty = SpotOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *         .instancePoolsToUseCount(123)
     *         .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
     *                 .capacityRebalance(CapacityRebalanceProperty.builder()
     *                         .replacementStrategy("replacementStrategy")
     *                         .terminationDelay(123)
     *                         .build())
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
         * <p>
         * If the allocation strategy is <code>lowestPrice</code> , EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * <p>
         * If the allocation strategy is <code>diversified</code> , EC2 Fleet launches instances from all the Spot Instance pools that you specify.
         * <p>
         * If the allocation strategy is <code>capacityOptimized</code> , EC2 Fleet launches instances from Spot Instance pools that are optimally chosen based on the available Spot Instance capacity.
         * <p>
         * <em>Allowed Values</em> : <code>lowestPrice</code> | <code>diversified</code> | <code>capacityOptimized</code> | <code>capacityOptimizedPrioritized</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The behavior when a Spot Instance is interrupted.
         * <p>
         * Default: <code>terminate</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * The number of Spot pools across which to allocate your target Spot capacity.
         * <p>
         * Supported only when Spot <code>AllocationStrategy</code> is set to <code>lowest-price</code> . EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * <p>
         * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstancePoolsToUseCount() {
            return null;
        }

        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceStrategies() {
            return null;
        }

        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * The minimum target capacity for Spot Instances in the fleet.
         * <p>
         * If the minimum target capacity is not reached, the fleet launches no instances.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * Indicates that the fleet launches all Spot Instances into a single Availability Zone.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.String instanceInterruptionBehavior;
            java.lang.Number instancePoolsToUseCount;
            java.lang.Object maintenanceStrategies;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
             *                           If the allocation strategy is <code>lowestPrice</code> , EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
             *                           <p>
             *                           If the allocation strategy is <code>diversified</code> , EC2 Fleet launches instances from all the Spot Instance pools that you specify.
             *                           <p>
             *                           If the allocation strategy is <code>capacityOptimized</code> , EC2 Fleet launches instances from Spot Instance pools that are optimally chosen based on the available Spot Instance capacity.
             *                           <p>
             *                           <em>Allowed Values</em> : <code>lowestPrice</code> | <code>diversified</code> | <code>capacityOptimized</code> | <code>capacityOptimizedPrioritized</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted.
             *                                     Default: <code>terminate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstancePoolsToUseCount}
             * @param instancePoolsToUseCount The number of Spot pools across which to allocate your target Spot capacity.
             *                                Supported only when Spot <code>AllocationStrategy</code> is set to <code>lowest-price</code> . EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
             *                                <p>
             *                                Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePoolsToUseCount(java.lang.Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.core.IResolvable maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MaintenanceStrategiesProperty maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice The maximum amount per hour for Spot Instances that you're willing to pay.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity The minimum target capacity for Spot Instances in the fleet.
             *                          If the minimum target capacity is not reached, the fleet launches no instances.
             *                          <p>
             *                          Supported only for fleets of type <code>instant</code> .
             *                          <p>
             *                          At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all Spot Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all Spot Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.core.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.core.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Number instancePoolsToUseCount;
            private final java.lang.Object maintenanceStrategies;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instancePoolsToUseCount = software.amazon.jsii.Kernel.get(this, "instancePoolsToUseCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maintenanceStrategies = software.amazon.jsii.Kernel.get(this, "maintenanceStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
                this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
                this.maintenanceStrategies = builder.maintenanceStrategies;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.Number getInstancePoolsToUseCount() {
                return this.instancePoolsToUseCount;
            }

            @Override
            public final java.lang.Object getMaintenanceStrategies() {
                return this.maintenanceStrategies;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getInstancePoolsToUseCount() != null) {
                    data.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                }
                if (this.getMaintenanceStrategies() != null) {
                    data.set("maintenanceStrategies", om.valueToTree(this.getMaintenanceStrategies()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsRequestProperty.Jsii$Proxy that = (SpotOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.instancePoolsToUseCount != null ? !this.instancePoolsToUseCount.equals(that.instancePoolsToUseCount) : that.instancePoolsToUseCount != null) return false;
                if (this.maintenanceStrategies != null ? !this.maintenanceStrategies.equals(that.maintenanceStrategies) : that.maintenanceStrategies != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.hashCode() : 0);
                result = 31 * result + (this.maintenanceStrategies != null ? this.maintenanceStrategies.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the tags to apply to a resource when the resource is being created for an EC2 Fleet.
     * <p>
     * <code>TagSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag.
         * <p>
         * <code>ResourceType</code> must be <code>fleet</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags to apply to the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag.
             *                     <code>ResourceType</code> must be <code>fleet</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the number of units to request for an EC2 Fleet.
     * <p>
     * You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of <code>0</code> and add capacity later.
     * <p>
     * <code>TargetCapacitySpecificationRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TargetCapacitySpecificationRequestProperty targetCapacitySpecificationRequestProperty = TargetCapacitySpecificationRequestProperty.builder()
     *         .totalTargetCapacity(123)
     *         // the properties below are optional
     *         .defaultTargetCapacityType("defaultTargetCapacityType")
     *         .onDemandTargetCapacity(123)
     *         .spotTargetCapacity(123)
     *         .targetCapacityUnitType("targetCapacityUnitType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetCapacitySpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetCapacitySpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of units to request, filled using `DefaultTargetCapacityType` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTotalTargetCapacity();

        /**
         * The default `TotalTargetCapacity` , which is either `Spot` or `On-Demand` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTargetCapacityType() {
            return null;
        }

        /**
         * The number of On-Demand units to request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandTargetCapacity() {
            return null;
        }

        /**
         * The number of Spot units to request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotTargetCapacity() {
            return null;
        }

        /**
         * The unit for the target capacity.
         * <p>
         * Default: <code>units</code> (translates to number of instances)
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetCapacityUnitType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetCapacitySpecificationRequestProperty> {
            java.lang.Number totalTargetCapacity;
            java.lang.String defaultTargetCapacityType;
            java.lang.Number onDemandTargetCapacity;
            java.lang.Number spotTargetCapacity;
            java.lang.String targetCapacityUnitType;

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTotalTargetCapacity}
             * @param totalTargetCapacity The number of units to request, filled using `DefaultTargetCapacityType` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getDefaultTargetCapacityType}
             * @param defaultTargetCapacityType The default `TotalTargetCapacity` , which is either `Spot` or `On-Demand` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTargetCapacityType(java.lang.String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getOnDemandTargetCapacity}
             * @param onDemandTargetCapacity The number of On-Demand units to request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandTargetCapacity(java.lang.Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getSpotTargetCapacity}
             * @param spotTargetCapacity The number of Spot units to request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotTargetCapacity(java.lang.Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTargetCapacityUnitType}
             * @param targetCapacityUnitType The unit for the target capacity.
             *                               Default: <code>units</code> (translates to number of instances)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacityUnitType(java.lang.String targetCapacityUnitType) {
                this.targetCapacityUnitType = targetCapacityUnitType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetCapacitySpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetCapacitySpecificationRequestProperty {
            private final java.lang.Number totalTargetCapacity;
            private final java.lang.String defaultTargetCapacityType;
            private final java.lang.Number onDemandTargetCapacity;
            private final java.lang.Number spotTargetCapacity;
            private final java.lang.String targetCapacityUnitType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.totalTargetCapacity = software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.defaultTargetCapacityType = software.amazon.jsii.Kernel.get(this, "defaultTargetCapacityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onDemandTargetCapacity = software.amazon.jsii.Kernel.get(this, "onDemandTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spotTargetCapacity = software.amazon.jsii.Kernel.get(this, "spotTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetCapacityUnitType = software.amazon.jsii.Kernel.get(this, "targetCapacityUnitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.totalTargetCapacity = java.util.Objects.requireNonNull(builder.totalTargetCapacity, "totalTargetCapacity is required");
                this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
                this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
                this.spotTargetCapacity = builder.spotTargetCapacity;
                this.targetCapacityUnitType = builder.targetCapacityUnitType;
            }

            @Override
            public final java.lang.Number getTotalTargetCapacity() {
                return this.totalTargetCapacity;
            }

            @Override
            public final java.lang.String getDefaultTargetCapacityType() {
                return this.defaultTargetCapacityType;
            }

            @Override
            public final java.lang.Number getOnDemandTargetCapacity() {
                return this.onDemandTargetCapacity;
            }

            @Override
            public final java.lang.Number getSpotTargetCapacity() {
                return this.spotTargetCapacity;
            }

            @Override
            public final java.lang.String getTargetCapacityUnitType() {
                return this.targetCapacityUnitType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
                if (this.getDefaultTargetCapacityType() != null) {
                    data.set("defaultTargetCapacityType", om.valueToTree(this.getDefaultTargetCapacityType()));
                }
                if (this.getOnDemandTargetCapacity() != null) {
                    data.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                }
                if (this.getSpotTargetCapacity() != null) {
                    data.set("spotTargetCapacity", om.valueToTree(this.getSpotTargetCapacity()));
                }
                if (this.getTargetCapacityUnitType() != null) {
                    data.set("targetCapacityUnitType", om.valueToTree(this.getTargetCapacityUnitType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetCapacitySpecificationRequestProperty.Jsii$Proxy that = (TargetCapacitySpecificationRequestProperty.Jsii$Proxy) o;

                if (!totalTargetCapacity.equals(that.totalTargetCapacity)) return false;
                if (this.defaultTargetCapacityType != null ? !this.defaultTargetCapacityType.equals(that.defaultTargetCapacityType) : that.defaultTargetCapacityType != null) return false;
                if (this.onDemandTargetCapacity != null ? !this.onDemandTargetCapacity.equals(that.onDemandTargetCapacity) : that.onDemandTargetCapacity != null) return false;
                if (this.spotTargetCapacity != null ? !this.spotTargetCapacity.equals(that.spotTargetCapacity) : that.spotTargetCapacity != null) return false;
                return this.targetCapacityUnitType != null ? this.targetCapacityUnitType.equals(that.targetCapacityUnitType) : that.targetCapacityUnitType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.totalTargetCapacity.hashCode();
                result = 31 * result + (this.defaultTargetCapacityType != null ? this.defaultTargetCapacityType.hashCode() : 0);
                result = 31 * result + (this.onDemandTargetCapacity != null ? this.onDemandTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.spotTargetCapacity != null ? this.spotTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.targetCapacityUnitType != null ? this.targetCapacityUnitType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total local storage, in GB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TotalLocalStorageGBRequestProperty totalLocalStorageGBRequestProperty = TotalLocalStorageGBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of total local storage, in GB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of total local storage, in GB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMax}
             * @param max The maximum amount of total local storage, in GB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMin}
             * @param min The minimum amount of total local storage, in GB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBRequestProperty.Jsii$Proxy that = (TotalLocalStorageGBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of vCPUs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VCpuCountRangeRequestProperty vCpuCountRangeRequestProperty = VCpuCountRangeRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of vCPUs.
         * <p>
         * To specify no maximum limit, omit this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of vCPUs.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMax}
             * @param max The maximum number of vCPUs.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMin}
             * @param min The minimum number of vCPUs.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeRequestProperty.Jsii$Proxy that = (VCpuCountRangeRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnEC2Fleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder();
        }

        /**
         * The configuration for the EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }
        /**
         * The configuration for the EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }

        /**
         * The number of units to request.
         * <p>
         * @return {@code this}
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.core.IResolvable targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }
        /**
         * The number of units to request.
         * <p>
         * @return {@code this}
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }

        /**
         * Reserved.
         * <p>
         * @return {@code this}
         * @param context Reserved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.lang.String context) {
            this.props.context(context);
            return this;
        }

        /**
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param excessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excessCapacityTerminationPolicy(final java.lang.String excessCapacityTerminationPolicy) {
            this.props.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
            return this;
        }

        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.core.IResolvable onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }
        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }

        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         * <p>
         * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final java.lang.Boolean replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         * <p>
         * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }

        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.core.IResolvable spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }
        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }

        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
         * <p>
         * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         * <p>
         * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * <p>
         * @return {@code this}
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) .
         * <p>
         * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         * <p>
         * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * <p>
         * @return {@code this}
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see [Tagging your resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * <p>
         * @return {@code this}
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final java.lang.Boolean terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * <p>
         * @return {@code this}
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }

        /**
         * The fleet type. The default value is `maintain` .
         * <p>
         * <ul>
         * <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
         * <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
         * <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @param type The fleet type. The default value is `maintain` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         * <p>
         * The default is to start fulfilling the request immediately.
         * <p>
         * @return {@code this}
         * @param validFrom The start date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validFrom(final java.lang.String validFrom) {
            this.props.validFrom(validFrom);
            return this;
        }

        /**
         * The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z).
         * <p>
         * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         * <p>
         * @return {@code this}
         * @param validUntil The end date and time of the request, in UTC format (for example, *YYYY* - *MM* - *DD* T *HH* : *MM* : *SS* Z). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validUntil(final java.lang.String validUntil) {
            this.props.validUntil(validUntil);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnEC2Fleet build() {
            return new software.amazon.awscdk.services.ec2.CfnEC2Fleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
