package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Subnet`.
 * <p>
 * Specifies a subnet for a VPC.
 * <p>
 * When you create each subnet, you provide the VPC ID and IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block. The size of the subnet's IPv4 CIDR block can be the same as a VPC's IPv4 CIDR block, or a subset of a VPC's IPv4 CIDR block. If you create more than one subnet in a VPC, the subnets' CIDR blocks must not overlap. The smallest IPv4 subnet (and VPC) you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses).
 * <p>
 * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses a /64 prefix length.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object privateDnsNameOptionsOnLaunch;
 * CfnSubnet cfnSubnet = CfnSubnet.Builder.create(this, "MyCfnSubnet")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .assignIpv6AddressOnCreation(false)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .cidrBlock("cidrBlock")
 *         .enableDns64(false)
 *         .ipv6CidrBlock("ipv6CidrBlock")
 *         .ipv6Native(false)
 *         .mapPublicIpOnLaunch(false)
 *         .outpostArn("outpostArn")
 *         .privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:25.040Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSubnet")
public class CfnSubnet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSubnet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSubnet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSubnet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::Subnet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSubnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSubnetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Availability Zone of this subnet. For example:.
     * <p>
     * <code>{ "Fn::GetAtt" : [ "mySubnet", "AvailabilityZone" ] }</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 CIDR blocks that are associated with the subnet, such as `[ 2001:db8:1234:1a00::/64 ]` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ID of the network ACL that is associated with the subnet's VPC, such as `acl-5fb85d36` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkAclAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkAclAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOutpostArn() {
        return software.amazon.jsii.Kernel.get(this, "attrOutpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "attrSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the subnet's VPC, such as `vpc-11ad4878` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcId() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Any tags assigned to the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPrivateDnsNameOptionsOnLaunch() {
        return software.amazon.jsii.Kernel.get(this, "privateDnsNameOptionsOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrivateDnsNameOptionsOnLaunch(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "privateDnsNameOptionsOnLaunch", java.util.Objects.requireNonNull(value, "privateDnsNameOptionsOnLaunch is required"));
    }

    /**
     * The ID of the VPC the subnet is in.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC the subnet is in.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
    }

    /**
     * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssignIpv6AddressOnCreation() {
        return software.amazon.jsii.Kernel.get(this, "assignIpv6AddressOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssignIpv6AddressOnCreation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "assignIpv6AddressOnCreation", value);
    }

    /**
     * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssignIpv6AddressOnCreation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assignIpv6AddressOnCreation", value);
    }

    /**
     * The Availability Zone of the subnet.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone of the subnet.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The AZ ID of the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AZ ID of the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneId", value);
    }

    /**
     * The IPv4 CIDR block assigned to the subnet.
     * <p>
     * If you update this property, we create a new subnet, and then delete the existing one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 CIDR block assigned to the subnet.
     * <p>
     * If you update this property, we create a new subnet, and then delete the existing one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cidrBlock", value);
    }

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableDns64() {
        return software.amazon.jsii.Kernel.get(this, "enableDns64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableDns64(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableDns64", value);
    }

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableDns64(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableDns64", value);
    }

    /**
     * The IPv6 CIDR block.
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpv6CidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "ipv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 CIDR block.
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6CidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipv6CidrBlock", value);
    }

    /**
     * Indicates whether this is an IPv6 only subnet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Native() {
        return software.amazon.jsii.Kernel.get(this, "ipv6Native", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether this is an IPv6 only subnet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6Native(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "ipv6Native", value);
    }

    /**
     * Indicates whether this is an IPv6 only subnet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpv6Native(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ipv6Native", value);
    }

    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * <p>
     * The default value is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMapPublicIpOnLaunch() {
        return software.amazon.jsii.Kernel.get(this, "mapPublicIpOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * <p>
     * The default value is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMapPublicIpOnLaunch(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "mapPublicIpOnLaunch", value);
    }

    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * <p>
     * The default value is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMapPublicIpOnLaunch(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mapPublicIpOnLaunch", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutpostArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outpostArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSubnet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnSubnet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSubnetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSubnetProps.Builder();
        }

        /**
         * The ID of the VPC the subnet is in.
         * <p>
         * If you update this property, you must also update the <code>CidrBlock</code> property.
         * <p>
         * @return {@code this}
         * @param vpcId The ID of the VPC the subnet is in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
         * <p>
         * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * <p>
         * @return {@code this}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(final java.lang.Boolean assignIpv6AddressOnCreation) {
            this.props.assignIpv6AddressOnCreation(assignIpv6AddressOnCreation);
            return this;
        }
        /**
         * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
         * <p>
         * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * <p>
         * @return {@code this}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(final software.amazon.awscdk.core.IResolvable assignIpv6AddressOnCreation) {
            this.props.assignIpv6AddressOnCreation(assignIpv6AddressOnCreation);
            return this;
        }

        /**
         * The Availability Zone of the subnet.
         * <p>
         * If you update this property, you must also update the <code>CidrBlock</code> property.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone of the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The AZ ID of the subnet.
         * <p>
         * @return {@code this}
         * @param availabilityZoneId The AZ ID of the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(final java.lang.String availabilityZoneId) {
            this.props.availabilityZoneId(availabilityZoneId);
            return this;
        }

        /**
         * The IPv4 CIDR block assigned to the subnet.
         * <p>
         * If you update this property, we create a new subnet, and then delete the existing one.
         * <p>
         * @return {@code this}
         * @param cidrBlock The IPv4 CIDR block assigned to the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(final java.lang.Boolean enableDns64) {
            this.props.enableDns64(enableDns64);
            return this;
        }
        /**
         * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(final software.amazon.awscdk.core.IResolvable enableDns64) {
            this.props.enableDns64(enableDns64);
            return this;
        }

        /**
         * The IPv6 CIDR block.
         * <p>
         * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * <p>
         * @return {@code this}
         * @param ipv6CidrBlock The IPv6 CIDR block. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(final java.lang.String ipv6CidrBlock) {
            this.props.ipv6CidrBlock(ipv6CidrBlock);
            return this;
        }

        /**
         * Indicates whether this is an IPv6 only subnet.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(final java.lang.Boolean ipv6Native) {
            this.props.ipv6Native(ipv6Native);
            return this;
        }
        /**
         * Indicates whether this is an IPv6 only subnet.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(final software.amazon.awscdk.core.IResolvable ipv6Native) {
            this.props.ipv6Native(ipv6Native);
            return this;
        }

        /**
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(final java.lang.Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }
        /**
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(final software.amazon.awscdk.core.IResolvable mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         * <p>
         * @return {@code this}
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(final java.lang.String outpostArn) {
            this.props.outpostArn(outpostArn);
            return this;
        }

        /**
         * The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * <p>
         * @return {@code this}
         * @param privateDnsNameOptionsOnLaunch The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptionsOnLaunch(final java.lang.Object privateDnsNameOptionsOnLaunch) {
            this.props.privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch);
            return this;
        }

        /**
         * Any tags assigned to the subnet.
         * <p>
         * @return {@code this}
         * @param tags Any tags assigned to the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSubnet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnSubnet build() {
            return new software.amazon.awscdk.services.ec2.CfnSubnet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
