package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnFlowLog`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object destinationOptions;
 * CfnFlowLogProps cfnFlowLogProps = CfnFlowLogProps.builder()
 *         .resourceId("resourceId")
 *         .resourceType("resourceType")
 *         .trafficType("trafficType")
 *         // the properties below are optional
 *         .deliverLogsPermissionArn("deliverLogsPermissionArn")
 *         .destinationOptions(destinationOptions)
 *         .logDestination("logDestination")
 *         .logDestinationType("logDestinationType")
 *         .logFormat("logFormat")
 *         .logGroupName("logGroupName")
 *         .maxAggregationInterval(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:29.918Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLogProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowLogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowLogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The type of resource for which to create the flow log.
     * <p>
     * For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * The type of traffic to log.
     * <p>
     * You can log traffic that the resource accepts or rejects, or all traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficType();

    /**
     * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return null;
    }

    /**
     * The destination options. The following options are supported:.
     * <p>
     * <ul>
     * <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
     * <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationOptions() {
        return null;
    }

    /**
     * The destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code> .
     * <p>
     * If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code> , specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code> , specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code> . Alternatively, use <code>LogGroupName</code> instead.
     * <p>
     * If LogDestinationType is <code>s3</code> , specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code> . For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code> , use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code> . You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return null;
    }

    /**
     * The type of destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code> . To publish flow log data to Amazon S3, specify <code>s3</code> .
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     * <p>
     * Default: <code>cloud-watch-logs</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return null;
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> . If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
     * <p>
     * Specify the fields using the <code>${field-id}</code> format, separated by spaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogFormat() {
        return null;
    }

    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * <p>
     * If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     * <p>
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     * <p>
     * Default: 600
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAggregationInterval() {
        return null;
    }

    /**
     * The tags to apply to the flow logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowLogProps> {
        java.lang.String resourceId;
        java.lang.String resourceType;
        java.lang.String trafficType;
        java.lang.String deliverLogsPermissionArn;
        java.lang.Object destinationOptions;
        java.lang.String logDestination;
        java.lang.String logDestinationType;
        java.lang.String logFormat;
        java.lang.String logGroupName;
        java.lang.Number maxAggregationInterval;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceId}
         * @param resourceId The ID of the subnet, network interface, or VPC for which you want to create a flow log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceType}
         * @param resourceType The type of resource for which to create the flow log. This parameter is required.
         *                     For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTrafficType}
         * @param trafficType The type of traffic to log. This parameter is required.
         *                    You can log traffic that the resource accepts or rejects, or all traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(java.lang.String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDeliverLogsPermissionArn}
         * @param deliverLogsPermissionArn The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         *                                 If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(java.lang.String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDestinationOptions}
         * @param destinationOptions The destination options. The following options are supported:.
         *                           <ul>
         *                           <li><code>FileFormat</code> - The format for the flow log ( <code>plain-text</code> | <code>parquet</code> ). The default is <code>plain-text</code> .</li>
         *                           <li><code>HiveCompatiblePartitions</code> - Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3 ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         *                           <li><code>PerHourPartition</code> - Indicates whether to partition the flow log per hour ( <code>true</code> | <code>false</code> ). The default is <code>false</code> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationOptions(java.lang.Object destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestination}
         * @param logDestination The destination to which the flow log data is to be published.
         *                       Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code> .
         *                       <p>
         *                       If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code> , specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code> , specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code> . Alternatively, use <code>LogGroupName</code> instead.
         *                       <p>
         *                       If LogDestinationType is <code>s3</code> , specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code> . For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code> , use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code> . You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(java.lang.String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestinationType}
         * @param logDestinationType The type of destination to which the flow log data is to be published.
         *                           Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code> . To publish flow log data to Amazon S3, specify <code>s3</code> .
         *                           <p>
         *                           If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         *                           <p>
         *                           Default: <code>cloud-watch-logs</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(java.lang.String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogFormat}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear.
         *                  For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> . If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
         *                  <p>
         *                  Specify the fields using the <code>${field-id}</code> format, separated by spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(java.lang.String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogGroupName}
         * @param logGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         *                     If you specify <code>LogDestinationType</code> as <code>s3</code> , do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getMaxAggregationInterval}
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         *                               You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         *                               <p>
         *                               When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a> , the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         *                               <p>
         *                               Default: 600
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(java.lang.Number maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTags}
         * @param tags The tags to apply to the flow logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowLogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowLogProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowLogProps {
        private final java.lang.String resourceId;
        private final java.lang.String resourceType;
        private final java.lang.String trafficType;
        private final java.lang.String deliverLogsPermissionArn;
        private final java.lang.Object destinationOptions;
        private final java.lang.String logDestination;
        private final java.lang.String logDestinationType;
        private final java.lang.String logFormat;
        private final java.lang.String logGroupName;
        private final java.lang.Number maxAggregationInterval;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trafficType = software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliverLogsPermissionArn = software.amazon.jsii.Kernel.get(this, "deliverLogsPermissionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationOptions = software.amazon.jsii.Kernel.get(this, "destinationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logDestination = software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDestinationType = software.amazon.jsii.Kernel.get(this, "logDestinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxAggregationInterval = software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            this.trafficType = java.util.Objects.requireNonNull(builder.trafficType, "trafficType is required");
            this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
            this.destinationOptions = builder.destinationOptions;
            this.logDestination = builder.logDestination;
            this.logDestinationType = builder.logDestinationType;
            this.logFormat = builder.logFormat;
            this.logGroupName = builder.logGroupName;
            this.maxAggregationInterval = builder.maxAggregationInterval;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.String getTrafficType() {
            return this.trafficType;
        }

        @Override
        public final java.lang.String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final java.lang.Object getDestinationOptions() {
            return this.destinationOptions;
        }

        @Override
        public final java.lang.String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public final java.lang.String getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public final java.lang.String getLogFormat() {
            return this.logFormat;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Number getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            data.set("trafficType", om.valueToTree(this.getTrafficType()));
            if (this.getDeliverLogsPermissionArn() != null) {
                data.set("deliverLogsPermissionArn", om.valueToTree(this.getDeliverLogsPermissionArn()));
            }
            if (this.getDestinationOptions() != null) {
                data.set("destinationOptions", om.valueToTree(this.getDestinationOptions()));
            }
            if (this.getLogDestination() != null) {
                data.set("logDestination", om.valueToTree(this.getLogDestination()));
            }
            if (this.getLogDestinationType() != null) {
                data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            }
            if (this.getLogFormat() != null) {
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }
            if (this.getMaxAggregationInterval() != null) {
                data.set("maxAggregationInterval", om.valueToTree(this.getMaxAggregationInterval()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnFlowLogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowLogProps.Jsii$Proxy that = (CfnFlowLogProps.Jsii$Proxy) o;

            if (!resourceId.equals(that.resourceId)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (!trafficType.equals(that.trafficType)) return false;
            if (this.deliverLogsPermissionArn != null ? !this.deliverLogsPermissionArn.equals(that.deliverLogsPermissionArn) : that.deliverLogsPermissionArn != null) return false;
            if (this.destinationOptions != null ? !this.destinationOptions.equals(that.destinationOptions) : that.destinationOptions != null) return false;
            if (this.logDestination != null ? !this.logDestination.equals(that.logDestination) : that.logDestination != null) return false;
            if (this.logDestinationType != null ? !this.logDestinationType.equals(that.logDestinationType) : that.logDestinationType != null) return false;
            if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) return false;
            if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
            if (this.maxAggregationInterval != null ? !this.maxAggregationInterval.equals(that.maxAggregationInterval) : that.maxAggregationInterval != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.trafficType.hashCode());
            result = 31 * result + (this.deliverLogsPermissionArn != null ? this.deliverLogsPermissionArn.hashCode() : 0);
            result = 31 * result + (this.destinationOptions != null ? this.destinationOptions.hashCode() : 0);
            result = 31 * result + (this.logDestination != null ? this.logDestination.hashCode() : 0);
            result = 31 * result + (this.logDestinationType != null ? this.logDestinationType.hashCode() : 0);
            result = 31 * result + (this.logFormat != null ? this.logFormat.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            result = 31 * result + (this.maxAggregationInterval != null ? this.maxAggregationInterval.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
