package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnVPCGatewayAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCGatewayAttachmentProps cfnVPCGatewayAttachmentProps = CfnVPCGatewayAttachmentProps.builder()
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .internetGatewayId("internetGatewayId")
 *         .vpnGatewayId("vpnGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:30.327Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCGatewayAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCGatewayAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCGatewayAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * The ID of the internet gateway.
     * <p>
     * You must specify either <code>InternetGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInternetGatewayId() {
        return null;
    }

    /**
     * The ID of the virtual private gateway.
     * <p>
     * You must specify either <code>InternetGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCGatewayAttachmentProps> {
        java.lang.String vpcId;
        java.lang.String internetGatewayId;
        java.lang.String vpnGatewayId;

        /**
         * Sets the value of {@link CfnVPCGatewayAttachmentProps#getVpcId}
         * @param vpcId The ID of the VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCGatewayAttachmentProps#getInternetGatewayId}
         * @param internetGatewayId The ID of the internet gateway.
         *                          You must specify either <code>InternetGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetGatewayId(java.lang.String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCGatewayAttachmentProps#getVpnGatewayId}
         * @param vpnGatewayId The ID of the virtual private gateway.
         *                     You must specify either <code>InternetGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCGatewayAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCGatewayAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCGatewayAttachmentProps {
        private final java.lang.String vpcId;
        private final java.lang.String internetGatewayId;
        private final java.lang.String vpnGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.internetGatewayId = software.amazon.jsii.Kernel.get(this, "internetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnGatewayId = software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.internetGatewayId = builder.internetGatewayId;
            this.vpnGatewayId = builder.vpnGatewayId;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        @Override
        public final java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getInternetGatewayId() != null) {
                data.set("internetGatewayId", om.valueToTree(this.getInternetGatewayId()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCGatewayAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCGatewayAttachmentProps.Jsii$Proxy that = (CfnVPCGatewayAttachmentProps.Jsii$Proxy) o;

            if (!vpcId.equals(that.vpcId)) return false;
            if (this.internetGatewayId != null ? !this.internetGatewayId.equals(that.internetGatewayId) : that.internetGatewayId != null) return false;
            return this.vpnGatewayId != null ? this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcId.hashCode();
            result = 31 * result + (this.internetGatewayId != null ? this.internetGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            return result;
        }
    }
}
