package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for an InterfaceVpcEndpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InterfaceVpcEndpoint.Builder.create(this, "VPC Endpoint")
 *         .vpc(vpc)
 *         .service(new InterfaceVpcEndpointService("com.amazonaws.vpce.us-east-1.vpce-svc-uuddlrlrbastrtsvc", 443))
 *         // Choose which availability zones to place the VPC endpoint in, based on
 *         // available AZs
 *         .subnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("us-east-1a", "us-east-1c"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-09T19:16:37.508Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InterfaceVpcEndpointProps")
@software.amazon.jsii.Jsii.Proxy(InterfaceVpcEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions {

    /**
     * The VPC network in which the interface endpoint will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InterfaceVpcEndpointProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        java.lang.Boolean lookupSupportedAzs;
        java.lang.Boolean open;
        java.lang.Boolean privateDnsEnabled;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getVpc}
         * @param vpc The VPC network in which the interface endpoint will be used. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getService}
         * @param service The service to use for this interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getLookupSupportedAzs}
         * @param lookupSupportedAzs Limit to only those availability zones where the endpoint service can be created.
         *                           Setting this to 'true' requires a lookup to be performed at synthesis time. Account
         *                           and region must be set on the containing stack for this to work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupSupportedAzs(java.lang.Boolean lookupSupportedAzs) {
            this.lookupSupportedAzs = lookupSupportedAzs;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getOpen}
         * @param open Whether to automatically allow VPC traffic to the endpoint.
         *             If enabled, all traffic to the endpoint from within the VPC will be
         *             automatically allowed. This is done based on the VPC's CIDR range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getPrivateDnsEnabled}
         * @param privateDnsEnabled Whether to associate a private hosted zone with the specified VPC.
         *                          This
         *                          allows you to make requests to the service using its default DNS hostname.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getSecurityGroups}
         * @param securityGroups The security groups to associate with this interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointProps#getSubnets}
         * @param subnets The subnets in which to create an endpoint network interface.
         *                At most one
         *                per availability zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InterfaceVpcEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private final java.lang.Boolean lookupSupportedAzs;
        private final java.lang.Boolean open;
        private final java.lang.Boolean privateDnsEnabled;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class));
            this.lookupSupportedAzs = software.amazon.jsii.Kernel.get(this, "lookupSupportedAzs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.open = software.amazon.jsii.Kernel.get(this, "open", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.privateDnsEnabled = software.amazon.jsii.Kernel.get(this, "privateDnsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.lookupSupportedAzs = builder.lookupSupportedAzs;
            this.open = builder.open;
            this.privateDnsEnabled = builder.privateDnsEnabled;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnets = builder.subnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public final java.lang.Boolean getLookupSupportedAzs() {
            return this.lookupSupportedAzs;
        }

        @Override
        public final java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public final java.lang.Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.subnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getLookupSupportedAzs() != null) {
                data.set("lookupSupportedAzs", om.valueToTree(this.getLookupSupportedAzs()));
            }
            if (this.getOpen() != null) {
                data.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InterfaceVpcEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointProps.Jsii$Proxy that = (InterfaceVpcEndpointProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (!service.equals(that.service)) return false;
            if (this.lookupSupportedAzs != null ? !this.lookupSupportedAzs.equals(that.lookupSupportedAzs) : that.lookupSupportedAzs != null) return false;
            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.lookupSupportedAzs != null ? this.lookupSupportedAzs.hashCode() : 0);
            result = 31 * result + (this.open != null ? this.open.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
