package software.amazon.awscdk.services.ec2;

/**
 * Options when constructing UserData for Linux.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * LinuxUserDataOptions linuxUserDataOptions = LinuxUserDataOptions.builder()
 *         .shebang("shebang")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-09T19:16:37.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LinuxUserDataOptions")
@software.amazon.jsii.Jsii.Proxy(LinuxUserDataOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LinuxUserDataOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Shebang for the UserData script.
     * <p>
     * Default: "#!/bin/bash"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShebang() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LinuxUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LinuxUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LinuxUserDataOptions> {
        java.lang.String shebang;

        /**
         * Sets the value of {@link LinuxUserDataOptions#getShebang}
         * @param shebang Shebang for the UserData script.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shebang(java.lang.String shebang) {
            this.shebang = shebang;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LinuxUserDataOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LinuxUserDataOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LinuxUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxUserDataOptions {
        private final java.lang.String shebang;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.shebang = software.amazon.jsii.Kernel.get(this, "shebang", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.shebang = builder.shebang;
        }

        @Override
        public final java.lang.String getShebang() {
            return this.shebang;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getShebang() != null) {
                data.set("shebang", om.valueToTree(this.getShebang()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.LinuxUserDataOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LinuxUserDataOptions.Jsii$Proxy that = (LinuxUserDataOptions.Jsii$Proxy) o;

            return this.shebang != null ? this.shebang.equals(that.shebang) : that.shebang == null;
        }

        @Override
        public final int hashCode() {
            int result = this.shebang != null ? this.shebang.hashCode() : 0;
            return result;
        }
    }
}
