package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnNetworkInterfacePermission`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInterfacePermissionProps cfnNetworkInterfacePermissionProps = CfnNetworkInterfacePermissionProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .networkInterfaceId("networkInterfaceId")
 *         .permission("permission")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:14.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInterfacePermissionProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInterfacePermissionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkInterfacePermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ID of the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceId();

    /**
     * The type of permission to grant: `INSTANCE-ATTACH` or `EIP-ASSOCIATE` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermission();

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkInterfacePermissionProps> {
        java.lang.String awsAccountId;
        java.lang.String networkInterfaceId;
        java.lang.String permission;

        /**
         * Sets the value of {@link CfnNetworkInterfacePermissionProps#getAwsAccountId}
         * @param awsAccountId The AWS account ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfacePermissionProps#getNetworkInterfaceId}
         * @param networkInterfaceId The ID of the network interface. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfacePermissionProps#getPermission}
         * @param permission The type of permission to grant: `INSTANCE-ATTACH` or `EIP-ASSOCIATE` . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permission(java.lang.String permission) {
            this.permission = permission;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfacePermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkInterfacePermissionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInterfacePermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInterfacePermissionProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String permission;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.networkInterfaceId = java.util.Objects.requireNonNull(builder.networkInterfaceId, "networkInterfaceId is required");
            this.permission = java.util.Objects.requireNonNull(builder.permission, "permission is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final java.lang.String getPermission() {
            return this.permission;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            data.set("permission", om.valueToTree(this.getPermission()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInterfacePermissionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInterfacePermissionProps.Jsii$Proxy that = (CfnNetworkInterfacePermissionProps.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            return this.permission.equals(that.permission);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.permission.hashCode());
            return result;
        }
    }
}
