package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnSubnet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object privateDnsNameOptionsOnLaunch;
 * CfnSubnetProps cfnSubnetProps = CfnSubnetProps.builder()
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .assignIpv6AddressOnCreation(false)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .cidrBlock("cidrBlock")
 *         .enableDns64(false)
 *         .ipv6CidrBlock("ipv6CidrBlock")
 *         .ipv6Native(false)
 *         .mapPublicIpOnLaunch(false)
 *         .outpostArn("outpostArn")
 *         .privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:14.546Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSubnetProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubnetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubnetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the VPC the subnet is in.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssignIpv6AddressOnCreation() {
        return null;
    }

    /**
     * The Availability Zone of the subnet.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The AZ ID of the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return null;
    }

    /**
     * The IPv4 CIDR block assigned to the subnet.
     * <p>
     * If you update this property, we create a new subnet, and then delete the existing one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return null;
    }

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDns64() {
        return null;
    }

    /**
     * The IPv6 CIDR block.
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6CidrBlock() {
        return null;
    }

    /**
     * Indicates whether this is an IPv6 only subnet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Native() {
        return null;
    }

    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * <p>
     * The default value is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMapPublicIpOnLaunch() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsNameOptionsOnLaunch() {
        return null;
    }

    /**
     * Any tags assigned to the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubnetProps> {
        java.lang.String vpcId;
        java.lang.Object assignIpv6AddressOnCreation;
        java.lang.String availabilityZone;
        java.lang.String availabilityZoneId;
        java.lang.String cidrBlock;
        java.lang.Object enableDns64;
        java.lang.String ipv6CidrBlock;
        java.lang.Object ipv6Native;
        java.lang.Object mapPublicIpOnLaunch;
        java.lang.String outpostArn;
        java.lang.Object privateDnsNameOptionsOnLaunch;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSubnetProps#getVpcId}
         * @param vpcId The ID of the VPC the subnet is in. This parameter is required.
         *              If you update this property, you must also update the <code>CidrBlock</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAssignIpv6AddressOnCreation}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
         *                                    If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(java.lang.Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAssignIpv6AddressOnCreation}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is `false` .
         *                                    If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(software.amazon.awscdk.core.IResolvable assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone of the subnet.
         *                         If you update this property, you must also update the <code>CidrBlock</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAvailabilityZoneId}
         * @param availabilityZoneId The AZ ID of the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getCidrBlock}
         * @param cidrBlock The IPv4 CIDR block assigned to the subnet.
         *                  If you update this property, we create a new subnet, and then delete the existing one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getEnableDns64}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *                    For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(java.lang.Boolean enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getEnableDns64}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *                    For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-nat64-dns64">DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(software.amazon.awscdk.core.IResolvable enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6CidrBlock}
         * @param ipv6CidrBlock The IPv6 CIDR block.
         *                      If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify <code>Ipv6CidrBlock</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(java.lang.String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6Native}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet.
         *                   For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(java.lang.Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6Native}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet.
         *                   For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(software.amazon.awscdk.core.IResolvable ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address.
         *                            The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(java.lang.Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address.
         *                            The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(software.amazon.awscdk.core.IResolvable mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getOutpostArn}
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getPrivateDnsNameOptionsOnLaunch}
         * @param privateDnsNameOptionsOnLaunch The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
         *                                      For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptionsOnLaunch(java.lang.Object privateDnsNameOptionsOnLaunch) {
            this.privateDnsNameOptionsOnLaunch = privateDnsNameOptionsOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getTags}
         * @param tags Any tags assigned to the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubnetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubnetProps {
        private final java.lang.String vpcId;
        private final java.lang.Object assignIpv6AddressOnCreation;
        private final java.lang.String availabilityZone;
        private final java.lang.String availabilityZoneId;
        private final java.lang.String cidrBlock;
        private final java.lang.Object enableDns64;
        private final java.lang.String ipv6CidrBlock;
        private final java.lang.Object ipv6Native;
        private final java.lang.Object mapPublicIpOnLaunch;
        private final java.lang.String outpostArn;
        private final java.lang.Object privateDnsNameOptionsOnLaunch;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assignIpv6AddressOnCreation = software.amazon.jsii.Kernel.get(this, "assignIpv6AddressOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableDns64 = software.amazon.jsii.Kernel.get(this, "enableDns64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipv6CidrBlock = software.amazon.jsii.Kernel.get(this, "ipv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Native = software.amazon.jsii.Kernel.get(this, "ipv6Native", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mapPublicIpOnLaunch = software.amazon.jsii.Kernel.get(this, "mapPublicIpOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateDnsNameOptionsOnLaunch = software.amazon.jsii.Kernel.get(this, "privateDnsNameOptionsOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneId = builder.availabilityZoneId;
            this.cidrBlock = builder.cidrBlock;
            this.enableDns64 = builder.enableDns64;
            this.ipv6CidrBlock = builder.ipv6CidrBlock;
            this.ipv6Native = builder.ipv6Native;
            this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
            this.outpostArn = builder.outpostArn;
            this.privateDnsNameOptionsOnLaunch = builder.privateDnsNameOptionsOnLaunch;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Object getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final java.lang.Object getEnableDns64() {
            return this.enableDns64;
        }

        @Override
        public final java.lang.String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final java.lang.Object getIpv6Native() {
            return this.ipv6Native;
        }

        @Override
        public final java.lang.Object getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final java.lang.Object getPrivateDnsNameOptionsOnLaunch() {
            return this.privateDnsNameOptionsOnLaunch;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAssignIpv6AddressOnCreation() != null) {
                data.set("assignIpv6AddressOnCreation", om.valueToTree(this.getAssignIpv6AddressOnCreation()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneId() != null) {
                data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
            }
            if (this.getCidrBlock() != null) {
                data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            }
            if (this.getEnableDns64() != null) {
                data.set("enableDns64", om.valueToTree(this.getEnableDns64()));
            }
            if (this.getIpv6CidrBlock() != null) {
                data.set("ipv6CidrBlock", om.valueToTree(this.getIpv6CidrBlock()));
            }
            if (this.getIpv6Native() != null) {
                data.set("ipv6Native", om.valueToTree(this.getIpv6Native()));
            }
            if (this.getMapPublicIpOnLaunch() != null) {
                data.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }
            if (this.getPrivateDnsNameOptionsOnLaunch() != null) {
                data.set("privateDnsNameOptionsOnLaunch", om.valueToTree(this.getPrivateDnsNameOptionsOnLaunch()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSubnetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubnetProps.Jsii$Proxy that = (CfnSubnetProps.Jsii$Proxy) o;

            if (!vpcId.equals(that.vpcId)) return false;
            if (this.assignIpv6AddressOnCreation != null ? !this.assignIpv6AddressOnCreation.equals(that.assignIpv6AddressOnCreation) : that.assignIpv6AddressOnCreation != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
            if (this.cidrBlock != null ? !this.cidrBlock.equals(that.cidrBlock) : that.cidrBlock != null) return false;
            if (this.enableDns64 != null ? !this.enableDns64.equals(that.enableDns64) : that.enableDns64 != null) return false;
            if (this.ipv6CidrBlock != null ? !this.ipv6CidrBlock.equals(that.ipv6CidrBlock) : that.ipv6CidrBlock != null) return false;
            if (this.ipv6Native != null ? !this.ipv6Native.equals(that.ipv6Native) : that.ipv6Native != null) return false;
            if (this.mapPublicIpOnLaunch != null ? !this.mapPublicIpOnLaunch.equals(that.mapPublicIpOnLaunch) : that.mapPublicIpOnLaunch != null) return false;
            if (this.outpostArn != null ? !this.outpostArn.equals(that.outpostArn) : that.outpostArn != null) return false;
            if (this.privateDnsNameOptionsOnLaunch != null ? !this.privateDnsNameOptionsOnLaunch.equals(that.privateDnsNameOptionsOnLaunch) : that.privateDnsNameOptionsOnLaunch != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcId.hashCode();
            result = 31 * result + (this.assignIpv6AddressOnCreation != null ? this.assignIpv6AddressOnCreation.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
            result = 31 * result + (this.cidrBlock != null ? this.cidrBlock.hashCode() : 0);
            result = 31 * result + (this.enableDns64 != null ? this.enableDns64.hashCode() : 0);
            result = 31 * result + (this.ipv6CidrBlock != null ? this.ipv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.ipv6Native != null ? this.ipv6Native.hashCode() : 0);
            result = 31 * result + (this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            result = 31 * result + (this.privateDnsNameOptionsOnLaunch != null ? this.privateDnsNameOptionsOnLaunch.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
