package software.amazon.awscdk.services.ec2;

/**
 * Configuration for Vpc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * Vpc vpc = Vpc.Builder.create(this, "Vpc")
 *         .cidr("10.0.0.0/16")
 *         .build();
 * VpcConnector vpcConnector = VpcConnector.Builder.create(this, "VpcConnector")
 *         .vpc(vpc)
 *         .vpcSubnets(vpc.selectSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build()))
 *         .vpcConnectorName("MyVpcConnector")
 *         .build();
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromEcrPublic(EcrPublicProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(8000).build())
 *                 .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                 .build()))
 *         .vpcConnector(vpcConnector)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:14.928Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcProps")
@software.amazon.jsii.Jsii.Proxy(VpcProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
     * <p>
     * Should be a minimum of /28 and maximum size of /16. The range will be
     * split across all subnets per Availability Zone.
     * <p>
     * Default: Vpc.DEFAULT_CIDR_RANGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidr() {
        return null;
    }

    /**
     * The default tenancy of instances launched into the VPC.
     * <p>
     * By setting this to dedicated tenancy, instances will be launched on
     * hardware dedicated to a single AWS customer, unless specifically specified
     * at instance launch time. Please note, not all instance types are usable
     * with Dedicated tenancy.
     * <p>
     * Default: DefaultInstanceTenancy.Default (shared) tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
        return null;
    }

    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames.
     * <p>
     * If this attribute is true, instances in the VPC get public DNS hostnames,
     * but only if the enableDnsSupport attribute is also set to true.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDnsHostnames() {
        return null;
    }

    /**
     * Indicates whether the DNS resolution is supported for the VPC.
     * <p>
     * If this attribute is false, the Amazon-provided DNS server in the VPC that
     * resolves public DNS hostnames to IP addresses is not enabled. If this
     * attribute is true, queries to the Amazon provided DNS server at the
     * 169.254.169.253 IP address, or the reserved IP address at the base of the
     * VPC IPv4 network range plus two will succeed.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDnsSupport() {
        return null;
    }

    /**
     * Flow logs to add to this VPC.
     * <p>
     * Default: - No flow logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions> getFlowLogs() {
        return null;
    }

    /**
     * Gateway endpoints to add to this VPC.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints() {
        return null;
    }

    /**
     * Define the maximum number of AZs to use in this region.
     * <p>
     * If the region has more AZs than you want to use (for example, because of
     * EIP limits), pick a lower number here. The AZs will be sorted and picked
     * from the start of the list.
     * <p>
     * If you pick a higher number than the number of AZs in the region, all AZs
     * in the region will be selected. To use "all AZs" available to your
     * account, use a high number (such as 99).
     * <p>
     * Be aware that environment-agnostic stacks will be created with access to
     * only 2 AZs, so to use more than 2 AZs, be sure to specify the account and
     * region on your stack.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAzs() {
        return null;
    }

    /**
     * What type of NAT provider to use.
     * <p>
     * Select between NAT gateways or NAT instances. NAT gateways
     * may not be available in all AWS regions.
     * <p>
     * Default: NatProvider.gateway()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.NatProvider getNatGatewayProvider() {
        return null;
    }

    /**
     * The number of NAT Gateways/Instances to create.
     * <p>
     * The type of NAT gateway or instance will be determined by the
     * <code>natGatewayProvider</code> parameter.
     * <p>
     * You can set this number lower than the number of Availability Zones in your
     * VPC in order to save on NAT cost. Be aware you may be charged for
     * cross-AZ data traffic instead.
     * <p>
     * Default: - One NAT gateway/instance per Availability Zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNatGateways() {
        return null;
    }

    /**
     * Configures the subnets which will have NAT Gateways/Instances.
     * <p>
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     * <p>
     * Only necessary if you have more than one public subnet group.
     * <p>
     * Default: - All public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets() {
        return null;
    }

    /**
     * Configure the subnets to build for each AZ.
     * <p>
     * Each entry in this list configures a Subnet Group; each group will contain a
     * subnet for each Availability Zone.
     * <p>
     * For example, if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * <p>
     * <blockquote><pre>
     * Vpc.Builder.create(this, "VPC")
     *         .subnetConfiguration(List.of(SubnetConfiguration.builder()
     *                 .cidrMask(24)
     *                 .name("ingress")
     *                 .subnetType(SubnetType.PUBLIC)
     *                 .build(), SubnetConfiguration.builder()
     *                 .cidrMask(24)
     *                 .name("application")
     *                 .subnetType(SubnetType.PRIVATE_WITH_NAT)
     *                 .build(), SubnetConfiguration.builder()
     *                 .cidrMask(28)
     *                 .name("rds")
     *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * Default: - The VPC CIDR will be evenly divided between 1 public and 1
     * private subnet per AZ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
        return null;
    }

    /**
     * The VPC name.
     * <p>
     * Since the VPC resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
     * <p>
     * Default: this.node.path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcName() {
        return null;
    }

    /**
     * VPN connections to this VPC.
     * <p>
     * Default: - No connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections() {
        return null;
    }

    /**
     * Indicates whether a VPN gateway should be created and attached to this VPC.
     * <p>
     * Default: - true when vpnGatewayAsn or vpnConnections is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVpnGateway() {
        return null;
    }

    /**
     * The private Autonomous System Number (ASN) for the VPN gateway.
     * <p>
     * Default: - Amazon default ASN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVpnGatewayAsn() {
        return null;
    }

    /**
     * Where to propagate VPN routes.
     * <p>
     * Default: - On the route tables associated with private subnets. If no
     * private subnets exists, isolated subnets are used. If no isolated subnets
     * exists, public subnets are used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcProps> {
        java.lang.String cidr;
        software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy;
        java.lang.Boolean enableDnsHostnames;
        java.lang.Boolean enableDnsSupport;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions> flowLogs;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints;
        java.lang.Number maxAzs;
        software.amazon.awscdk.services.ec2.NatProvider natGatewayProvider;
        java.lang.Number natGateways;
        software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration;
        java.lang.String vpcName;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections;
        java.lang.Boolean vpnGateway;
        java.lang.Number vpnGatewayAsn;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation;

        /**
         * Sets the value of {@link VpcProps#getCidr}
         * @param cidr The CIDR range to use for the VPC, e.g. '10.0.0.0/16'.
         *             Should be a minimum of /28 and maximum size of /16. The range will be
         *             split across all subnets per Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getDefaultInstanceTenancy}
         * @param defaultInstanceTenancy The default tenancy of instances launched into the VPC.
         *                               By setting this to dedicated tenancy, instances will be launched on
         *                               hardware dedicated to a single AWS customer, unless specifically specified
         *                               at instance launch time. Please note, not all instance types are usable
         *                               with Dedicated tenancy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceTenancy(software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy) {
            this.defaultInstanceTenancy = defaultInstanceTenancy;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getEnableDnsHostnames}
         * @param enableDnsHostnames Indicates whether the instances launched in the VPC get public DNS hostnames.
         *                           If this attribute is true, instances in the VPC get public DNS hostnames,
         *                           but only if the enableDnsSupport attribute is also set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsHostnames(java.lang.Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getEnableDnsSupport}
         * @param enableDnsSupport Indicates whether the DNS resolution is supported for the VPC.
         *                         If this attribute is false, the Amazon-provided DNS server in the VPC that
         *                         resolves public DNS hostnames to IP addresses is not enabled. If this
         *                         attribute is true, queries to the Amazon provided DNS server at the
         *                         169.254.169.253 IP address, or the reserved IP address at the base of the
         *                         VPC IPv4 network range plus two will succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDnsSupport(java.lang.Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getFlowLogs}
         * @param flowLogs Flow logs to add to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder flowLogs(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.FlowLogOptions> flowLogs) {
            this.flowLogs = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions>)flowLogs;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getGatewayEndpoints}
         * @param gatewayEndpoints Gateway endpoints to add to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder gatewayEndpoints(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.gatewayEndpoints = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions>)gatewayEndpoints;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getMaxAzs}
         * @param maxAzs Define the maximum number of AZs to use in this region.
         *               If the region has more AZs than you want to use (for example, because of
         *               EIP limits), pick a lower number here. The AZs will be sorted and picked
         *               from the start of the list.
         *               <p>
         *               If you pick a higher number than the number of AZs in the region, all AZs
         *               in the region will be selected. To use "all AZs" available to your
         *               account, use a high number (such as 99).
         *               <p>
         *               Be aware that environment-agnostic stacks will be created with access to
         *               only 2 AZs, so to use more than 2 AZs, be sure to specify the account and
         *               region on your stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAzs(java.lang.Number maxAzs) {
            this.maxAzs = maxAzs;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getNatGatewayProvider}
         * @param natGatewayProvider What type of NAT provider to use.
         *                           Select between NAT gateways or NAT instances. NAT gateways
         *                           may not be available in all AWS regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewayProvider(software.amazon.awscdk.services.ec2.NatProvider natGatewayProvider) {
            this.natGatewayProvider = natGatewayProvider;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getNatGateways}
         * @param natGateways The number of NAT Gateways/Instances to create.
         *                    The type of NAT gateway or instance will be determined by the
         *                    <code>natGatewayProvider</code> parameter.
         *                    <p>
         *                    You can set this number lower than the number of Availability Zones in your
         *                    VPC in order to save on NAT cost. Be aware you may be charged for
         *                    cross-AZ data traffic instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGateways(java.lang.Number natGateways) {
            this.natGateways = natGateways;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getNatGatewaySubnets}
         * @param natGatewaySubnets Configures the subnets which will have NAT Gateways/Instances.
         *                          You can pick a specific group of subnets by specifying the group name;
         *                          the picked subnets must be public subnets.
         *                          <p>
         *                          Only necessary if you have more than one public subnet group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewaySubnets(software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets) {
            this.natGatewaySubnets = natGatewaySubnets;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getSubnetConfiguration}
         * @param subnetConfiguration Configure the subnets to build for each AZ.
         *                            Each entry in this list configures a Subnet Group; each group will contain a
         *                            subnet for each Availability Zone.
         *                            <p>
         *                            For example, if you want 1 public subnet, 1 private subnet, and 1 isolated
         *                            subnet in each AZ provide the following:
         *                            <p>
         *                            <blockquote><pre>
         *                            Vpc.Builder.create(this, "VPC")
         *                                    .subnetConfiguration(List.of(SubnetConfiguration.builder()
         *                                            .cidrMask(24)
         *                                            .name("ingress")
         *                                            .subnetType(SubnetType.PUBLIC)
         *                                            .build(), SubnetConfiguration.builder()
         *                                            .cidrMask(24)
         *                                            .name("application")
         *                                            .subnetType(SubnetType.PRIVATE_WITH_NAT)
         *                                            .build(), SubnetConfiguration.builder()
         *                                            .cidrMask(28)
         *                                            .name("rds")
         *                                            .subnetType(SubnetType.PRIVATE_ISOLATED)
         *                                            .build()))
         *                                    .build();
         *                            </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnetConfiguration(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration) {
            this.subnetConfiguration = (java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration>)subnetConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getVpcName}
         * @param vpcName The VPC name.
         *                Since the VPC resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcName(java.lang.String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getVpnConnections}
         * @param vpnConnections VPN connections to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpnConnections(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections) {
            this.vpnConnections = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions>)vpnConnections;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getVpnGateway}
         * @param vpnGateway Indicates whether a VPN gateway should be created and attached to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGateway(java.lang.Boolean vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getVpnGatewayAsn}
         * @param vpnGatewayAsn The private Autonomous System Number (ASN) for the VPN gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayAsn(java.lang.Number vpnGatewayAsn) {
            this.vpnGatewayAsn = vpnGatewayAsn;
            return this;
        }

        /**
         * Sets the value of {@link VpcProps#getVpnRoutePropagation}
         * @param vpnRoutePropagation Where to propagate VPN routes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpnRoutePropagation(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation) {
            this.vpnRoutePropagation = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpnRoutePropagation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcProps {
        private final java.lang.String cidr;
        private final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy defaultInstanceTenancy;
        private final java.lang.Boolean enableDnsHostnames;
        private final java.lang.Boolean enableDnsSupport;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions> flowLogs;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> gatewayEndpoints;
        private final java.lang.Number maxAzs;
        private final software.amazon.awscdk.services.ec2.NatProvider natGatewayProvider;
        private final java.lang.Number natGateways;
        private final software.amazon.awscdk.services.ec2.SubnetSelection natGatewaySubnets;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> subnetConfiguration;
        private final java.lang.String vpcName;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> vpnConnections;
        private final java.lang.Boolean vpnGateway;
        private final java.lang.Number vpnGatewayAsn;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpnRoutePropagation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultInstanceTenancy = software.amazon.jsii.Kernel.get(this, "defaultInstanceTenancy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class));
            this.enableDnsHostnames = software.amazon.jsii.Kernel.get(this, "enableDnsHostnames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableDnsSupport = software.amazon.jsii.Kernel.get(this, "enableDnsSupport", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.flowLogs = software.amazon.jsii.Kernel.get(this, "flowLogs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogOptions.class)));
            this.gatewayEndpoints = software.amazon.jsii.Kernel.get(this, "gatewayEndpoints", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions.class)));
            this.maxAzs = software.amazon.jsii.Kernel.get(this, "maxAzs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.natGatewayProvider = software.amazon.jsii.Kernel.get(this, "natGatewayProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.NatProvider.class));
            this.natGateways = software.amazon.jsii.Kernel.get(this, "natGateways", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.natGatewaySubnets = software.amazon.jsii.Kernel.get(this, "natGatewaySubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.subnetConfiguration = software.amazon.jsii.Kernel.get(this, "subnetConfiguration", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetConfiguration.class)));
            this.vpcName = software.amazon.jsii.Kernel.get(this, "vpcName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnConnections = software.amazon.jsii.Kernel.get(this, "vpnConnections", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpnConnectionOptions.class)));
            this.vpnGateway = software.amazon.jsii.Kernel.get(this, "vpnGateway", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpnGatewayAsn = software.amazon.jsii.Kernel.get(this, "vpnGatewayAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpnRoutePropagation = software.amazon.jsii.Kernel.get(this, "vpnRoutePropagation", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = builder.cidr;
            this.defaultInstanceTenancy = builder.defaultInstanceTenancy;
            this.enableDnsHostnames = builder.enableDnsHostnames;
            this.enableDnsSupport = builder.enableDnsSupport;
            this.flowLogs = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions>)builder.flowLogs;
            this.gatewayEndpoints = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions>)builder.gatewayEndpoints;
            this.maxAzs = builder.maxAzs;
            this.natGatewayProvider = builder.natGatewayProvider;
            this.natGateways = builder.natGateways;
            this.natGatewaySubnets = builder.natGatewaySubnets;
            this.subnetConfiguration = (java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration>)builder.subnetConfiguration;
            this.vpcName = builder.vpcName;
            this.vpnConnections = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions>)builder.vpnConnections;
            this.vpnGateway = builder.vpnGateway;
            this.vpnGatewayAsn = builder.vpnGatewayAsn;
            this.vpnRoutePropagation = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.vpnRoutePropagation;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this.defaultInstanceTenancy;
        }

        @Override
        public final java.lang.Boolean getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public final java.lang.Boolean getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.FlowLogOptions> getFlowLogs() {
            return this.flowLogs;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints() {
            return this.gatewayEndpoints;
        }

        @Override
        public final java.lang.Number getMaxAzs() {
            return this.maxAzs;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.NatProvider getNatGatewayProvider() {
            return this.natGatewayProvider;
        }

        @Override
        public final java.lang.Number getNatGateways() {
            return this.natGateways;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets() {
            return this.natGatewaySubnets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this.subnetConfiguration;
        }

        @Override
        public final java.lang.String getVpcName() {
            return this.vpcName;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections() {
            return this.vpnConnections;
        }

        @Override
        public final java.lang.Boolean getVpnGateway() {
            return this.vpnGateway;
        }

        @Override
        public final java.lang.Number getVpnGatewayAsn() {
            return this.vpnGatewayAsn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation() {
            return this.vpnRoutePropagation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCidr() != null) {
                data.set("cidr", om.valueToTree(this.getCidr()));
            }
            if (this.getDefaultInstanceTenancy() != null) {
                data.set("defaultInstanceTenancy", om.valueToTree(this.getDefaultInstanceTenancy()));
            }
            if (this.getEnableDnsHostnames() != null) {
                data.set("enableDnsHostnames", om.valueToTree(this.getEnableDnsHostnames()));
            }
            if (this.getEnableDnsSupport() != null) {
                data.set("enableDnsSupport", om.valueToTree(this.getEnableDnsSupport()));
            }
            if (this.getFlowLogs() != null) {
                data.set("flowLogs", om.valueToTree(this.getFlowLogs()));
            }
            if (this.getGatewayEndpoints() != null) {
                data.set("gatewayEndpoints", om.valueToTree(this.getGatewayEndpoints()));
            }
            if (this.getMaxAzs() != null) {
                data.set("maxAzs", om.valueToTree(this.getMaxAzs()));
            }
            if (this.getNatGatewayProvider() != null) {
                data.set("natGatewayProvider", om.valueToTree(this.getNatGatewayProvider()));
            }
            if (this.getNatGateways() != null) {
                data.set("natGateways", om.valueToTree(this.getNatGateways()));
            }
            if (this.getNatGatewaySubnets() != null) {
                data.set("natGatewaySubnets", om.valueToTree(this.getNatGatewaySubnets()));
            }
            if (this.getSubnetConfiguration() != null) {
                data.set("subnetConfiguration", om.valueToTree(this.getSubnetConfiguration()));
            }
            if (this.getVpcName() != null) {
                data.set("vpcName", om.valueToTree(this.getVpcName()));
            }
            if (this.getVpnConnections() != null) {
                data.set("vpnConnections", om.valueToTree(this.getVpnConnections()));
            }
            if (this.getVpnGateway() != null) {
                data.set("vpnGateway", om.valueToTree(this.getVpnGateway()));
            }
            if (this.getVpnGatewayAsn() != null) {
                data.set("vpnGatewayAsn", om.valueToTree(this.getVpnGatewayAsn()));
            }
            if (this.getVpnRoutePropagation() != null) {
                data.set("vpnRoutePropagation", om.valueToTree(this.getVpnRoutePropagation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpcProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcProps.Jsii$Proxy that = (VpcProps.Jsii$Proxy) o;

            if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) return false;
            if (this.defaultInstanceTenancy != null ? !this.defaultInstanceTenancy.equals(that.defaultInstanceTenancy) : that.defaultInstanceTenancy != null) return false;
            if (this.enableDnsHostnames != null ? !this.enableDnsHostnames.equals(that.enableDnsHostnames) : that.enableDnsHostnames != null) return false;
            if (this.enableDnsSupport != null ? !this.enableDnsSupport.equals(that.enableDnsSupport) : that.enableDnsSupport != null) return false;
            if (this.flowLogs != null ? !this.flowLogs.equals(that.flowLogs) : that.flowLogs != null) return false;
            if (this.gatewayEndpoints != null ? !this.gatewayEndpoints.equals(that.gatewayEndpoints) : that.gatewayEndpoints != null) return false;
            if (this.maxAzs != null ? !this.maxAzs.equals(that.maxAzs) : that.maxAzs != null) return false;
            if (this.natGatewayProvider != null ? !this.natGatewayProvider.equals(that.natGatewayProvider) : that.natGatewayProvider != null) return false;
            if (this.natGateways != null ? !this.natGateways.equals(that.natGateways) : that.natGateways != null) return false;
            if (this.natGatewaySubnets != null ? !this.natGatewaySubnets.equals(that.natGatewaySubnets) : that.natGatewaySubnets != null) return false;
            if (this.subnetConfiguration != null ? !this.subnetConfiguration.equals(that.subnetConfiguration) : that.subnetConfiguration != null) return false;
            if (this.vpcName != null ? !this.vpcName.equals(that.vpcName) : that.vpcName != null) return false;
            if (this.vpnConnections != null ? !this.vpnConnections.equals(that.vpnConnections) : that.vpnConnections != null) return false;
            if (this.vpnGateway != null ? !this.vpnGateway.equals(that.vpnGateway) : that.vpnGateway != null) return false;
            if (this.vpnGatewayAsn != null ? !this.vpnGatewayAsn.equals(that.vpnGatewayAsn) : that.vpnGatewayAsn != null) return false;
            return this.vpnRoutePropagation != null ? this.vpnRoutePropagation.equals(that.vpnRoutePropagation) : that.vpnRoutePropagation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cidr != null ? this.cidr.hashCode() : 0;
            result = 31 * result + (this.defaultInstanceTenancy != null ? this.defaultInstanceTenancy.hashCode() : 0);
            result = 31 * result + (this.enableDnsHostnames != null ? this.enableDnsHostnames.hashCode() : 0);
            result = 31 * result + (this.enableDnsSupport != null ? this.enableDnsSupport.hashCode() : 0);
            result = 31 * result + (this.flowLogs != null ? this.flowLogs.hashCode() : 0);
            result = 31 * result + (this.gatewayEndpoints != null ? this.gatewayEndpoints.hashCode() : 0);
            result = 31 * result + (this.maxAzs != null ? this.maxAzs.hashCode() : 0);
            result = 31 * result + (this.natGatewayProvider != null ? this.natGatewayProvider.hashCode() : 0);
            result = 31 * result + (this.natGateways != null ? this.natGateways.hashCode() : 0);
            result = 31 * result + (this.natGatewaySubnets != null ? this.natGatewaySubnets.hashCode() : 0);
            result = 31 * result + (this.subnetConfiguration != null ? this.subnetConfiguration.hashCode() : 0);
            result = 31 * result + (this.vpcName != null ? this.vpcName.hashCode() : 0);
            result = 31 * result + (this.vpnConnections != null ? this.vpnConnections.hashCode() : 0);
            result = 31 * result + (this.vpnGateway != null ? this.vpnGateway.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayAsn != null ? this.vpnGatewayAsn.hashCode() : 0);
            result = 31 * result + (this.vpnRoutePropagation != null ? this.vpnRoutePropagation.hashCode() : 0);
            return result;
        }
    }
}
