package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SecurityGroupEgress`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.640Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroupEgressProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityGroupEgressProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnSecurityGroupEgressProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getGroupId();

    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIpProtocol();

    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getCidrIp() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getCidrIpv6() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDestinationPrefixListId() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDestinationSecurityGroupId() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getFromPort() {
        return null;
    }

    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getToPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String groupId;
        private java.lang.String ipProtocol;
        private java.lang.String cidrIp;
        private java.lang.String cidrIpv6;
        private java.lang.String description;
        private java.lang.String destinationPrefixListId;
        private java.lang.String destinationSecurityGroupId;
        private java.lang.Number fromPort;
        private java.lang.Number toPort;

        /**
         * Sets the value of GroupId
         * @param groupId `AWS::EC2::SecurityGroupEgress.GroupId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Sets the value of IpProtocol
         * @param ipProtocol `AWS::EC2::SecurityGroupEgress.IpProtocol`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipProtocol(java.lang.String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        /**
         * Sets the value of CidrIp
         * @param cidrIp `AWS::EC2::SecurityGroupEgress.CidrIp`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrIp(java.lang.String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        /**
         * Sets the value of CidrIpv6
         * @param cidrIpv6 `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrIpv6(java.lang.String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::EC2::SecurityGroupEgress.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DestinationPrefixListId
         * @param destinationPrefixListId `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        /**
         * Sets the value of DestinationSecurityGroupId
         * @param destinationSecurityGroupId `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationSecurityGroupId(java.lang.String destinationSecurityGroupId) {
            this.destinationSecurityGroupId = destinationSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of FromPort
         * @param fromPort `AWS::EC2::SecurityGroupEgress.FromPort`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder fromPort(java.lang.Number fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        /**
         * Sets the value of ToPort
         * @param toPort `AWS::EC2::SecurityGroupEgress.ToPort`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder toPort(java.lang.Number toPort) {
            this.toPort = toPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityGroupEgressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnSecurityGroupEgressProps build() {
            return new Jsii$Proxy(groupId, ipProtocol, cidrIp, cidrIpv6, description, destinationPrefixListId, destinationSecurityGroupId, fromPort, toPort);
        }
    }

    /**
     * An implementation for {@link CfnSecurityGroupEgressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityGroupEgressProps {
        private final java.lang.String groupId;
        private final java.lang.String ipProtocol;
        private final java.lang.String cidrIp;
        private final java.lang.String cidrIpv6;
        private final java.lang.String description;
        private final java.lang.String destinationPrefixListId;
        private final java.lang.String destinationSecurityGroupId;
        private final java.lang.Number fromPort;
        private final java.lang.Number toPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupId = this.jsiiGet("groupId", java.lang.String.class);
            this.ipProtocol = this.jsiiGet("ipProtocol", java.lang.String.class);
            this.cidrIp = this.jsiiGet("cidrIp", java.lang.String.class);
            this.cidrIpv6 = this.jsiiGet("cidrIpv6", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.destinationPrefixListId = this.jsiiGet("destinationPrefixListId", java.lang.String.class);
            this.destinationSecurityGroupId = this.jsiiGet("destinationSecurityGroupId", java.lang.String.class);
            this.fromPort = this.jsiiGet("fromPort", java.lang.Number.class);
            this.toPort = this.jsiiGet("toPort", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String groupId, final java.lang.String ipProtocol, final java.lang.String cidrIp, final java.lang.String cidrIpv6, final java.lang.String description, final java.lang.String destinationPrefixListId, final java.lang.String destinationSecurityGroupId, final java.lang.Number fromPort, final java.lang.Number toPort) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupId = java.util.Objects.requireNonNull(groupId, "groupId is required");
            this.ipProtocol = java.util.Objects.requireNonNull(ipProtocol, "ipProtocol is required");
            this.cidrIp = cidrIp;
            this.cidrIpv6 = cidrIpv6;
            this.description = description;
            this.destinationPrefixListId = destinationPrefixListId;
            this.destinationSecurityGroupId = destinationSecurityGroupId;
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        @Override
        public java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        public java.lang.String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public java.lang.String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public java.lang.String getCidrIpv6() {
            return this.cidrIpv6;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        @Override
        public java.lang.String getDestinationSecurityGroupId() {
            return this.destinationSecurityGroupId;
        }

        @Override
        public java.lang.Number getFromPort() {
            return this.fromPort;
        }

        @Override
        public java.lang.Number getToPort() {
            return this.toPort;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupId", om.valueToTree(this.getGroupId()));
            data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
            if (this.getCidrIp() != null) {
                data.set("cidrIp", om.valueToTree(this.getCidrIp()));
            }
            if (this.getCidrIpv6() != null) {
                data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDestinationPrefixListId() != null) {
                data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
            }
            if (this.getDestinationSecurityGroupId() != null) {
                data.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
            }
            if (this.getFromPort() != null) {
                data.set("fromPort", om.valueToTree(this.getFromPort()));
            }
            if (this.getToPort() != null) {
                data.set("toPort", om.valueToTree(this.getToPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSecurityGroupEgressProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityGroupEgressProps.Jsii$Proxy that = (CfnSecurityGroupEgressProps.Jsii$Proxy) o;

            if (!groupId.equals(that.groupId)) return false;
            if (!ipProtocol.equals(that.ipProtocol)) return false;
            if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
            if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
            if (this.destinationSecurityGroupId != null ? !this.destinationSecurityGroupId.equals(that.destinationSecurityGroupId) : that.destinationSecurityGroupId != null) return false;
            if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
            return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
        }

        @Override
        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + (this.ipProtocol.hashCode());
            result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
            result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
            result = 31 * result + (this.destinationSecurityGroupId != null ? this.destinationSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
            result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
            return result;
        }
    }
}
