package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::VPC`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPC")
public class CfnVPC extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVPC(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPC(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPC.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::VPC`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnVPC(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnVPCProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrCidrBlock() {
        return this.jsiiGet("attrCidrBlock", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAttrCidrBlockAssociations() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("attrCidrBlockAssociations", java.util.List.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDefaultNetworkAcl() {
        return this.jsiiGet("attrDefaultNetworkAcl", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDefaultSecurityGroup() {
        return this.jsiiGet("attrDefaultSecurityGroup", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAttrIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("attrIpv6CidrBlocks", java.util.List.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::EC2::VPC.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::VPC.CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCidrBlock() {
        return this.jsiiGet("cidrBlock", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPC.CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCidrBlock(final java.lang.String value) {
        this.jsiiSet("cidrBlock", java.util.Objects.requireNonNull(value, "cidrBlock is required"));
    }

    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEnableDnsHostnames() {
        return this.jsiiGet("enableDnsHostnames", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnableDnsHostnames(final java.lang.Boolean value) {
        this.jsiiSet("enableDnsHostnames", value);
    }

    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnableDnsHostnames(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("enableDnsHostnames", value);
    }

    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEnableDnsSupport() {
        return this.jsiiGet("enableDnsSupport", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnableDnsSupport(final java.lang.Boolean value) {
        this.jsiiSet("enableDnsSupport", value);
    }

    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnableDnsSupport(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("enableDnsSupport", value);
    }

    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getInstanceTenancy() {
        return this.jsiiGet("instanceTenancy", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceTenancy(final java.lang.String value) {
        this.jsiiSet("instanceTenancy", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPC}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVPCProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVPCProps.Builder();
        }

        /**
         * @return {@code this}
         * @param cidrBlock `AWS::EC2::VPC.CidrBlock`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * @return {@code this}
         * @param enableDnsHostnames `AWS::EC2::VPC.EnableDnsHostnames`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsHostnames(final java.lang.Boolean enableDnsHostnames) {
            this.props.enableDnsHostnames(enableDnsHostnames);
            return this;
        }
        /**
         * @return {@code this}
         * @param enableDnsHostnames `AWS::EC2::VPC.EnableDnsHostnames`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsHostnames(final software.amazon.awscdk.core.IResolvable enableDnsHostnames) {
            this.props.enableDnsHostnames(enableDnsHostnames);
            return this;
        }

        /**
         * @return {@code this}
         * @param enableDnsSupport `AWS::EC2::VPC.EnableDnsSupport`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsSupport(final java.lang.Boolean enableDnsSupport) {
            this.props.enableDnsSupport(enableDnsSupport);
            return this;
        }
        /**
         * @return {@code this}
         * @param enableDnsSupport `AWS::EC2::VPC.EnableDnsSupport`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsSupport(final software.amazon.awscdk.core.IResolvable enableDnsSupport) {
            this.props.enableDnsSupport(enableDnsSupport);
            return this;
        }

        /**
         * @return {@code this}
         * @param instanceTenancy `AWS::EC2::VPC.InstanceTenancy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceTenancy(final java.lang.String instanceTenancy) {
            this.props.instanceTenancy(instanceTenancy);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::EC2::VPC.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPC}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnVPC build() {
            return new software.amazon.awscdk.services.ec2.CfnVPC(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
