package software.amazon.awscdk.services.ec2;

/**
 * Define a new custom network ACL.
 * 
 * By default, will deny all inbound and outbound traffic unless entries are
 * added explicitly allowing it.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NetworkAcl")
public class NetworkAcl extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.INetworkAcl {

    protected NetworkAcl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkAcl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public NetworkAcl(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.NetworkAclProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing NetworkAcl into this app.
     * 
     * EXPERIMENTAL
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param networkAclId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.ec2.INetworkAcl fromNetworkAclId(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String networkAclId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.NetworkAcl.class, "fromNetworkAclId", software.amazon.awscdk.services.ec2.INetworkAcl.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkAclId, "networkAclId is required") });
    }

    /**
     * Add a new entry to the ACL.
     * 
     * EXPERIMENTAL
     * 
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.ec2.NetworkAclEntry addEntry(final java.lang.String id, final software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions options) {
        return this.jsiiCall("addEntry", software.amazon.awscdk.services.ec2.NetworkAclEntry.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Associate the ACL with a given set of subnets.
     * 
     * EXPERIMENTAL
     * 
     * @param id This parameter is required.
     * @param selection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void associateWithSubnet(final java.lang.String id, final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        this.jsiiCall("associateWithSubnet", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(selection, "selection is required") });
    }

    /**
     * The ID of the NetworkACL.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getNetworkAclId() {
        return this.jsiiGet("networkAclId", java.lang.String.class);
    }

    /**
     * The VPC ID for this NetworkACL.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getNetworkAclVpcId() {
        return this.jsiiGet("networkAclVpcId", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.NetworkAcl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.NetworkAclProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.NetworkAclProps.Builder();
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param vpc The VPC in which to create the NetworkACL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param networkAclName The name of the NetworkAcl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAclName(final java.lang.String networkAclName) {
            this.props.networkAclName(networkAclName);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param subnetSelection Subnets in the given VPC to associate the ACL with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.NetworkAcl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ec2.NetworkAcl build() {
            return new software.amazon.awscdk.services.ec2.NetworkAcl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
