/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnClientVpnEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnClientVpnEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClientVpnEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnClientVpnEndpoint(Construct scope, String id, CfnClientVpnEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public Object getAuthenticationOptions() {
        return this.jsiiGet("authenticationOptions", Object.class);
    }

    public void setAuthenticationOptions(IResolvable value) {
        this.jsiiSet("authenticationOptions", Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    public void setAuthenticationOptions(List<Object> value) {
        this.jsiiSet("authenticationOptions", Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    public String getClientCidrBlock() {
        return (String)this.jsiiGet("clientCidrBlock", String.class);
    }

    public void setClientCidrBlock(String value) {
        this.jsiiSet("clientCidrBlock", Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    public Object getConnectionLogOptions() {
        return this.jsiiGet("connectionLogOptions", Object.class);
    }

    public void setConnectionLogOptions(IResolvable value) {
        this.jsiiSet("connectionLogOptions", Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    public void setConnectionLogOptions(ConnectionLogOptionsProperty value) {
        this.jsiiSet("connectionLogOptions", Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    public String getServerCertificateArn() {
        return (String)this.jsiiGet("serverCertificateArn", String.class);
    }

    public void setServerCertificateArn(String value) {
        this.jsiiSet("serverCertificateArn", Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(String value) {
        this.jsiiSet("description", value);
    }

    public List<String> getDnsServers() {
        return Collections.unmodifiableList((List)this.jsiiGet("dnsServers", List.class));
    }

    public void setDnsServers(List<String> value) {
        this.jsiiSet("dnsServers", value);
    }

    public Object getSplitTunnel() {
        return this.jsiiGet("splitTunnel", Object.class);
    }

    public void setSplitTunnel(Boolean value) {
        this.jsiiSet("splitTunnel", value);
    }

    public void setSplitTunnel(IResolvable value) {
        this.jsiiSet("splitTunnel", value);
    }

    public Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", Object.class);
    }

    public void setTagSpecifications(IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    public void setTagSpecifications(List<Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    public String getTransportProtocol() {
        return (String)this.jsiiGet("transportProtocol", String.class);
    }

    public void setTransportProtocol(String value) {
        this.jsiiSet("transportProtocol", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnClientVpnEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClientVpnEndpointProps.Builder();
        }

        public Builder authenticationOptions(IResolvable authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        public Builder authenticationOptions(List<Object> authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        public Builder clientCidrBlock(String clientCidrBlock) {
            this.props.clientCidrBlock(clientCidrBlock);
            return this;
        }

        public Builder connectionLogOptions(IResolvable connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        public Builder connectionLogOptions(ConnectionLogOptionsProperty connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            this.props.serverCertificateArn(serverCertificateArn);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        public Builder splitTunnel(IResolvable splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder tagSpecifications(List<Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder transportProtocol(String transportProtocol) {
            this.props.transportProtocol(transportProtocol);
            return this;
        }

        public CfnClientVpnEndpoint build() {
            return new CfnClientVpnEndpoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DirectoryServiceAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getDirectoryId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String directoryId;

            public Builder directoryId(String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            public DirectoryServiceAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this.directoryId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionLogOptionsProperty
    extends JsiiSerializable {
        public Object getEnabled();

        default public String getCloudwatchLogGroup() {
            return null;
        }

        default public String getCloudwatchLogStream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object enabled;
            private String cloudwatchLogGroup;
            private String cloudwatchLogStream;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder cloudwatchLogGroup(String cloudwatchLogGroup) {
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                return this;
            }

            public Builder cloudwatchLogStream(String cloudwatchLogStream) {
                this.cloudwatchLogStream = cloudwatchLogStream;
                return this;
            }

            public ConnectionLogOptionsProperty build() {
                return new Jsii.Proxy(this.enabled, this.cloudwatchLogGroup, this.cloudwatchLogStream, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getType();

        default public Object getActiveDirectory() {
            return null;
        }

        default public Object getMutualAuthentication() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;
            private Object activeDirectory;
            private Object mutualAuthentication;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder activeDirectory(IResolvable activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            public Builder activeDirectory(DirectoryServiceAuthenticationRequestProperty activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            public Builder mutualAuthentication(IResolvable mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            public Builder mutualAuthentication(CertificateAuthenticationRequestProperty mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            public ClientAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this.type, this.activeDirectory, this.mutualAuthentication, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CertificateAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getClientRootCertificateChainArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String clientRootCertificateChainArn;

            public Builder clientRootCertificateChainArn(String clientRootCertificateChainArn) {
                this.clientRootCertificateChainArn = clientRootCertificateChainArn;
                return this;
            }

            public CertificateAuthenticationRequestProperty build() {
                return new Jsii.Proxy(this.clientRootCertificateChainArn, null);
            }
        }
    }
}

